/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.event;

import com.github.ysbbbbbb.kaleidoscopedoll.block.DollBlock;
import com.github.ysbbbbbb.kaleidoscopedoll.item.DollItem;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="kaleidoscope_doll", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModRegisterEvent {
    public static final Map<ResourceLocation, DollBlock> DOLL_BLOCKS = Maps.newLinkedHashMap();
    public static final Map<ResourceLocation, String> VANILLA_TOOLTIPS = Maps.newHashMap();
    public static final Map<ResourceLocation, String> SPECIAL_TOOLTIPS = Maps.newHashMap();
    public static final Set<Item> DOLL_ITEMS = Sets.newLinkedHashSet();
    public static final Set<ResourceLocation> AUTHOR_DOLLS = Sets.newHashSet();
    private static final int MAX_DOLL_COUNT = 616;

    private static void registerAllVanillaTooltips() {
        ModRegisterEvent.registerVanillaTooltips("doll_328", "wine_fox");
        ModRegisterEvent.registerVanillaTooltips("doll_329", "dokimobs_warden");
    }

    private static void registerAuthorTooltips() {
        ModRegisterEvent.registerAuthorTooltips("doll_0", "author_ysbb");
        ModRegisterEvent.registerAuthorTooltips("doll_1", "author_tartaric_acid");
        ModRegisterEvent.registerAuthorTooltips("doll_67", "author_abert_cat");
        ModRegisterEvent.registerAuthorTooltips("doll_68", "author_cr_019");
        ModRegisterEvent.registerAuthorTooltips("doll_599", "author_bzdxg");
        ModRegisterEvent.registerAuthorTooltips("doll_600", "author_mly");
        ModRegisterEvent.registerAuthorTooltips("doll_601", "author_yca");
        ModRegisterEvent.registerAuthorTooltips("doll_614", "author_grainalcohol");
    }

    private static void registerAllSpecialTooltips() {
        ModRegisterEvent.registerSpecialTooltips("doll_69", "sponsors_guriformes");
        ModRegisterEvent.registerSpecialTooltips("doll_70", "sponsors_passer1ne");
        ModRegisterEvent.registerSpecialTooltips("doll_71", "sponsors_tanyeng");
        ModRegisterEvent.registerSpecialTooltips("doll_72", "sponsors_airsamafurry");
        ModRegisterEvent.registerSpecialTooltips("doll_73", "sponsors_corleonejing");
        ModRegisterEvent.registerSpecialTooltips("doll_74", "sponsors_kuriyamayasura");
        ModRegisterEvent.registerSpecialTooltips("doll_75", "sponsors_miomilost");
        ModRegisterEvent.registerSpecialTooltips("doll_76", "sponsors_nekonymph");
        ModRegisterEvent.registerSpecialTooltips("doll_77", "sponsors_puerkimiko");
        ModRegisterEvent.registerSpecialTooltips("doll_78", "sponsors_aoisake");
        ModRegisterEvent.registerSpecialTooltips("doll_79", "sponsors_cpcian39");
        ModRegisterEvent.registerSpecialTooltips("doll_80", "sponsors_swordman_live");
        ModRegisterEvent.registerSpecialTooltips("doll_81", "sponsors_tclimuareotin");
        ModRegisterEvent.registerSpecialTooltips("doll_82", "sponsors_taste_puppy");
        ModRegisterEvent.registerSpecialTooltips("doll_83", "sponsors_poetry_chicken");
        ModRegisterEvent.registerSpecialTooltips("doll_84", "sponsors_fudge_666");
        ModRegisterEvent.registerSpecialTooltips("doll_85", "sponsors_chair341");
        ModRegisterEvent.registerSpecialTooltips("doll_86", "sponsors_dumnheint");
        ModRegisterEvent.registerSpecialTooltips("doll_87", "sponsors_lilunli");
        ModRegisterEvent.registerSpecialTooltips("doll_88", "sponsors_psbastards");
        ModRegisterEvent.registerSpecialTooltips("doll_89", "sponsors_pysgas");
        ModRegisterEvent.registerSpecialTooltips("doll_90", "sponsors_redflashier");
        ModRegisterEvent.registerSpecialTooltips("doll_91", "sponsors_rsob123");
        ModRegisterEvent.registerSpecialTooltips("doll_92", "sponsors_solareclipseg");
        ModRegisterEvent.registerSpecialTooltips("doll_93", "sponsors_zombiec1107");
        ModRegisterEvent.registerSpecialTooltips("doll_94", "sponsors__moepus_");
        ModRegisterEvent.registerSpecialTooltips("doll_95", "sponsors_ackrf");
        ModRegisterEvent.registerSpecialTooltips("doll_96", "sponsors_chuanchengzi");
        ModRegisterEvent.registerSpecialTooltips("doll_97", "sponsors_deltaex001");
        ModRegisterEvent.registerSpecialTooltips("doll_98", "sponsors_elyasrosedale");
        ModRegisterEvent.registerSpecialTooltips("doll_99", "sponsors_faustduck");
        ModRegisterEvent.registerSpecialTooltips("doll_100", "sponsors_lixu223");
        ModRegisterEvent.registerSpecialTooltips("doll_101", "sponsors_kupurrra");
        ModRegisterEvent.registerSpecialTooltips("doll_102", "sponsors_thjnd");
        ModRegisterEvent.registerSpecialTooltips("doll_103", "sponsors_variant_dk");
        ModRegisterEvent.registerSpecialTooltips("doll_104", "sponsors_yuxiaowan");
        ModRegisterEvent.registerSpecialTooltips("doll_105", "sponsors_bigpear5231");
        ModRegisterEvent.registerSpecialTooltips("doll_106", "sponsors_idlersnacl");
        ModRegisterEvent.registerSpecialTooltips("doll_107", "sponsors_kekmc123");
        ModRegisterEvent.registerSpecialTooltips("doll_108", "sponsors_kizunahovene");
        ModRegisterEvent.registerSpecialTooltips("doll_109", "sponsors_linx");
        ModRegisterEvent.registerSpecialTooltips("doll_110", "sponsors_linx_su");
        ModRegisterEvent.registerSpecialTooltips("doll_111", "sponsors_wyx0714");
        ModRegisterEvent.registerSpecialTooltips("doll_112", "sponsors_xheya_3u3");
        ModRegisterEvent.registerSpecialTooltips("doll_113", "sponsors_1ye_kul");
        ModRegisterEvent.registerSpecialTooltips("doll_114", "sponsors_aleph_2");
        ModRegisterEvent.registerSpecialTooltips("doll_115", "sponsors_apomona");
        ModRegisterEvent.registerSpecialTooltips("doll_116", "sponsors_atkingqvq");
        ModRegisterEvent.registerSpecialTooltips("doll_117", "sponsors_bestshaaku");
        ModRegisterEvent.registerSpecialTooltips("doll_118", "sponsors_blackannin");
        ModRegisterEvent.registerSpecialTooltips("doll_119", "sponsors_ca1_t0u");
        ModRegisterEvent.registerSpecialTooltips("doll_120", "sponsors_catbug");
        ModRegisterEvent.registerSpecialTooltips("doll_121", "sponsors_catjoy6493");
        ModRegisterEvent.registerSpecialTooltips("doll_122", "sponsors_catlikesleep1160");
        ModRegisterEvent.registerSpecialTooltips("doll_123", "sponsors_cdrsimon");
        ModRegisterEvent.registerSpecialTooltips("doll_124", "sponsors_celia4300");
        ModRegisterEvent.registerSpecialTooltips("doll_125", "sponsors_monicanya");
        ModRegisterEvent.registerSpecialTooltips("doll_126", "sponsors_creamtea2542");
        ModRegisterEvent.registerSpecialTooltips("doll_127", "sponsors_cxzkkaa");
        ModRegisterEvent.registerSpecialTooltips("doll_128", "sponsors_dafeimao");
        ModRegisterEvent.registerSpecialTooltips("doll_129", "sponsors_dazhuo1");
        ModRegisterEvent.registerSpecialTooltips("doll_130", "sponsors_dongfang_qian");
        ModRegisterEvent.registerSpecialTooltips("doll_131", "sponsors_eat_grass_");
        ModRegisterEvent.registerSpecialTooltips("doll_132", "sponsors_echoing_phantom");
        ModRegisterEvent.registerSpecialTooltips("doll_133", "sponsors_elex7310");
        ModRegisterEvent.registerSpecialTooltips("doll_134", "sponsors_entropy_yeah");
        ModRegisterEvent.registerSpecialTooltips("doll_135", "sponsors_eteroo44");
        ModRegisterEvent.registerSpecialTooltips("doll_136", "sponsors_fishinblack");
        ModRegisterEvent.registerSpecialTooltips("doll_137", "sponsors_foxxie");
        ModRegisterEvent.registerSpecialTooltips("doll_138", "sponsors_gfboy");
        ModRegisterEvent.registerSpecialTooltips("doll_139", "sponsors_gouzi_jun");
        ModRegisterEvent.registerSpecialTooltips("doll_140", "sponsors_gzq777");
        ModRegisterEvent.registerSpecialTooltips("doll_141", "sponsors_g_papy");
        ModRegisterEvent.registerSpecialTooltips("doll_142", "sponsors_hardypuro");
        ModRegisterEvent.registerSpecialTooltips("doll_143", "sponsors_hinijikata");
        ModRegisterEvent.registerSpecialTooltips("doll_144", "sponsors_ike_sonata");
        ModRegisterEvent.registerSpecialTooltips("doll_145", "sponsors_inky_mad");
        ModRegisterEvent.registerSpecialTooltips("doll_146", "sponsors_jg_aurora");
        ModRegisterEvent.registerSpecialTooltips("doll_147", "sponsors_jia1chen");
        ModRegisterEvent.registerSpecialTooltips("doll_148", "sponsors_jiaqihuang");
        ModRegisterEvent.registerSpecialTooltips("doll_149", "sponsors_jijiwawa");
        ModRegisterEvent.registerSpecialTooltips("doll_150", "sponsors_jm_wuyan");
        ModRegisterEvent.registerSpecialTooltips("doll_151", "sponsors_kaixiaoli_li");
        ModRegisterEvent.registerSpecialTooltips("doll_152", "sponsors_kaltsiit");
        ModRegisterEvent.registerSpecialTooltips("doll_153", "sponsors_kal_crane");
        ModRegisterEvent.registerSpecialTooltips("doll_154", "sponsors_kelvin");
        ModRegisterEvent.registerSpecialTooltips("doll_155", "sponsors_kuiper_hooligans");
        ModRegisterEvent.registerSpecialTooltips("doll_156", "sponsors_lantehall");
        ModRegisterEvent.registerSpecialTooltips("doll_157", "sponsors_legitchunk");
        ModRegisterEvent.registerSpecialTooltips("doll_158", "sponsors_limfx");
        ModRegisterEvent.registerSpecialTooltips("doll_159", "sponsors_lingjinzi");
        ModRegisterEvent.registerSpecialTooltips("doll_160", "sponsors_lingrengui");
        ModRegisterEvent.registerSpecialTooltips("doll_161", "sponsors_ling_e_iswolf");
        ModRegisterEvent.registerSpecialTooltips("doll_162", "sponsors_liulian");
        ModRegisterEvent.registerSpecialTooltips("doll_163", "sponsors_long_shu");
        ModRegisterEvent.registerSpecialTooltips("doll_164", "sponsors_luohammer");
        ModRegisterEvent.registerSpecialTooltips("doll_165", "sponsors_marguarita");
        ModRegisterEvent.registerSpecialTooltips("doll_166", "sponsors_mingqijiang");
        ModRegisterEvent.registerSpecialTooltips("doll_167", "sponsors_miya");
        ModRegisterEvent.registerSpecialTooltips("doll_168", "sponsors_mochcanl");
        ModRegisterEvent.registerSpecialTooltips("doll_169", "sponsors_mtraptrix");
        ModRegisterEvent.registerSpecialTooltips("doll_170", "sponsors_mu_ni_dian");
        ModRegisterEvent.registerSpecialTooltips("doll_171", "sponsors_nigella");
        ModRegisterEvent.registerSpecialTooltips("doll_172", "sponsors_nina_yxj");
        ModRegisterEvent.registerSpecialTooltips("doll_173", "sponsors_nuperaki");
        ModRegisterEvent.registerSpecialTooltips("doll_174", "sponsors_panta_lone");
        ModRegisterEvent.registerSpecialTooltips("doll_175", "sponsors_q821");
        ModRegisterEvent.registerSpecialTooltips("doll_176", "sponsors_qi_qingm");
        ModRegisterEvent.registerSpecialTooltips("doll_177", "sponsors_qxiaochai");
        ModRegisterEvent.registerSpecialTooltips("doll_178", "sponsors_revisorytoast22");
        ModRegisterEvent.registerSpecialTooltips("doll_179", "sponsors_saelens16");
        ModRegisterEvent.registerSpecialTooltips("doll_180", "sponsors_shiinanomashiro");
        ModRegisterEvent.registerSpecialTooltips("doll_181", "sponsors_shovei_");
        ModRegisterEvent.registerSpecialTooltips("doll_182", "sponsors_thirteny13");
        ModRegisterEvent.registerSpecialTooltips("doll_183", "sponsors_thunder50bmg");
        ModRegisterEvent.registerSpecialTooltips("doll_184", "sponsors_trance0203");
        ModRegisterEvent.registerSpecialTooltips("doll_185", "sponsors_usoko");
        ModRegisterEvent.registerSpecialTooltips("doll_186", "sponsors_xian__yue");
        ModRegisterEvent.registerSpecialTooltips("doll_187", "sponsors_xin_yucll");
        ModRegisterEvent.registerSpecialTooltips("doll_188", "sponsors_xlrm");
        ModRegisterEvent.registerSpecialTooltips("doll_189", "sponsors_xuanyou_awa");
        ModRegisterEvent.registerSpecialTooltips("doll_190", "sponsors_xvangezi");
        ModRegisterEvent.registerSpecialTooltips("doll_191", "sponsors_yili_olen");
        ModRegisterEvent.registerSpecialTooltips("doll_192", "sponsors_yuan_fe");
        ModRegisterEvent.registerSpecialTooltips("doll_193", "sponsors_yuroli73");
        ModRegisterEvent.registerSpecialTooltips("doll_194", "sponsors__aorta_");
        ModRegisterEvent.registerSpecialTooltips("doll_195", "sponsors__haman_");
        ModRegisterEvent.registerSpecialTooltips("doll_196", "sponsors_kelvin_0");
        ModRegisterEvent.registerSpecialTooltips("doll_197", "sponsors_sfshuofang");
        ModRegisterEvent.registerSpecialTooltips("doll_198", "sponsors_xvp1563");
        ModRegisterEvent.registerSpecialTooltips("doll_199", "sponsors_swamp_puppy");
        ModRegisterEvent.registerSpecialTooltips("doll_200", "sponsors_aigoth_");
        ModRegisterEvent.registerSpecialTooltips("doll_201", "sponsors_airphen");
        ModRegisterEvent.registerSpecialTooltips("doll_202", "sponsors_a_youyou");
        ModRegisterEvent.registerSpecialTooltips("doll_203", "sponsors_baiseduya");
        ModRegisterEvent.registerSpecialTooltips("doll_204", "sponsors_beankk");
        ModRegisterEvent.registerSpecialTooltips("doll_205", "sponsors_benpao216");
        ModRegisterEvent.registerSpecialTooltips("doll_206", "sponsors_caelumsora");
        ModRegisterEvent.registerSpecialTooltips("doll_207", "sponsors_careep1225");
        ModRegisterEvent.registerSpecialTooltips("doll_208", "sponsors_chan_yang");
        ModRegisterEvent.registerSpecialTooltips("doll_209", "sponsors_chat4455");
        ModRegisterEvent.registerSpecialTooltips("doll_210", "sponsors_claoc");
        ModRegisterEvent.registerSpecialTooltips("doll_211", "sponsors_cn2049");
        ModRegisterEvent.registerSpecialTooltips("doll_212", "sponsors_cubekc");
        ModRegisterEvent.registerSpecialTooltips("doll_213", "sponsors_daichenguanggai");
        ModRegisterEvent.registerSpecialTooltips("doll_214", "sponsors_dfg233");
        ModRegisterEvent.registerSpecialTooltips("doll_215", "sponsors_dx_zimu");
        ModRegisterEvent.registerSpecialTooltips("doll_216", "sponsors_fantasy_sunny");
        ModRegisterEvent.registerSpecialTooltips("doll_217", "sponsors_gui__he");
        ModRegisterEvent.registerSpecialTooltips("doll_218", "sponsors_hayase_gusuri");
        ModRegisterEvent.registerSpecialTooltips("doll_219", "sponsors_hctl62");
        ModRegisterEvent.registerSpecialTooltips("doll_220", "sponsors_jiaojiaofish");
        ModRegisterEvent.registerSpecialTooltips("doll_221", "sponsors_jinwu_mofern");
        ModRegisterEvent.registerSpecialTooltips("doll_222", "sponsors_meow_lynxsea");
        ModRegisterEvent.registerSpecialTooltips("doll_223", "sponsors_misaka18866");
        ModRegisterEvent.registerSpecialTooltips("doll_224", "sponsors_mmhhqwq");
        ModRegisterEvent.registerSpecialTooltips("doll_225", "sponsors_mzuinit");
        ModRegisterEvent.registerSpecialTooltips("doll_226", "sponsors_naci_gt");
        ModRegisterEvent.registerSpecialTooltips("doll_227", "sponsors_niannianan");
        ModRegisterEvent.registerSpecialTooltips("doll_228", "sponsors_only_my_sky");
        ModRegisterEvent.registerSpecialTooltips("doll_229", "sponsors_pumpkin_jn");
        ModRegisterEvent.registerSpecialTooltips("doll_230", "sponsors_purplecomet1793");
        ModRegisterEvent.registerSpecialTooltips("doll_231", "sponsors_qianmoumouuu");
        ModRegisterEvent.registerSpecialTooltips("doll_232", "sponsors_qingxun49");
        ModRegisterEvent.registerSpecialTooltips("doll_233", "sponsors_qmcaaaaa");
        ModRegisterEvent.registerSpecialTooltips("doll_234", "sponsors_qyhumansociety");
        ModRegisterEvent.registerSpecialTooltips("doll_235", "sponsors_reiujiutsuho123");
        ModRegisterEvent.registerSpecialTooltips("doll_236", "sponsors_ru0000");
        ModRegisterEvent.registerSpecialTooltips("doll_237", "sponsors_sekiyama2n");
        ModRegisterEvent.registerSpecialTooltips("doll_238", "sponsors_shanhai_1778");
        ModRegisterEvent.registerSpecialTooltips("doll_239", "sponsors_sheepythecaty");
        ModRegisterEvent.registerSpecialTooltips("doll_240", "sponsors_shirin1214");
        ModRegisterEvent.registerSpecialTooltips("doll_241", "sponsors_sikoishi514");
        ModRegisterEvent.registerSpecialTooltips("doll_242", "sponsors_simulsiho");
        ModRegisterEvent.registerSpecialTooltips("doll_243", "sponsors_sufferay");
        ModRegisterEvent.registerSpecialTooltips("doll_244", "sponsors_surpgenmiko");
        ModRegisterEvent.registerSpecialTooltips("doll_245", "sponsors_taitaitaiya");
        ModRegisterEvent.registerSpecialTooltips("doll_246", "sponsors_taosisi");
        ModRegisterEvent.registerSpecialTooltips("doll_247", "sponsors_tengram");
        ModRegisterEvent.registerSpecialTooltips("doll_248", "sponsors_tianmo369");
        ModRegisterEvent.registerSpecialTooltips("doll_249", "sponsors_vanessa");
        ModRegisterEvent.registerSpecialTooltips("doll_250", "sponsors_vihk");
        ModRegisterEvent.registerSpecialTooltips("doll_251", "sponsors_white_kirby");
        ModRegisterEvent.registerSpecialTooltips("doll_252", "sponsors_woaijiaying123");
        ModRegisterEvent.registerSpecialTooltips("doll_253", "sponsors_wuyu_owo");
        ModRegisterEvent.registerSpecialTooltips("doll_254", "sponsors_xiaaopenng");
        ModRegisterEvent.registerSpecialTooltips("doll_255", "sponsors_kongling");
        ModRegisterEvent.registerSpecialTooltips("doll_256", "sponsors_xxx");
        ModRegisterEvent.registerSpecialTooltips("doll_257", "sponsors_ye_qiufeng");
        ModRegisterEvent.registerSpecialTooltips("doll_258", "sponsors_yongfa");
        ModRegisterEvent.registerSpecialTooltips("doll_259", "sponsors_yue_guan_xing");
        ModRegisterEvent.registerSpecialTooltips("doll_260", "sponsors_zaskgost");
        ModRegisterEvent.registerSpecialTooltips("doll_261", "sponsors__baka_9");
        ModRegisterEvent.registerSpecialTooltips("doll_262", "sponsors_lezhengyinying");
        ModRegisterEvent.registerSpecialTooltips("doll_263", "sponsors_hequanshawu");
        ModRegisterEvent.registerSpecialTooltips("doll_264", "sponsors_zaiqiafandexiaohe_yongzhuang");
        ModRegisterEvent.registerSpecialTooltips("doll_265", "sponsors_xingcaodadi");
        ModRegisterEvent.registerSpecialTooltips("doll_266", "sponsors_fenglingyushi");
        ModRegisterEvent.registerSpecialTooltips("doll_267", "sponsors_cha_jiang");
        ModRegisterEvent.registerSpecialTooltips("doll_268", "sponsors_huanainia");
        ModRegisterEvent.registerSpecialTooltips("doll_269", "sponsors_pyno_lizard");
        ModRegisterEvent.registerSpecialTooltips("doll_270", "sponsors_artek");
        ModRegisterEvent.registerSpecialTooltips("doll_271", "sponsors_hoshino_shiroya");
        ModRegisterEvent.registerSpecialTooltips("doll_272", "sponsors_kluonuoya");
        ModRegisterEvent.registerSpecialTooltips("doll_273", "sponsors_mobile_mercury");
        ModRegisterEvent.registerSpecialTooltips("doll_274", "sponsors_siromizu");
        ModRegisterEvent.registerSpecialTooltips("doll_275", "sponsors_godzilla");
        ModRegisterEvent.registerSpecialTooltips("doll_276", "sponsors_acompaffer");
        ModRegisterEvent.registerSpecialTooltips("doll_277", "sponsors_ayasekou");
        ModRegisterEvent.registerSpecialTooltips("doll_278", "sponsors_bluesunshinecat");
        ModRegisterEvent.registerSpecialTooltips("doll_279", "sponsors_bnndxg");
        ModRegisterEvent.registerSpecialTooltips("doll_280", "sponsors_cn_shemmgdf");
        ModRegisterEvent.registerSpecialTooltips("doll_281", "sponsors_craneoftomorrow");
        ModRegisterEvent.registerSpecialTooltips("doll_282", "sponsors_creakingy");
        ModRegisterEvent.registerSpecialTooltips("doll_283", "sponsors_cyanleaf_ike");
        ModRegisterEvent.registerSpecialTooltips("doll_284", "sponsors_duskymintgear");
        ModRegisterEvent.registerSpecialTooltips("doll_285", "sponsors_enfluenza666");
        ModRegisterEvent.registerSpecialTooltips("doll_286", "sponsors_feapoi");
        ModRegisterEvent.registerSpecialTooltips("doll_287", "sponsors_fengbengqing_");
        ModRegisterEvent.registerSpecialTooltips("doll_288", "sponsors_fumoya1225");
        ModRegisterEvent.registerSpecialTooltips("doll_289", "sponsors_fzin");
        ModRegisterEvent.registerSpecialTooltips("doll_290", "sponsors_gaobai_");
        ModRegisterEvent.registerSpecialTooltips("doll_291", "sponsors_jiugeziqaq");
        ModRegisterEvent.registerSpecialTooltips("doll_292", "sponsors_kami_scarlet");
        ModRegisterEvent.registerSpecialTooltips("doll_293", "sponsors_koisparrow");
        ModRegisterEvent.registerSpecialTooltips("doll_294", "sponsors_kong_bai_ya");
        ModRegisterEvent.registerSpecialTooltips("doll_295", "sponsors_kumu_kia");
        ModRegisterEvent.registerSpecialTooltips("doll_296", "sponsors_lanxingyu520");
        ModRegisterEvent.registerSpecialTooltips("doll_297", "sponsors_lilyt_t");
        ModRegisterEvent.registerSpecialTooltips("doll_298", "sponsors_managerteaa");
        ModRegisterEvent.registerSpecialTooltips("doll_299", "sponsors_mar_lei");
        ModRegisterEvent.registerSpecialTooltips("doll_300", "sponsors_meng_kong");
        ModRegisterEvent.registerSpecialTooltips("doll_301", "sponsors_pandatomatoo");
        ModRegisterEvent.registerSpecialTooltips("doll_302", "sponsors_qfmx");
        ModRegisterEvent.registerSpecialTooltips("doll_303", "sponsors_qianyu7");
        ModRegisterEvent.registerSpecialTooltips("doll_304", "sponsors_qing_qiu_awa");
        ModRegisterEvent.registerSpecialTooltips("doll_305", "sponsors_qqquuuppp");
        ModRegisterEvent.registerSpecialTooltips("doll_306", "sponsors_sansenen_lemon");
        ModRegisterEvent.registerSpecialTooltips("doll_307", "sponsors_sf2403");
        ModRegisterEvent.registerSpecialTooltips("doll_308", "sponsors_snowstar233");
        ModRegisterEvent.registerSpecialTooltips("doll_309", "sponsors_snow_camellia");
        ModRegisterEvent.registerSpecialTooltips("doll_310", "sponsors_sunkenkeep");
        ModRegisterEvent.registerSpecialTooltips("doll_311", "sponsors_xiazhao01");
        ModRegisterEvent.registerSpecialTooltips("doll_312", "sponsors_xuehuren1");
        ModRegisterEvent.registerSpecialTooltips("doll_313", "sponsors_yagaoo00");
        ModRegisterEvent.registerSpecialTooltips("doll_314", "sponsors_yystrawberry0");
        ModRegisterEvent.registerSpecialTooltips("doll_315", "sponsors_z_mauthor");
        ModRegisterEvent.registerSpecialTooltips("doll_316", "sponsors_mingheshuimu");
        ModRegisterEvent.registerSpecialTooltips("doll_317", "sponsors_kehuishoulaji");
        ModRegisterEvent.registerSpecialTooltips("doll_318", "sponsors_liangzimaoeh");
        ModRegisterEvent.registerSpecialTooltips("doll_319", "sponsors_lumiya");
        ModRegisterEvent.registerSpecialTooltips("doll_320", "sponsors_miru_0v0");
        ModRegisterEvent.registerSpecialTooltips("doll_321", "sponsors_qianyue");
        ModRegisterEvent.registerSpecialTooltips("doll_322", "sponsors_zaocha_lanmaoczh");
        ModRegisterEvent.registerSpecialTooltips("doll_323", "sponsors_lfly_a");
        ModRegisterEvent.registerSpecialTooltips("doll_324", "sponsors_lfly_b");
        ModRegisterEvent.registerSpecialTooltips("doll_325", "sponsors_stormsulfur");
        ModRegisterEvent.registerSpecialTooltips("doll_330", "sponsors_7shu1");
        ModRegisterEvent.registerSpecialTooltips("doll_331", "sponsors_89623");
        ModRegisterEvent.registerSpecialTooltips("doll_332", "sponsors_abyssal_fish");
        ModRegisterEvent.registerSpecialTooltips("doll_333", "sponsors_alanwhite2006");
        ModRegisterEvent.registerSpecialTooltips("doll_334", "sponsors_alooooooe");
        ModRegisterEvent.registerSpecialTooltips("doll_335", "sponsors_anananon");
        ModRegisterEvent.registerSpecialTooltips("doll_336", "sponsors_aolanblue");
        ModRegisterEvent.registerSpecialTooltips("doll_337", "sponsors_arknights_siege");
        ModRegisterEvent.registerSpecialTooltips("doll_338", "sponsors_atlantary");
        ModRegisterEvent.registerSpecialTooltips("doll_339", "sponsors_awwwaya");
        ModRegisterEvent.registerSpecialTooltips("doll_340", "sponsors_bei233");
        ModRegisterEvent.registerSpecialTooltips("doll_341", "sponsors_bf_kanata");
        ModRegisterEvent.registerSpecialTooltips("doll_342", "sponsors_birch_wind_pc");
        ModRegisterEvent.registerSpecialTooltips("doll_343", "sponsors_buuuuuai");
        ModRegisterEvent.registerSpecialTooltips("doll_344", "sponsors_chenjiaqwq");
        ModRegisterEvent.registerSpecialTooltips("doll_345", "sponsors_chinana_kamiya");
        ModRegisterEvent.registerSpecialTooltips("doll_346", "sponsors_cloud369ss");
        ModRegisterEvent.registerSpecialTooltips("doll_347", "sponsors_cloudysoft");
        ModRegisterEvent.registerSpecialTooltips("doll_348", "sponsors_cmllzy");
        ModRegisterEvent.registerSpecialTooltips("doll_349", "sponsors_coagu1ate");
        ModRegisterEvent.registerSpecialTooltips("doll_350", "sponsors_co_lxhift");
        ModRegisterEvent.registerSpecialTooltips("doll_351", "sponsors_cygica");
        ModRegisterEvent.registerSpecialTooltips("doll_352", "sponsors_decib77");
        ModRegisterEvent.registerSpecialTooltips("doll_353", "sponsors_diemo_mustard");
        ModRegisterEvent.registerSpecialTooltips("doll_354", "sponsors_doctarisfishing");
        ModRegisterEvent.registerSpecialTooltips("doll_355", "sponsors_dong_fang_yue_yi");
        ModRegisterEvent.registerSpecialTooltips("doll_356", "sponsors_dream_whale");
        ModRegisterEvent.registerSpecialTooltips("doll_357", "sponsors_dwp0623");
        ModRegisterEvent.registerSpecialTooltips("doll_358", "sponsors_efanelmer");
        ModRegisterEvent.registerSpecialTooltips("doll_359", "sponsors_esniene");
        ModRegisterEvent.registerSpecialTooltips("doll_360", "sponsors_etclbe");
        ModRegisterEvent.registerSpecialTooltips("doll_361", "sponsors_evilestars");
        ModRegisterEvent.registerSpecialTooltips("doll_362", "sponsors_firudo_kagaya");
        ModRegisterEvent.registerSpecialTooltips("doll_363", "sponsors_floood");
        ModRegisterEvent.registerSpecialTooltips("doll_364", "sponsors_guonai_qwq");
        ModRegisterEvent.registerSpecialTooltips("doll_365", "sponsors_g_guai");
        ModRegisterEvent.registerSpecialTooltips("doll_366", "sponsors_hamsterbaron");
        ModRegisterEvent.registerSpecialTooltips("doll_367", "sponsors_haqi111");
        ModRegisterEvent.registerSpecialTooltips("doll_368", "sponsors_huai_zou");
        ModRegisterEvent.registerSpecialTooltips("doll_369", "sponsors_hubaier");
        ModRegisterEvent.registerSpecialTooltips("doll_370", "sponsors_h_mengm");
        ModRegisterEvent.registerSpecialTooltips("doll_371", "sponsors_ikun666");
        ModRegisterEvent.registerSpecialTooltips("doll_372", "sponsors_ivy_snu");
        ModRegisterEvent.registerSpecialTooltips("doll_373", "sponsors_jiaupzhuya");
        ModRegisterEvent.registerSpecialTooltips("doll_374", "sponsors_jjxx_s");
        ModRegisterEvent.registerSpecialTooltips("doll_375", "sponsors_komeijiyaku");
        ModRegisterEvent.registerSpecialTooltips("doll_376", "sponsors_kupurrra");
        ModRegisterEvent.registerSpecialTooltips("doll_377", "sponsors_kurudo_");
        ModRegisterEvent.registerSpecialTooltips("doll_378", "sponsors_lamerad");
        ModRegisterEvent.registerSpecialTooltips("doll_379", "sponsors_lankun023");
        ModRegisterEvent.registerSpecialTooltips("doll_380", "sponsors_lch11416");
        ModRegisterEvent.registerSpecialTooltips("doll_381", "sponsors_lchoip");
        ModRegisterEvent.registerSpecialTooltips("doll_382", "sponsors_linzijiang");
        ModRegisterEvent.registerSpecialTooltips("doll_383", "sponsors_lixingyu");
        ModRegisterEvent.registerSpecialTooltips("doll_384", "sponsors_llama_potato");
        ModRegisterEvent.registerSpecialTooltips("doll_385", "sponsors_lon314");
        ModRegisterEvent.registerSpecialTooltips("doll_386", "sponsors_lovely_xier");
        ModRegisterEvent.registerSpecialTooltips("doll_387", "sponsors_lshnoodle");
        ModRegisterEvent.registerSpecialTooltips("doll_388", "sponsors_macbookair0219");
        ModRegisterEvent.registerSpecialTooltips("doll_389", "sponsors_marrytat");
        ModRegisterEvent.registerSpecialTooltips("doll_390", "sponsors_max__payne");
        ModRegisterEvent.registerSpecialTooltips("doll_391", "sponsors_mengitou");
        ModRegisterEvent.registerSpecialTooltips("doll_392", "sponsors_mu_xiaomu");
        ModRegisterEvent.registerSpecialTooltips("doll_393", "sponsors_nainmoon");
        ModRegisterEvent.registerSpecialTooltips("doll_394", "sponsors_normal_sd");
        ModRegisterEvent.registerSpecialTooltips("doll_395", "sponsors_ogeetarclove");
        ModRegisterEvent.registerSpecialTooltips("doll_396", "sponsors_oorionzev");
        ModRegisterEvent.registerSpecialTooltips("doll_397", "sponsors_ovofufu");
        ModRegisterEvent.registerSpecialTooltips("doll_398", "sponsors_probie_123");
        ModRegisterEvent.registerSpecialTooltips("doll_399", "sponsors_qingliu_pro");
        ModRegisterEvent.registerSpecialTooltips("doll_400", "sponsors_qitiang");
        ModRegisterEvent.registerSpecialTooltips("doll_401", "sponsors_qt_tong");
        ModRegisterEvent.registerSpecialTooltips("doll_402", "sponsors_qwq_ender");
        ModRegisterEvent.registerSpecialTooltips("doll_403", "sponsors_qxiaoshp81");
        ModRegisterEvent.registerSpecialTooltips("doll_404", "sponsors_relicnila");
        ModRegisterEvent.registerSpecialTooltips("doll_405", "sponsors_rimuj");
        ModRegisterEvent.registerSpecialTooltips("doll_406", "sponsors_rjmc");
        ModRegisterEvent.registerSpecialTooltips("doll_407", "sponsors_s1mon_l");
        ModRegisterEvent.registerSpecialTooltips("doll_408", "sponsors_savy116");
        ModRegisterEvent.registerSpecialTooltips("doll_409", "sponsors_sharq_r");
        ModRegisterEvent.registerSpecialTooltips("doll_410", "sponsors_shianye");
        ModRegisterEvent.registerSpecialTooltips("doll_411", "sponsors_shirasawa_tobi");
        ModRegisterEvent.registerSpecialTooltips("doll_412", "sponsors_shuzimo");
        ModRegisterEvent.registerSpecialTooltips("doll_413", "sponsors_sierbar");
        ModRegisterEvent.registerSpecialTooltips("doll_414", "sponsors_singleorange");
        ModRegisterEvent.registerSpecialTooltips("doll_415", "sponsors_sisil89");
        ModRegisterEvent.registerSpecialTooltips("doll_416", "sponsors_skdmywife");
        ModRegisterEvent.registerSpecialTooltips("doll_417", "sponsors_slandre");
        ModRegisterEvent.registerSpecialTooltips("doll_418", "sponsors_sugar");
        ModRegisterEvent.registerSpecialTooltips("doll_419", "sponsors_teacher_dai");
        ModRegisterEvent.registerSpecialTooltips("doll_420", "sponsors_venetoquincy");
        ModRegisterEvent.registerSpecialTooltips("doll_421", "sponsors_void060729");
        ModRegisterEvent.registerSpecialTooltips("doll_422", "sponsors_watermonstersub");
        ModRegisterEvent.registerSpecialTooltips("doll_423", "sponsors_wensleep");
        ModRegisterEvent.registerSpecialTooltips("doll_424", "sponsors_windfallingdust");
        ModRegisterEvent.registerSpecialTooltips("doll_425", "sponsors_winthre");
        ModRegisterEvent.registerSpecialTooltips("doll_426", "sponsors_wulitree");
        ModRegisterEvent.registerSpecialTooltips("doll_427", "sponsors_wuxijiang");
        ModRegisterEvent.registerSpecialTooltips("doll_428", "sponsors_w_recluse");
        ModRegisterEvent.registerSpecialTooltips("doll_429", "sponsors_xiao_chenk");
        ModRegisterEvent.registerSpecialTooltips("doll_430", "sponsors_yi");
        ModRegisterEvent.registerSpecialTooltips("doll_431", "sponsors_youyo_tea");
        ModRegisterEvent.registerSpecialTooltips("doll_432", "sponsors_yuejiu0wolf");
        ModRegisterEvent.registerSpecialTooltips("doll_433", "sponsors_yuemomu");
        ModRegisterEvent.registerSpecialTooltips("doll_434", "sponsors_yuguo_dada");
        ModRegisterEvent.registerSpecialTooltips("doll_435", "sponsors_yukiha0309");
        ModRegisterEvent.registerSpecialTooltips("doll_436", "sponsors_zecheng");
        ModRegisterEvent.registerSpecialTooltips("doll_437", "sponsors_zzdz1");
        ModRegisterEvent.registerSpecialTooltips("doll_438", "sponsors_yinan_youyizhangfaguangwenli");
        ModRegisterEvent.registerSpecialTooltips("doll_439", "sponsors_qi");
        ModRegisterEvent.registerSpecialTooltips("doll_440", "sponsors_gubao");
        ModRegisterEvent.registerSpecialTooltips("doll_441", "sponsors_lapudantuiren_hukefu");
        ModRegisterEvent.registerSpecialTooltips("doll_442", "sponsors_muan");
        ModRegisterEvent.registerSpecialTooltips("doll_443", "sponsors_yumu");
        ModRegisterEvent.registerSpecialTooltips("doll_444", "sponsors_youyingshadow");
        ModRegisterEvent.registerSpecialTooltips("doll_445", "sponsors_xuanlin");
        ModRegisterEvent.registerSpecialTooltips("doll_446", "sponsors_qiuku");
        ModRegisterEvent.registerSpecialTooltips("doll_447", "sponsors_yueaximu");
        ModRegisterEvent.registerSpecialTooltips("doll_448", "sponsors_zhuyan");
        ModRegisterEvent.registerSpecialTooltips("doll_449", "sponsors_yumo");
        ModRegisterEvent.registerSpecialTooltips("doll_450", "sponsors_feiqichanchan");
        ModRegisterEvent.registerSpecialTooltips("doll_451", "sponsors_yumian");
        ModRegisterEvent.registerSpecialTooltips("doll_452", "sponsors_lei_yinqwq");
        ModRegisterEvent.registerSpecialTooltips("doll_453", "sponsors_coppercuo");
        ModRegisterEvent.registerSpecialTooltips("doll_454", "sponsors_sodatnt");
        ModRegisterEvent.registerSpecialTooltips("doll_455", "sponsors_nanayu");
        ModRegisterEvent.registerSpecialTooltips("doll_456", "sponsors_wenquxin");
        ModRegisterEvent.registerSpecialTooltips("doll_457", "sponsors_wuyu");
        ModRegisterEvent.registerSpecialTooltips("doll_458", "sponsors_bennu_taozi");
        ModRegisterEvent.registerSpecialTooltips("doll_459", "sponsors_b_eibao");
        ModRegisterEvent.registerSpecialTooltips("doll_460", "sponsors_chcnscls");
        ModRegisterEvent.registerSpecialTooltips("doll_461", "sponsors_chenyin_yezhu");
        ModRegisterEvent.registerSpecialTooltips("doll_462", "sponsors_cheshiremiao");
        ModRegisterEvent.registerSpecialTooltips("doll_463", "sponsors_dafeimao");
        ModRegisterEvent.registerSpecialTooltips("doll_464", "sponsors_elex7310");
        ModRegisterEvent.registerSpecialTooltips("doll_465", "sponsors_eliceouo");
        ModRegisterEvent.registerSpecialTooltips("doll_466", "sponsors_frozenmissouri");
        ModRegisterEvent.registerSpecialTooltips("doll_467", "sponsors_hhtmey");
        ModRegisterEvent.registerSpecialTooltips("doll_468", "sponsors_ilovematlab");
        ModRegisterEvent.registerSpecialTooltips("doll_469", "sponsors_ironhorus0v0");
        ModRegisterEvent.registerSpecialTooltips("doll_470", "sponsors_kiuesakura");
        ModRegisterEvent.registerSpecialTooltips("doll_471", "sponsors_kun_he_qaq");
        ModRegisterEvent.registerSpecialTooltips("doll_472", "sponsors_licheng77");
        ModRegisterEvent.registerSpecialTooltips("doll_473", "sponsors_miranda_meow");
        ModRegisterEvent.registerSpecialTooltips("doll_474", "sponsors_panni1787");
        ModRegisterEvent.registerSpecialTooltips("doll_475", "sponsors_potatoisllk");
        ModRegisterEvent.registerSpecialTooltips("doll_476", "sponsors_potato_chip_cat");
        ModRegisterEvent.registerSpecialTooltips("doll_477", "sponsors_qioubiaa");
        ModRegisterEvent.registerSpecialTooltips("doll_478", "sponsors_qwq4611");
        ModRegisterEvent.registerSpecialTooltips("doll_479", "sponsors_skymoyuyo");
        ModRegisterEvent.registerSpecialTooltips("doll_480", "sponsors_wushi517");
        ModRegisterEvent.registerSpecialTooltips("doll_481", "sponsors_zigongggg");
        ModRegisterEvent.registerSpecialTooltips("doll_482", "sponsors_huafazixi");
        ModRegisterEvent.registerSpecialTooltips("doll_483", "sponsors_molvyyf6607");
        ModRegisterEvent.registerSpecialTooltips("doll_484", "sponsors_music0kirby");
        ModRegisterEvent.registerSpecialTooltips("doll_485", "sponsors_tanglizi");
        ModRegisterEvent.registerSpecialTooltips("doll_486", "sponsors_chengxiangjiehebu_wangzi");
        ModRegisterEvent.registerSpecialTooltips("doll_487", "sponsors_qiongjin");
        ModRegisterEvent.registerSpecialTooltips("doll_488", "sponsors_a777");
        ModRegisterEvent.registerSpecialTooltips("doll_489", "sponsors_acalephcat");
        ModRegisterEvent.registerSpecialTooltips("doll_490", "sponsors_adriensiscat");
        ModRegisterEvent.registerSpecialTooltips("doll_491", "sponsors_aken_senritsu");
        ModRegisterEvent.registerSpecialTooltips("doll_492", "sponsors_artillery_arc");
        ModRegisterEvent.registerSpecialTooltips("doll_493", "sponsors_artist_li");
        ModRegisterEvent.registerSpecialTooltips("doll_494", "sponsors_atsukko");
        ModRegisterEvent.registerSpecialTooltips("doll_495", "sponsors_ayachiyuki");
        ModRegisterEvent.registerSpecialTooltips("doll_496", "sponsors_ayato_cy");
        ModRegisterEvent.registerSpecialTooltips("doll_497", "sponsors_azelava");
        ModRegisterEvent.registerSpecialTooltips("doll_498", "sponsors_baiye907");
        ModRegisterEvent.registerSpecialTooltips("doll_499", "sponsors_banzhuan_jun");
        ModRegisterEvent.registerSpecialTooltips("doll_500", "sponsors_bksbwdw");
        ModRegisterEvent.registerSpecialTooltips("doll_501", "sponsors_blood_fog");
        ModRegisterEvent.registerSpecialTooltips("doll_502", "sponsors_bourbon115");
        ModRegisterEvent.registerSpecialTooltips("doll_503", "sponsors_brokenfox233");
        ModRegisterEvent.registerSpecialTooltips("doll_504", "sponsors_caffeineburst");
        ModRegisterEvent.registerSpecialTooltips("doll_505", "sponsors_chunxue520");
        ModRegisterEvent.registerSpecialTooltips("doll_506", "sponsors_cnzd");
        ModRegisterEvent.registerSpecialTooltips("doll_507", "sponsors_cxp_114514");
        ModRegisterEvent.registerSpecialTooltips("doll_508", "sponsors_dango517");
        ModRegisterEvent.registerSpecialTooltips("doll_509", "sponsors_daskdkl");
        ModRegisterEvent.registerSpecialTooltips("doll_510", "sponsors_dog_of_surtr");
        ModRegisterEvent.registerSpecialTooltips("doll_511", "sponsors_domexie");
        ModRegisterEvent.registerSpecialTooltips("doll_512", "sponsors_eggyolk_");
        ModRegisterEvent.registerSpecialTooltips("doll_513", "sponsors_enchantress_dusk");
        ModRegisterEvent.registerSpecialTooltips("doll_514", "sponsors_evannn_o");
        ModRegisterEvent.registerSpecialTooltips("doll_515", "sponsors_evelyn0v0");
        ModRegisterEvent.registerSpecialTooltips("doll_516", "sponsors_fcmc159");
        ModRegisterEvent.registerSpecialTooltips("doll_517", "sponsors_fortenz_mtr");
        ModRegisterEvent.registerSpecialTooltips("doll_518", "sponsors_fox_lingsan03");
        ModRegisterEvent.registerSpecialTooltips("doll_519", "sponsors_frt_m");
        ModRegisterEvent.registerSpecialTooltips("doll_520", "sponsors_godotcn");
        ModRegisterEvent.registerSpecialTooltips("doll_521", "sponsors_guide");
        ModRegisterEvent.registerSpecialTooltips("doll_522", "sponsors_guineapig_cavy");
        ModRegisterEvent.registerSpecialTooltips("doll_523", "sponsors_guu1024");
        ModRegisterEvent.registerSpecialTooltips("doll_524", "sponsors_heibaisamaquq");
        ModRegisterEvent.registerSpecialTooltips("doll_525", "sponsors_hina_prime");
        ModRegisterEvent.registerSpecialTooltips("doll_526", "sponsors_homeinbycool");
        ModRegisterEvent.registerSpecialTooltips("doll_527", "sponsors_hoshikawarito");
        ModRegisterEvent.registerSpecialTooltips("doll_528", "sponsors_ironhorus0v0");
        ModRegisterEvent.registerSpecialTooltips("doll_529", "sponsors_jeifing");
        ModRegisterEvent.registerSpecialTooltips("doll_530", "sponsors_jianxiangkui_123");
        ModRegisterEvent.registerSpecialTooltips("doll_531", "sponsors_keyxeldesu");
        ModRegisterEvent.registerSpecialTooltips("doll_532", "sponsors_klein_wyatt");
        ModRegisterEvent.registerSpecialTooltips("doll_533", "sponsors_konojagada");
        ModRegisterEvent.registerSpecialTooltips("doll_534", "sponsors_lagrangepoint19");
        ModRegisterEvent.registerSpecialTooltips("doll_535", "sponsors_leostam");
        ModRegisterEvent.registerSpecialTooltips("doll_536", "sponsors_lingyu_yx");
        ModRegisterEvent.registerSpecialTooltips("doll_537", "sponsors_lwindy");
        ModRegisterEvent.registerSpecialTooltips("doll_538", "sponsors_max__payne");
        ModRegisterEvent.registerSpecialTooltips("doll_539", "sponsors_melina");
        ModRegisterEvent.registerSpecialTooltips("doll_540", "sponsors_meng_xc");
        ModRegisterEvent.registerSpecialTooltips("doll_541", "sponsors_misakimisakimei_1");
        ModRegisterEvent.registerSpecialTooltips("doll_542", "sponsors_misakimisakimei_2");
        ModRegisterEvent.registerSpecialTooltips("doll_543", "sponsors_moshen_gg");
        ModRegisterEvent.registerSpecialTooltips("doll_544", "sponsors_moyu_ly");
        ModRegisterEvent.registerSpecialTooltips("doll_545", "sponsors_mso_kn");
        ModRegisterEvent.registerSpecialTooltips("doll_546", "sponsors_mucha_42");
        ModRegisterEvent.registerSpecialTooltips("doll_547", "sponsors_mxrdls");
        ModRegisterEvent.registerSpecialTooltips("doll_548", "sponsors_n1ne_3");
        ModRegisterEvent.registerSpecialTooltips("doll_549", "sponsors_neko_sang");
        ModRegisterEvent.registerSpecialTooltips("doll_550", "sponsors_nightbreezer");
        ModRegisterEvent.registerSpecialTooltips("doll_551", "sponsors_nightzero0");
        ModRegisterEvent.registerSpecialTooltips("doll_552", "sponsors_princeylove7");
        ModRegisterEvent.registerSpecialTooltips("doll_553", "sponsors_purehearthikari");
        ModRegisterEvent.registerSpecialTooltips("doll_554", "sponsors_qyhovo");
        ModRegisterEvent.registerSpecialTooltips("doll_555", "sponsors_q__chen");
        ModRegisterEvent.registerSpecialTooltips("doll_556", "sponsors_reinori");
        ModRegisterEvent.registerSpecialTooltips("doll_557", "sponsors_rex59168");
        ModRegisterEvent.registerSpecialTooltips("doll_558", "sponsors_rubyowo");
        ModRegisterEvent.registerSpecialTooltips("doll_559", "sponsors_saltedfishcatqwq");
        ModRegisterEvent.registerSpecialTooltips("doll_560", "sponsors_sepland");
        ModRegisterEvent.registerSpecialTooltips("doll_561", "sponsors_table_s4lt");
        ModRegisterEvent.registerSpecialTooltips("doll_562", "sponsors_theflarestar");
        ModRegisterEvent.registerSpecialTooltips("doll_563", "sponsors_tracy_r_owo");
        ModRegisterEvent.registerSpecialTooltips("doll_564", "sponsors_unreal_starry");
        ModRegisterEvent.registerSpecialTooltips("doll_565", "sponsors_wangmingrui2");
        ModRegisterEvent.registerSpecialTooltips("doll_566", "sponsors_water_melon520");
        ModRegisterEvent.registerSpecialTooltips("doll_567", "sponsors_white_pige0n");
        ModRegisterEvent.registerSpecialTooltips("doll_568", "sponsors_widio");
        ModRegisterEvent.registerSpecialTooltips("doll_569", "sponsors_wzq__");
        ModRegisterEvent.registerSpecialTooltips("doll_570", "sponsors_w_recluse");
        ModRegisterEvent.registerSpecialTooltips("doll_571", "sponsors_xcs66");
        ModRegisterEvent.registerSpecialTooltips("doll_572", "sponsors_xianlang");
        ModRegisterEvent.registerSpecialTooltips("doll_573", "sponsors_xiaohu_qwq");
        ModRegisterEvent.registerSpecialTooltips("doll_574", "sponsors_yi__yu");
        ModRegisterEvent.registerSpecialTooltips("doll_575", "sponsors_yuesheng_cw");
        ModRegisterEvent.registerSpecialTooltips("doll_576", "sponsors_yuliy6933");
        ModRegisterEvent.registerSpecialTooltips("doll_577", "sponsors______link______");
        ModRegisterEvent.registerSpecialTooltips("doll_578", "sponsors_qixi");
        ModRegisterEvent.registerSpecialTooltips("doll_579", "sponsors_bushiaju");
        ModRegisterEvent.registerSpecialTooltips("doll_580", "sponsors_wuyu_jixiangxinchun");
        ModRegisterEvent.registerSpecialTooltips("doll_581", "sponsors_xiaomichirou");
        ModRegisterEvent.registerSpecialTooltips("doll_582", "sponsors_bianting");
        ModRegisterEvent.registerSpecialTooltips("doll_583", "sponsors_weishenghuqing");
        ModRegisterEvent.registerSpecialTooltips("doll_584", "sponsors_sikalaite");
        ModRegisterEvent.registerSpecialTooltips("doll_585", "sponsors_xingyeqibai");
        ModRegisterEvent.registerSpecialTooltips("doll_586", "sponsors_pulikaite");
        ModRegisterEvent.registerSpecialTooltips("doll_587", "sponsors_qilu");
        ModRegisterEvent.registerSpecialTooltips("doll_588", "sponsors_zhishibeiyi");
        ModRegisterEvent.registerSpecialTooltips("doll_589", "sponsors_niyu");
        ModRegisterEvent.registerSpecialTooltips("doll_590", "sponsors_daowu");
        ModRegisterEvent.registerSpecialTooltips("doll_591", "sponsors_meimoxiaojielindong");
        ModRegisterEvent.registerSpecialTooltips("doll_592", "sponsors_ximo_xiaomo");
        ModRegisterEvent.registerSpecialTooltips("doll_593", "sponsors_ximo_xiaomo");
        ModRegisterEvent.registerSpecialTooltips("doll_594", "sponsors_ximo_xiaomo");
        ModRegisterEvent.registerSpecialTooltips("doll_595", "sponsors_ximo_xiaomo");
        ModRegisterEvent.registerSpecialTooltips("doll_596", "sponsors_cjxng");
        ModRegisterEvent.registerSpecialTooltips("doll_597", "sponsors_new_wy");
        ModRegisterEvent.registerSpecialTooltips("doll_598", "sponsors_yw_wen");
        ModRegisterEvent.registerSpecialTooltips("doll_602", "sponsors_changhaiming");
        ModRegisterEvent.registerSpecialTooltips("doll_603", "sponsors_haruka_aoba");
        ModRegisterEvent.registerSpecialTooltips("doll_604", "sponsors_jdk_shinano");
        ModRegisterEvent.registerSpecialTooltips("doll_605", "sponsors_kunkun278");
        ModRegisterEvent.registerSpecialTooltips("doll_606", "sponsors_muyan_lor");
        ModRegisterEvent.registerSpecialTooltips("doll_607", "sponsors_sekiort");
        ModRegisterEvent.registerSpecialTooltips("doll_608", "sponsors_sliver3at");
        ModRegisterEvent.registerSpecialTooltips("doll_609", "sponsors_tang70422");
        ModRegisterEvent.registerSpecialTooltips("doll_610", "sponsors_txibao");
        ModRegisterEvent.registerSpecialTooltips("doll_611", "sponsors_xycbs");
        ModRegisterEvent.registerSpecialTooltips("doll_612", "sponsors_shutuzhuangxibao");
        ModRegisterEvent.registerSpecialTooltips("doll_613", "sponsors_rexuexilanhua");
        ModRegisterEvent.registerSpecialTooltips("doll_615", "sponsors_halgus");
    }

    @SubscribeEvent
    public static void registerBlocks(RegisterEvent event) {
        ModRegisterEvent.registerAllVanillaTooltips();
        ModRegisterEvent.registerAuthorTooltips();
        ModRegisterEvent.registerAllSpecialTooltips();
        if (event.getRegistryKey().equals((Object)ForgeRegistries.BLOCKS.getRegistryKey())) {
            IntStream.range(0, 616).forEach(i -> {
                ResourceLocation name = new ResourceLocation("kaleidoscope_doll", "doll_" + i);
                DollBlock block = new DollBlock();
                DOLL_BLOCKS.put(name, block);
                event.register(ForgeRegistries.BLOCKS.getRegistryKey(), name, () -> block);
            });
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
            IntStream.range(0, 616).forEach(i -> {
                ResourceLocation name = new ResourceLocation("kaleidoscope_doll", "doll_" + i);
                DollBlock block = DOLL_BLOCKS.get(name);
                String vanillaDesc = VANILLA_TOOLTIPS.getOrDefault(name, "vanilla");
                String specialDesc = SPECIAL_TOOLTIPS.getOrDefault(name, vanillaDesc);
                DollItem item = new DollItem((Block)block, specialDesc);
                DOLL_ITEMS.add((Item)item);
                event.register(ForgeRegistries.ITEMS.getRegistryKey(), name, () -> ModRegisterEvent.lambda$registerBlocks$2((Item)item));
            });
        }
    }

    private static void registerVanillaTooltips(String name, String tooltip) {
        ResourceLocation id = new ResourceLocation("kaleidoscope_doll", name);
        VANILLA_TOOLTIPS.put(id, tooltip);
    }

    private static void registerAuthorTooltips(String name, String tooltip) {
        ResourceLocation id = new ResourceLocation("kaleidoscope_doll", name);
        SPECIAL_TOOLTIPS.put(id, tooltip);
        AUTHOR_DOLLS.add(id);
    }

    private static void registerSpecialTooltips(String name, String tooltip) {
        ResourceLocation id = new ResourceLocation("kaleidoscope_doll", name);
        SPECIAL_TOOLTIPS.put(id, tooltip);
    }

    private static /* synthetic */ Item lambda$registerBlocks$2(Item item) {
        return item;
    }
}

