/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.item;

import com.github.ysbbbbbb.kaleidoscopedoll.client.render.DollEntityItemRender;
import com.github.ysbbbbbb.kaleidoscopedoll.config.GeneralConfig;
import com.github.ysbbbbbb.kaleidoscopedoll.entity.DollEntity;
import com.github.ysbbbbbb.kaleidoscopedoll.event.ModRegisterEvent;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModEntities;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModItems;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class DollEntityItem
extends Item {
    private static final String TAG_DOLL_ENTITY = "doll_entity";
    private static final int THROW_DURATION = 5;

    public DollEntityItem() {
        super(new Item.Properties());
    }

    public static ItemStack createItemWithEntity(DollEntity entity) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DOLL_ENTITY_ITEM.get());
        DollEntityItem.saveDollEntity(stack, entity);
        return stack;
    }

    public static ItemStack createItemWithBlockState(BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DOLL_ENTITY_ITEM.get());
        CompoundTag entityTag = new CompoundTag();
        entityTag.m_128365_("doll_block_state", (Tag)NbtUtils.m_129202_((BlockState)state));
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_(TAG_DOLL_ENTITY, (Tag)entityTag);
        return stack;
    }

    public static void saveDollEntity(ItemStack stack, DollEntity entity) {
        if (!stack.m_150930_((Item)ModItems.DOLL_ENTITY_ITEM.get())) {
            return;
        }
        CompoundTag entityTag = new CompoundTag();
        entity.m_7380_(entityTag);
        entity.removePhantomRecord(entityTag);
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_(TAG_DOLL_ENTITY, (Tag)entityTag);
    }

    public static Block getBlockFromItemStack(ItemStack stack) {
        CompoundTag entityTag;
        if (!stack.m_150930_((Item)ModItems.DOLL_ENTITY_ITEM.get())) {
            return (Block)ModBlocks.PURPLE_DOLL_GIFT_BOX.get();
        }
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128441_(TAG_DOLL_ENTITY) && (entityTag = stackTag.m_128469_(TAG_DOLL_ENTITY)).m_128441_("doll_block_state")) {
            CompoundTag compound = entityTag.m_128469_("doll_block_state");
            HolderLookup.RegistryLookup lookup = BuiltInRegistries.f_256975_.m_255303_();
            return NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)compound).m_60734_();
        }
        return (Block)ModBlocks.PURPLE_DOLL_GIFT_BOX.get();
    }

    public static DollEntity getDollEntity(Level level, ItemStack stack) {
        if (!stack.m_150930_((Item)ModItems.DOLL_ENTITY_ITEM.get())) {
            return new DollEntity((EntityType)ModEntities.DOLL.get(), level);
        }
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128441_(TAG_DOLL_ENTITY)) {
            CompoundTag entityTag = stackTag.m_128469_(TAG_DOLL_ENTITY);
            DollEntity entity = new DollEntity((EntityType)ModEntities.DOLL.get(), level);
            entity.m_20258_(entityTag);
            return entity;
        }
        return new DollEntity((EntityType)ModEntities.DOLL.get(), level);
    }

    public static boolean hasEntityData(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        return stackTag != null && stackTag.m_128441_(TAG_DOLL_ENTITY);
    }

    public static void clearEntityData(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128441_(TAG_DOLL_ENTITY)) {
            stackTag.m_128473_(TAG_DOLL_ENTITY);
        }
    }

    public static void addCreativeTab(CreativeModeTab.Output output) {
        ModRegisterEvent.DOLL_BLOCKS.values().forEach(block -> output.m_246342_(DollEntityItem.createItemWithBlockState(block.m_49966_())));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private DollEntityItemRender render = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                if (this.render == null) {
                    this.render = new DollEntityItemRender(minecraft.m_167982_(), minecraft.m_167973_());
                }
                return this.render;
            }
        });
    }

    private boolean mayPlace(Player pPlayer, Direction pDirection, ItemStack pItemStack, BlockPos pPos) {
        return !pPlayer.m_9236_().m_151570_(pPos) && pPlayer.m_36204_(pPos, pDirection, pItemStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_() && ((Boolean)GeneralConfig.DOLL_CAN_BE_THROWN.get()).booleanValue()) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        int useTime = this.m_8105_(stack) - timeLeft;
        if (useTime >= 5 && ((Boolean)GeneralConfig.DOLL_CAN_BE_THROWN.get()).booleanValue()) {
            int strength = useTime - 5;
            this.throwDollEntity(level, entity, stack, strength);
        }
    }

    private void throwDollEntity(Level level, LivingEntity entity, ItemStack stack, int strength) {
        block4: {
            block5: {
                if (level.f_46443_) break block4;
                DollEntity dollEntity = DollEntityItem.getDollEntity(level, stack);
                dollEntity.setInThrowing(true);
                if (dollEntity.getDisplayBlockState().m_60795_()) {
                    dollEntity.setDisplayBlockState(((Block)ModBlocks.PURPLE_DOLL_GIFT_BOX.get()).m_49966_());
                }
                Vec3 playerEyePos = entity.m_146892_();
                dollEntity.m_6034_(playerEyePos.f_82479_, playerEyePos.f_82480_ - 0.1, playerEyePos.f_82481_);
                Vec3 lookAngle = entity.m_20154_();
                double throwPower = Mth.m_14008_((double)((double)strength * 0.1), (double)0.1, (double)3.0);
                dollEntity.m_20334_(lookAngle.f_82479_ * throwPower, lookAngle.f_82480_ * throwPower, lookAngle.f_82481_ * throwPower);
                dollEntity.m_146922_(entity.m_146908_() - 180.0f);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12473_, SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                level.m_7967_((Entity)dollEntity);
                if (!(entity instanceof Player)) break block5;
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) break block4;
            }
            stack.m_41774_(1);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        if (player == null || !this.mayPlace(player, clickedFace, stack, clickedPos)) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        BlockPos spawnPos = clickedPos.m_121945_(clickedFace);
        Vec3 spawnLocation = Vec3.m_82539_((Vec3i)spawnPos);
        DollEntity dollEntity = DollEntityItem.getDollEntity(level, stack);
        if (dollEntity.getDisplayBlockState().m_60795_()) {
            dollEntity.setDisplayBlockState(((Block)ModBlocks.PURPLE_DOLL_GIFT_BOX.get()).m_49966_());
        }
        dollEntity.m_6034_(spawnLocation.f_82479_, spawnLocation.f_82480_, spawnLocation.f_82481_);
        dollEntity.m_146922_(player.m_146908_() - 180.0f);
        if (dollEntity.canSurvives()) {
            if (!level.f_46443_) {
                dollEntity.m_5496_(SoundEvents.f_12642_, 1.0f, 1.0f);
                level.m_220400_((Entity)player, GameEvent.f_157810_, dollEntity.m_20182_());
                level.m_7967_((Entity)dollEntity);
            }
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag isAdvanced) {
        tooltips.add((Component)Component.m_237115_((String)"item.kaleidoscopedoll.doll_entity_item.throw.tooltip").m_130940_(ChatFormatting.DARK_GRAY));
        tooltips.add((Component)Component.m_237115_((String)"item.kaleidoscopedoll.doll_entity_item.place.tooltip").m_130940_(ChatFormatting.DARK_GRAY));
    }
}

