/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.network.message;

import com.github.ysbbbbbb.kaleidoscopedoll.inventory.ComputerMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ComputerDollClickMessage {
    private final ItemStack doll;

    public ComputerDollClickMessage(ItemStack doll) {
        this.doll = doll;
    }

    public static void encode(ComputerDollClickMessage message, FriendlyByteBuf buf) {
        buf.m_130055_(message.doll);
    }

    public static ComputerDollClickMessage decode(FriendlyByteBuf buf) {
        ItemStack doll = buf.m_130267_();
        return new ComputerDollClickMessage(doll);
    }

    public static void handle(ComputerDollClickMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> ComputerDollClickMessage.onHandle(message, context));
        }
        context.setPacketHandled(true);
    }

    private static void onHandle(ComputerDollClickMessage message, NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        player.m_9243_();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ComputerMenu) {
            ComputerMenu computerMenu = (ComputerMenu)abstractContainerMenu;
            if (!player.m_5833_() && computerMenu.clickDollButton(message.doll)) {
                player.f_36096_.m_38946_();
            }
        }
    }
}

