/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.block;

import com.github.ysbbbbbb.kaleidoscopedoll.config.GeneralConfig;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModItems;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DollMachineBlock
extends HorizontalDirectionalBlock {
    private static final MapCodec<DollMachineBlock> CODEC = DollMachineBlock.simpleCodec(prop -> new DollMachineBlock());
    private static final VoxelShape SHAPE_UPPER = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final BooleanProperty LOTTERY_IN_PROGRESS = BooleanProperty.create((String)"lottery_in_progress");
    private static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    private static final TagKey<Item> DOLL_MACHINE_TOKENS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_doll", (String)"doll_machine_tokens"));

    public DollMachineBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.COPPER).strength(8.0f, 10.0f).lightLevel(s -> 2).pushReaction(PushReaction.BLOCK).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LOTTERY_IN_PROGRESS, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf blockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (facing.getAxis() == Direction.Axis.Y && blockHalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            boolean condition = facingState.is((Block)this) && facingState.getValue(HALF) != blockHalf;
            return condition ? (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)facingState.getValue((Property)FACING)))).setValue((Property)LOTTERY_IN_PROGRESS, (Comparable)((Boolean)facingState.getValue((Property)LOTTERY_IN_PROGRESS))) : Blocks.AIR.defaultBlockState();
        }
        boolean condition = blockHalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos);
        return condition ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos = context.getClickedPos();
        Level level = context.getLevel();
        if (clickedPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(clickedPos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos below;
        BlockState belowState;
        DoubleBlockHalf value;
        if (!level.isClientSide && player.isCreative() && (value = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.UPPER && (belowState = level.getBlockState(below = pos.below())).is(state.getBlock()) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState = belowState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(below, blockState, 35);
            level.levelEvent(player, 2001, below, Block.getId((BlockState)belowState));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity entity, ItemStack pStack) {
        pLevel.setBlock(pPos.above(), (BlockState)pState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, Direction.UP) : blockstate.is((Block)this);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        if (stack.is(DOLL_MACHINE_TOKENS) && !((Boolean)blockstate.getValue((Property)LOTTERY_IN_PROGRESS)).booleanValue()) {
            int x = pos.getX();
            int y = blockstate.getValue(HALF) == DoubleBlockHalf.LOWER ? pos.getY() : pos.getY() - 1;
            int z = pos.getZ();
            stack.shrink(1);
            world.setBlockAndUpdate(pos, (BlockState)blockstate.setValue((Property)LOTTERY_IN_PROGRESS, (Comparable)Boolean.valueOf(true)));
            world.playSound(null, pos, SoundEvents.LARGE_AMETHYST_BUD_PLACE, SoundSource.BLOCKS, 4.0f, 2.0f);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.WAX_ON, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, 8, 0.5, 0.5, 0.5, 0.2);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, 8, 0.5, 0.5, 0.5, 0.2);
                world.scheduleTick(pos, blockstate.getBlock(), 60);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, blockstate, world, pos, entity, hand, hit);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)blockstate.getValue((Property)LOTTERY_IN_PROGRESS)).booleanValue()) {
            this.dropGiftBox(world, blockstate, pos, random);
        }
    }

    public void dropGiftBox(ServerLevel world, BlockState blockstate, BlockPos pos, RandomSource random) {
        int x = pos.getX();
        int y = blockstate.getValue(HALF) == DoubleBlockHalf.LOWER ? pos.getY() : pos.getY() - 1;
        int z = pos.getZ();
        world.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, 10, 0.5, 0.5, 0.5, 0.5);
        world.playSound(null, (double)x, (double)y, (double)z, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.setBlockAndUpdate(pos, (BlockState)blockstate.setValue((Property)LOTTERY_IN_PROGRESS, (Comparable)Boolean.valueOf(false)));
        int yellowCount = (Integer)GeneralConfig.YELLOW_DOLL_GIFT_BOX_WEIGHT.get();
        int greenCount = yellowCount + (Integer)GeneralConfig.GREEN_DOLL_GIFT_BOX_WEIGHT.get();
        int totalCount = greenCount + (Integer)GeneralConfig.PURPLE_DOLL_GIFT_BOX_WEIGHT.get();
        int count = random.nextInt(0, totalCount);
        ItemEntity item = count <= yellowCount ? new ItemEntity((Level)world, (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, ((Item)ModItems.YELLOW_DOLL_GIFT_BOX.get()).getDefaultInstance()) : (count <= greenCount ? new ItemEntity((Level)world, (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, ((Item)ModItems.GREEN_DOLL_GIFT_BOX.get()).getDefaultInstance()) : new ItemEntity((Level)world, (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, ((Item)ModItems.PURPLE_DOLL_GIFT_BOX.get()).getDefaultInstance()));
        item.setPickUpDelay(10);
        world.addFreshEntity((Entity)item);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE;
        }
        return SHAPE_UPPER;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LOTTERY_IN_PROGRESS, HALF});
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag pFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_doll.doll_machine").withStyle(ChatFormatting.DARK_GRAY));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

