/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.event;

import com.github.ysbbbbbb.kaleidoscopedoll.block.DollBlock;
import com.github.ysbbbbbb.kaleidoscopedoll.item.DollItem;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="kaleidoscope_doll", bus=EventBusSubscriber.Bus.MOD)
public class ModRegisterEvent {
    public static final Map<ResourceLocation, DollBlock> DOLL_BLOCKS = Maps.newHashMap();
    public static final Map<ResourceLocation, String> SPECIAL_TOOLTIPS = Maps.newHashMap();
    public static final Set<Item> DOLL_ITEMS = Sets.newLinkedHashSet();
    private static final int MAX_DOLL_COUNT = 113;

    private static void registerAllSpecialTooltips() {
        ModRegisterEvent.registerSpecialTooltips("doll_0", "author_ysbb");
        ModRegisterEvent.registerSpecialTooltips("doll_1", "author_tartaric_acid");
        ModRegisterEvent.registerSpecialTooltips("doll_67", "author_abert_cat");
        ModRegisterEvent.registerSpecialTooltips("doll_68", "author_cr_019");
        ModRegisterEvent.registerSpecialTooltips("doll_69", "sponsors_guriformes");
        ModRegisterEvent.registerSpecialTooltips("doll_70", "sponsors_passer1ne");
        ModRegisterEvent.registerSpecialTooltips("doll_71", "sponsors_tanyeng");
        ModRegisterEvent.registerSpecialTooltips("doll_72", "sponsors_airsamafurry");
        ModRegisterEvent.registerSpecialTooltips("doll_73", "sponsors_corleonejing");
        ModRegisterEvent.registerSpecialTooltips("doll_74", "sponsors_kuriyamayasura");
        ModRegisterEvent.registerSpecialTooltips("doll_75", "sponsors_miomilost");
        ModRegisterEvent.registerSpecialTooltips("doll_76", "sponsors_nekonymph");
        ModRegisterEvent.registerSpecialTooltips("doll_77", "sponsors_puerkimiko");
        ModRegisterEvent.registerSpecialTooltips("doll_78", "sponsors_aoisake");
        ModRegisterEvent.registerSpecialTooltips("doll_79", "sponsors_cpcian39");
        ModRegisterEvent.registerSpecialTooltips("doll_80", "sponsors_swordman_live");
        ModRegisterEvent.registerSpecialTooltips("doll_81", "sponsors_tclimuareotin");
        ModRegisterEvent.registerSpecialTooltips("doll_82", "sponsors_taste_puppy");
        ModRegisterEvent.registerSpecialTooltips("doll_83", "sponsors_poetry_chicken");
        ModRegisterEvent.registerSpecialTooltips("doll_84", "sponsors_fudge_666");
        ModRegisterEvent.registerSpecialTooltips("doll_85", "sponsors_chair341");
        ModRegisterEvent.registerSpecialTooltips("doll_86", "sponsors_dumnheint");
        ModRegisterEvent.registerSpecialTooltips("doll_87", "sponsors_lilunli");
        ModRegisterEvent.registerSpecialTooltips("doll_88", "sponsors_psbastards");
        ModRegisterEvent.registerSpecialTooltips("doll_89", "sponsors_pysgas");
        ModRegisterEvent.registerSpecialTooltips("doll_90", "sponsors_redflashier");
        ModRegisterEvent.registerSpecialTooltips("doll_91", "sponsors_rsob123");
        ModRegisterEvent.registerSpecialTooltips("doll_92", "sponsors_solareclipseg");
        ModRegisterEvent.registerSpecialTooltips("doll_93", "sponsors_zombiec1107");
        ModRegisterEvent.registerSpecialTooltips("doll_94", "sponsors__moepus_");
        ModRegisterEvent.registerSpecialTooltips("doll_95", "sponsors_ackrf");
        ModRegisterEvent.registerSpecialTooltips("doll_96", "sponsors_chuanchengzi");
        ModRegisterEvent.registerSpecialTooltips("doll_97", "sponsors_deltaex001");
        ModRegisterEvent.registerSpecialTooltips("doll_98", "sponsors_elyasrosedale");
        ModRegisterEvent.registerSpecialTooltips("doll_99", "sponsors_faustduck");
        ModRegisterEvent.registerSpecialTooltips("doll_100", "sponsors_lixu223");
        ModRegisterEvent.registerSpecialTooltips("doll_101", "sponsors_kupurrra");
        ModRegisterEvent.registerSpecialTooltips("doll_102", "sponsors_thjnd");
        ModRegisterEvent.registerSpecialTooltips("doll_103", "sponsors_variant_dk");
        ModRegisterEvent.registerSpecialTooltips("doll_104", "sponsors_yuxiaowan");
        ModRegisterEvent.registerSpecialTooltips("doll_105", "sponsors_bigpear5231");
        ModRegisterEvent.registerSpecialTooltips("doll_106", "sponsors_idlersnacl");
        ModRegisterEvent.registerSpecialTooltips("doll_107", "sponsors_kekmc123");
        ModRegisterEvent.registerSpecialTooltips("doll_108", "sponsors_kizunahovene");
        ModRegisterEvent.registerSpecialTooltips("doll_109", "sponsors_linx");
        ModRegisterEvent.registerSpecialTooltips("doll_110", "sponsors_linx_su");
        ModRegisterEvent.registerSpecialTooltips("doll_111", "sponsors_wyx0714");
        ModRegisterEvent.registerSpecialTooltips("doll_112", "sponsors_xheya_3u3");
    }

    @SubscribeEvent
    public static void registerBlocks(RegisterEvent event) {
        ModRegisterEvent.registerAllSpecialTooltips();
        if (event.getRegistryKey().equals(Registries.BLOCK)) {
            IntStream.range(0, 113).forEach(i -> {
                ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_doll", (String)("doll_" + i));
                DollBlock block = new DollBlock();
                DOLL_BLOCKS.put(name, block);
                event.register(Registries.BLOCK, name, () -> block);
            });
        }
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            IntStream.range(0, 113).forEach(i -> {
                ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_doll", (String)("doll_" + i));
                DollBlock block = DOLL_BLOCKS.get(name);
                DollItem item = new DollItem((Block)block, SPECIAL_TOOLTIPS.getOrDefault(name, "vanilla"));
                DOLL_ITEMS.add((Item)item);
                event.register(Registries.ITEM, name, () -> ModRegisterEvent.lambda$registerBlocks$2((Item)item));
            });
        }
    }

    private static void registerSpecialTooltips(String name, String tooltip) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_doll", (String)name);
        SPECIAL_TOOLTIPS.put(id, tooltip);
    }

    private static /* synthetic */ Item lambda$registerBlocks$2(Item item) {
        return item;
    }
}

