/*
 * Decompiled with CFR 0.152.
 */
package cyberspace.block;

import cyberspace.procedures.TerminalBlockBlockIsPlacedByProcedure;
import cyberspace.procedures.TerminalBlockOnBlockRightClickedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TerminalBlockBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public TerminalBlockBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.LANTERN).strength(1.0f, 10.0f).lightLevel(s -> 7).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)TerminalBlockBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape)TerminalBlockBlock.box((double)2.0, (double)5.0, (double)0.0, (double)14.0, (double)15.5, (double)12.0));
            case Direction.NORTH -> Shapes.or((VoxelShape)TerminalBlockBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)15.0), (VoxelShape)TerminalBlockBlock.box((double)2.0, (double)5.0, (double)4.0, (double)14.0, (double)15.5, (double)16.0));
            case Direction.EAST -> Shapes.or((VoxelShape)TerminalBlockBlock.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape)TerminalBlockBlock.box((double)0.0, (double)5.0, (double)2.0, (double)12.0, (double)15.5, (double)14.0));
            case Direction.WEST -> Shapes.or((VoxelShape)TerminalBlockBlock.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)5.0, (double)16.0), (VoxelShape)TerminalBlockBlock.box((double)4.0, (double)5.0, (double)2.0, (double)16.0, (double)15.5, (double)14.0));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        TerminalBlockBlockIsPlacedByProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        TerminalBlockOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

