/*
 * Decompiled with CFR 0.152.
 */
package cyberspace.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import cyberspace.init.CyberspaceModScreens;
import cyberspace.network.MobileTerminalGuiButtonMessage;
import cyberspace.world.inventory.MobileTerminalGuiMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class MobileTerminalGuiScreen
extends AbstractContainerScreen<MobileTerminalGuiMenu>
implements CyberspaceModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox MT_CMD;
    Button button_ent;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"cyberspace:textures/screens/mobile_terminal_gui.png");

    public MobileTerminalGuiScreen(MobileTerminalGuiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 164;
        this.imageHeight = 136;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("MT_CMD")) {
                this.MT_CMD.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.MT_CMD.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(RenderType::guiTextured, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(RenderType::guiTextured, ResourceLocation.parse((String)"cyberspace:textures/screens/cyberspaceterminalgui2.png"), this.leftPos + -36, this.topPos + 1, 0.0f, 0.0f, 230, 134, 230, 134);
        guiGraphics.blit(RenderType::guiTextured, ResourceLocation.parse((String)"cyberspace:textures/screens/ui_overlay.png"), this.leftPos + -31, this.topPos + 6, 0.0f, 0.0f, 219, 123, 219, 123);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.MT_CMD.isFocused()) {
            return this.MT_CMD.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String MT_CMDValue = this.MT_CMD.getValue();
        super.resize(minecraft, width, height);
        this.MT_CMD.setValue(MT_CMDValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
        this.MT_CMD = new EditBox(this.font, this.leftPos + -17, this.topPos + 56, 160, 18, (Component)Component.translatable((String)"gui.cyberspace.mobile_terminal_gui.MT_CMD"));
        this.MT_CMD.setMaxLength(8192);
        this.MT_CMD.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((MobileTerminalGuiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "MT_CMD", content, false);
            }
        });
        this.MT_CMD.setHint((Component)Component.translatable((String)"gui.cyberspace.mobile_terminal_gui.MT_CMD"));
        this.addWidget((GuiEventListener)this.MT_CMD);
        this.button_ent = new PlainTextButton(this.leftPos + 144, this.topPos + 55, 40, 20, (Component)Component.translatable((String)"gui.cyberspace.mobile_terminal_gui.button_ent"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new MobileTerminalGuiButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            MobileTerminalGuiButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }, this.font);
        this.addRenderableWidget((GuiEventListener)this.button_ent);
    }
}

