/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import dev.xylonity.tooltipoverhaul.client.Palette;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public record CustomFrameData(List<String> items, List<String> tags, Optional<String> namespace, Optional<String> texture, Optional<Integer> backgroundColor, Optional<InnerBorderType> borderType, Optional<GradientType> gradientType, Optional<List<String>> gradientColors, Optional<String> itemRating, Optional<Integer> colorItemRating, Optional<String> ratingAlignment, Optional<String> titleAlignment, Optional<Integer> titlePositionX, Optional<Integer> titlePositionY, Optional<Integer> ratingPositionX, Optional<Integer> ratingPositionY, Optional<Integer> tooltipDescriptionPositionX, Optional<Integer> tooltipDescriptionPositionY, Optional<Integer> mainPanelPaddingX, Optional<Integer> mainPanelPaddingY, Optional<Float> iconSize, Optional<Float> iconRotatingSpeed, Optional<String> iconAppearAnimation, Optional<Integer> secondPanelX, Optional<Integer> secondPanelY, Optional<Float> secondPanelRendererSize, Optional<Float> secondPanelRendererSpeed, Optional<DividerLineType> dividerLineType, Optional<String> dividerLineColor, Optional<String> particles, Optional<String> specialEffect, Optional<Boolean> showSecondPanel, Optional<Boolean> showRating, Optional<Boolean> disableIcon, Optional<Boolean> disableScrolling, Optional<Boolean> disableTooltip) {
    public String getTexture() {
        return this.texture.filter(t -> !t.trim().isEmpty()).orElse(TooltipsConfig.GLOBAL_FRAME_OVERLAY_LOCATION);
    }

    public InnerBorderType getBorderType() {
        InnerBorderType type;
        try {
            type = InnerBorderType.valueOf(TooltipsConfig.DEFAULT_INNER_OVERLAY_TYPE.toUpperCase(Locale.ROOT));
        }
        catch (Exception ignore) {
            type = InnerBorderType.GRADIENT;
        }
        return this.borderType.orElse(type);
    }

    public GradientType getGradientType() {
        return this.gradientType.orElse(GradientType.COMMON);
    }

    public List<String> getGradientColors() {
        return this.gradientColors.filter(colors -> colors.size() >= 3).map(colors -> colors.subList(0, 3)).orElse(List.of("#FFFFFFFF", "#FFFFFFFF", "#FFFFFFFF"));
    }

    public String getItemRating(ItemStack stack) {
        return this.itemRating.filter(rating -> !rating.trim().isEmpty()).orElse(Util.getDefaultRarity(stack).getString());
    }

    public int getItemRatingColor(ItemStack stack) {
        return this.colorItemRating.orElse(this.getRarityColor(stack));
    }

    public boolean shouldDisableTooltip() {
        return this.disableTooltip.orElse(false);
    }

    private int getRarityColor(ItemStack stack) {
        Rarity r = stack.m_41791_();
        int palette = Palette.LEGENDARY[0];
        if (r == Rarity.COMMON) {
            palette = Palette.COMMON[0];
        }
        if (r == Rarity.UNCOMMON) {
            palette = Palette.UNCOMMON[0];
        }
        if (r == Rarity.RARE) {
            palette = Palette.RARE[0];
        }
        if (r == Rarity.EPIC) {
            palette = Palette.EPIC[0];
        }
        return palette;
    }

    public String getIconAppearAnimation() {
        return this.iconAppearAnimation.orElse(TooltipsConfig.ICON_APPEAR_ANIMATION);
    }

    public float getIconRotatingSpeed() {
        return this.iconRotatingSpeed.orElse(Float.valueOf(TooltipsConfig.ICON_ROTATING_SPEED)).floatValue();
    }

    public int getTitlePositionX() {
        return this.titlePositionX.orElse(TooltipsConfig.TITLE_POSITION_X);
    }

    public int getTitlePositionY() {
        return this.titlePositionY.orElse(TooltipsConfig.TITLE_POSITION_Y);
    }

    public int getRatingPositionX() {
        return this.ratingPositionX.orElse(TooltipsConfig.RATING_POSITION_X);
    }

    public int getRatingPositionY() {
        return this.ratingPositionY.orElse(TooltipsConfig.RATING_POSITION_Y);
    }

    public int getTooltipDescriptionPositionX() {
        return this.tooltipDescriptionPositionX.orElse(TooltipsConfig.TOOLTIP_DESCRIPTION_POSITION_X);
    }

    public int getBackgroundColor() {
        return this.backgroundColor.orElse(Palette.PANEL_BG);
    }

    public boolean shouldDisableScrolling() {
        return this.disableScrolling.orElse(TooltipsConfig.DISABLE_TOOLTIP_SCROLLING);
    }

    public int getTooltipDescriptionPositionY() {
        return this.tooltipDescriptionPositionY.orElse(TooltipsConfig.TOOLTIP_DESCRIPTION_POSITION_Y);
    }

    public int getSecondPanelX() {
        return this.secondPanelX.orElse(TooltipsConfig.SECOND_PANEL_X);
    }

    public int getSecondPanelY() {
        return this.secondPanelY.orElse(TooltipsConfig.SECOND_PANEL_Y);
    }

    public String getRatingAlignment() {
        return this.ratingAlignment.orElse(TooltipsConfig.RATING_X_ALIGNMENT);
    }

    public String getTitleAlignment() {
        return this.titleAlignment.orElse(TooltipsConfig.TITLE_X_ALIGNMENT);
    }

    public float getIconSize() {
        return this.iconSize.orElse(Float.valueOf(TooltipsConfig.ICON_SIZE)).floatValue();
    }

    public float getSecondPanelRendererSize() {
        return this.secondPanelRendererSize.orElse(Float.valueOf(TooltipsConfig.SECOND_PANEL_RENDERER_SIZE)).floatValue();
    }

    public float getSecondPanelRendererSpeed() {
        return this.secondPanelRendererSpeed.orElse(Float.valueOf(TooltipsConfig.SECOND_PANEL_RENDERER_SPEED)).floatValue();
    }

    public String getEffect() {
        return this.specialEffect.filter(effect -> !effect.trim().isEmpty()).orElse("none");
    }

    public List<ResourceLocation> getItemLocations() {
        return this.items.stream().map(ResourceLocation::new).collect(Collectors.toList());
    }

    public List<TagKey<Item>> getTagKeys() {
        return this.tags.stream().map(name -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(name))).collect(Collectors.toList());
    }

    public boolean matches(ItemStack stack) {
        String namespace;
        ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        if (this.items.contains(key.toString())) {
            return true;
        }
        if (this.namespace.isPresent() && !(namespace = this.namespace.get().trim()).isEmpty()) {
            if (namespace.equals("*") || namespace.equalsIgnoreCase("all")) {
                return true;
            }
            if (key.m_135827_().equals(namespace)) {
                return true;
            }
        }
        for (TagKey<Item> tagKey : this.getTagKeys()) {
            if (!stack.m_204117_(tagKey)) continue;
            return true;
        }
        return false;
    }

    public int getMainPanelPaddingX() {
        return this.mainPanelPaddingX.orElse(TooltipsConfig.MAIN_PANEL_PADDING_X);
    }

    public int getMainPanelPaddingY() {
        return this.mainPanelPaddingY.orElse(TooltipsConfig.MAIN_PANEL_PADDING_Y);
    }

    public String getDividerLineColor() {
        return this.dividerLineColor.orElse(TooltipsConfig.DIVIDER_LINE_COLOR);
    }

    public boolean hasCustomTexture() {
        return this.texture.isPresent() && !this.texture.get().trim().isEmpty();
    }

    public boolean hasCustomItemRating() {
        return this.itemRating.isPresent() && !this.itemRating.get().trim().isEmpty();
    }

    public boolean shouldShowRating() {
        return this.showRating.orElse(TooltipsConfig.SHOW_RATING);
    }

    public boolean shouldDisableIcon() {
        return this.disableIcon.isPresent() && this.disableIcon.get() != false;
    }

    public boolean shouldShowSecondPanel() {
        return this.showSecondPanel.isPresent() && this.showSecondPanel.get() != false;
    }

    public boolean hasCustomColorItemRating() {
        return this.colorItemRating.isPresent();
    }

    public static enum InnerBorderType {
        NONE,
        STATIC,
        GLINT,
        GRADIENT,
        AUTO_STATIC,
        AUTO_GLINT,
        AUTO_GRADIENT;

    }

    public static enum GradientType {
        COMMON,
        UNCOMMON,
        RARE,
        EPIC,
        LEGENDARY,
        CHAOS,
        CUSTOM;

    }

    public static enum DividerLineType {
        NONE,
        NORMAL;

    }
}

