/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class RimLightEffect
implements ITooltipEffect {
    private final int color1;
    private final int color2;

    public RimLightEffect(int color1, int color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    @Override
    public void render(LayerDepth depth, TooltipContext context, Vec2 pos, Point size) {
        Point size2 = new Point(size.x + 8, size.y + 8);
        Vec2 start = pos.m_165908_(-4.0f);
        float time = context.time();
        float width = 8.0f + 3.0f * (float)Math.cos(time * 1.1f);
        Matrix4f matrix = context.pose().m_85850_().m_252922_();
        VertexConsumer buf = context.buffer().m_6299_(RenderType.m_286086_());
        RimLightEffect.draw(matrix, buf, start, size2, width, this.color1, this.color2);
        RimLightEffect.draw(matrix, buf, start.m_165908_(-1.0f), new Point(size2.x + 2, size2.y + 2), width * 1.6f, RimLightEffect.mulAlpha(this.color1, 0.35f), this.color2);
        for (int edge = 0; edge < 4; ++edge) {
            float k = (float)Math.max(0.0, Math.sin((double)(time * 3.2f) + (double)edge * 1.57));
            if (k < 0.05f) continue;
            RimLightEffect.drawEdge(matrix, buf, start, size2, width * 0.6f, RimLightEffect.mulAlpha(this.color1, 0.5f + 0.35f * k), this.color2, edge);
        }
    }

    private static int mulAlpha(int color, float scale) {
        int alpha = color >>> 24 & 0xFF;
        return color & 0xFFFFFF | Math.max(0, Math.min(255, Math.round((float)alpha * scale))) << 24;
    }

    private static void draw(Matrix4f m, VertexConsumer buf, Vec2 start, Point size, float w, int color1, int color2) {
        buf.m_252986_(m, start.f_82470_, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
        buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
        buf.m_252986_(m, start.f_82470_, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
        buf.m_252986_(m, start.f_82470_, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
        buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
    }

    private static void drawEdge(Matrix4f m, VertexConsumer buf, Vec2 start, Point size, float w, int color1, int color2, int edge) {
        switch (edge) {
            case 0: {
                buf.m_252986_(m, start.f_82470_, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
                buf.m_252986_(m, start.f_82470_, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
                buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
                buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
                break;
            }
            case 1: {
                buf.m_252986_(m, start.f_82470_, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
                buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
                buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
                buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
                break;
            }
            case 2: {
                buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + w, 0.0f).m_193479_(color2).m_5752_();
                buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
                buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
                buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_, 0.0f).m_193479_(color1).m_5752_();
                break;
            }
            case 3: {
                buf.m_252986_(m, start.f_82470_ + w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
                buf.m_252986_(m, start.f_82470_, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
                buf.m_252986_(m, start.f_82470_ + (float)size.x, start.f_82471_ + (float)size.y, 0.0f).m_193479_(color1).m_5752_();
                buf.m_252986_(m, start.f_82470_ + (float)size.x - w, start.f_82471_ + (float)size.y - w, 0.0f).m_193479_(color2).m_5752_();
            }
        }
    }
}

