/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;

public class TooltipContext {
    private final GuiGraphics graphics;
    private final int mouseX;
    private final int mouseY;
    private final int screenW;
    private final int screenH;
    private final List<?> components;
    private ItemStack stack;
    private float elapsedSeconds = 0.0f;

    private TooltipContext(GuiGraphics graphics, int mouseX, int mouseY, int screenW, int screenH, List<ClientTooltipComponent> components, ItemStack stack) {
        this.graphics = graphics;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.screenW = screenW;
        this.screenH = screenH;
        this.components = components;
        this.stack = stack;
    }

    public static TooltipContext of(GuiGraphics graphics, int mouseX, int mouseY, int screenW, int screenH, List<ClientTooltipComponent> components, ItemStack stack) {
        return new TooltipContext(graphics, mouseX, mouseY, screenW, screenH, components, stack);
    }

    public List<?> getComponents() {
        return this.components;
    }

    public int mouseX() {
        return this.mouseX;
    }

    public int mouseY() {
        return this.mouseY;
    }

    public int width() {
        return this.screenW;
    }

    public int height() {
        return this.screenH;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public float time() {
        return this.elapsedSeconds;
    }

    public GuiGraphics graphics() {
        return this.graphics;
    }

    public PoseStack pose() {
        return this.graphics.pose();
    }

    public MultiBufferSource buffer() {
        return this.graphics.bufferSource();
    }

    public void push(Runnable r) {
        this.pose().pushPose();
        try {
            r.run();
        }
        finally {
            this.pose().popPose();
        }
    }

    public void translate(float x, float y, float z) {
        this.pose().translate(x, y, z);
    }

    public void scale(float x, float y, float z) {
        this.pose().scale(x, y, z);
    }

    public void multiply(Axis axis, float degrees) {
        this.pose().mulPose(axis.rotationDegrees(degrees));
    }

    public void flush() {
        this.graphics.flush();
    }
}

