/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import dev.xylonity.tooltipoverhaul.client.Palette;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public record CustomFrameData(List<String> items, List<String> tags, Optional<String> texture, Optional<InnerBorderType> borderType, Optional<GradientType> gradientType, Optional<List<String>> gradientColors, Optional<String> itemRating, Optional<Integer> colorItemRating, Optional<String> particles, Optional<String> specialEffect, Optional<Boolean> disableTooltip) {
    public String getTexture() {
        return this.texture.filter(t -> !t.trim().isEmpty()).orElse(Defaults.TEXTURE);
    }

    public InnerBorderType getBorderType() {
        return this.borderType.orElse(Defaults.BORDER_TYPE);
    }

    public GradientType getGradientType() {
        return this.gradientType.orElse(Defaults.GRADIENT_TYPE);
    }

    public List<String> getGradientColors() {
        return this.gradientColors.filter(colors -> colors.size() >= 3).map(colors -> colors.subList(0, 3)).orElse(Defaults.GRADIENT_COLORS);
    }

    public String getItemRating(ItemStack stack) {
        return this.itemRating.filter(rating -> !rating.trim().isEmpty()).orElseGet(() -> CustomFrameData.formatRarity(stack.getRarity()));
    }

    public int getItemRatingColor(ItemStack stack) {
        return this.colorItemRating.orElseGet(() -> CustomFrameData.getRarityColor(stack));
    }

    public boolean shouldDisableTooltip() {
        return this.disableTooltip.orElse(false);
    }

    private static int getRarityColor(ItemStack stack) {
        return switch (stack.getRarity()) {
            case Rarity.COMMON -> Palette.COMMON[0];
            case Rarity.UNCOMMON -> Palette.UNCOMMON[0];
            case Rarity.RARE -> Palette.RARE[0];
            case Rarity.EPIC -> Palette.EPIC[0];
            default -> Palette.LEGENDARY[0];
        };
    }

    public String getEffect() {
        return this.specialEffect.filter(effect -> !effect.trim().isEmpty()).orElse("none");
    }

    public List<ResourceLocation> getItemLocations() {
        return this.items.stream().map(ResourceLocation::parse).collect(Collectors.toList());
    }

    public List<TagKey<Item>> getTagKeys() {
        return this.tags.stream().map(name -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)name))).collect(Collectors.toList());
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.parse((String)this.getTexture());
    }

    public List<Color> getGradientColorValues() {
        return this.getGradientColors().stream().map(hex -> Color.decode((String)(hex.startsWith("#") ? hex : "#" + hex))).collect(Collectors.toList());
    }

    public boolean matches(ItemStack stack) {
        if (this.items.contains(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString())) {
            return true;
        }
        for (TagKey<Item> tagKey : this.getTagKeys()) {
            if (!stack.is(tagKey)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomTexture() {
        return this.texture.isPresent() && !this.texture.get().trim().isEmpty();
    }

    public boolean hasCustomBorderType() {
        return this.borderType.isPresent();
    }

    public boolean hasCustomGradientType() {
        return this.gradientType.isPresent();
    }

    public boolean hasCustomGradientColors() {
        return this.gradientColors.isPresent() && this.gradientColors.get().size() >= 3;
    }

    public boolean hasCustomItemRating() {
        return this.itemRating.isPresent() && !this.itemRating.get().trim().isEmpty();
    }

    public boolean hasCustomColorItemRating() {
        return this.colorItemRating.isPresent();
    }

    public boolean hasCustomParticles() {
        return this.particles.isPresent() && !this.particles.get().trim().isEmpty();
    }

    public boolean hasCustomSpecialEffect() {
        return this.specialEffect.isPresent() && !this.specialEffect.get().trim().isEmpty();
    }

    public boolean hasCustomDisableTooltip() {
        return this.disableTooltip.isPresent();
    }

    private static String formatRarity(Rarity rarity) {
        String name = rarity.name();
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    public static final class Defaults {
        public static final String TEXTURE = null;
        public static final InnerBorderType BORDER_TYPE = InnerBorderType.GRADIENT;
        public static final GradientType GRADIENT_TYPE = GradientType.COMMON;
        public static final List<String> GRADIENT_COLORS = List.of("#FFFFFFFF", "#FFFFFFFF", "#FFFFFFFF");
        public static final String SPECIAL_EFFECT = "none";
        public static final boolean DISABLE_TOOLTIP = false;
    }

    public static enum InnerBorderType {
        STATIC,
        GLINT,
        GRADIENT,
        AUTO_STATIC,
        AUTO_GLINT,
        AUTO_GRADIENT;

    }

    public static enum GradientType {
        COMMON,
        UNCOMMON,
        RARE,
        EPIC,
        LEGENDARY,
        CHAOS,
        CUSTOM;

    }

    public static class Builder {
        private List<String> items = List.of();
        private List<String> tags = List.of();
        private Optional<String> texture = Optional.empty();
        private Optional<InnerBorderType> borderType = Optional.empty();
        private Optional<GradientType> gradientType = Optional.empty();
        private Optional<List<String>> gradientColors = Optional.empty();
        private Optional<String> itemRating = Optional.empty();
        private Optional<Integer> colorItemRating = Optional.empty();
        private Optional<String> particles = Optional.empty();
        private Optional<String> specialEffect = Optional.empty();
        private Optional<Boolean> disableTooltip = Optional.empty();

        public Builder items(List<String> items) {
            this.items = items != null ? items : List.of();
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags != null ? tags : List.of();
            return this;
        }

        public Builder texture(String texture) {
            this.texture = Optional.ofNullable(texture);
            return this;
        }

        public Builder borderType(InnerBorderType borderType) {
            this.borderType = Optional.ofNullable(borderType);
            return this;
        }

        public Builder gradientType(GradientType gradientType) {
            this.gradientType = Optional.ofNullable(gradientType);
            return this;
        }

        public Builder gradientColors(List<String> gradientColors) {
            this.gradientColors = Optional.ofNullable(gradientColors);
            return this;
        }

        public Builder itemRating(String itemRating) {
            this.itemRating = Optional.ofNullable(itemRating);
            return this;
        }

        public Builder colorItemRating(Integer colorItemRating) {
            this.colorItemRating = Optional.ofNullable(colorItemRating);
            return this;
        }

        public Builder particles(String particles) {
            this.particles = Optional.ofNullable(particles);
            return this;
        }

        public Builder specialEffect(String specialEffect) {
            this.specialEffect = Optional.ofNullable(specialEffect);
            return this;
        }

        public Builder disableTooltip(Boolean disableTooltip) {
            this.disableTooltip = Optional.ofNullable(disableTooltip);
            return this;
        }

        public CustomFrameData build() {
            return new CustomFrameData(this.items, this.tags, this.texture, this.borderType, this.gradientType, this.gradientColors, this.itemRating, this.colorItemRating, this.particles, this.specialEffect, this.disableTooltip);
        }
    }
}

