/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style;

import dev.xylonity.tooltipoverhaul.client.Palette;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import dev.xylonity.tooltipoverhaul.client.style.TooltipStyle;
import dev.xylonity.tooltipoverhaul.client.style.TooltipStyleBuilder;
import dev.xylonity.tooltipoverhaul.client.style.effect.CinderEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.MetalShiningEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.RimLightEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.RipplesEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.SonarEffect;
import dev.xylonity.tooltipoverhaul.client.style.effect.StarsEffect;
import dev.xylonity.tooltipoverhaul.client.style.inner.GlintInnerOverlay;
import dev.xylonity.tooltipoverhaul.client.style.inner.GradientInnerOverlay;
import dev.xylonity.tooltipoverhaul.client.style.inner.StaticInnerOverlay;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class Styles {
    public static final TooltipStyleBuilder COMMON = new TooltipStyleBuilder();
    public static final TooltipStyleBuilder UNCOMMON = new TooltipStyleBuilder();
    public static final TooltipStyleBuilder RARE = new TooltipStyleBuilder();
    public static final TooltipStyleBuilder EPIC = new TooltipStyleBuilder().addEffect(new MetalShiningEffect());
    public static final TooltipStyleBuilder LEGENDARY = new TooltipStyleBuilder().addEffect(new MetalShiningEffect());
    public static final TooltipStyleBuilder CHAOS = new TooltipStyleBuilder().addEffect(new MetalShiningEffect());

    private static void populateStyles() {
        switch (TooltipsConfig.DEFAULT_INNER_OVERLAY_TYPE.toLowerCase()) {
            case "static": {
                COMMON.innerOverlay(new StaticInnerOverlay(Palette.COMMON[0]));
                UNCOMMON.innerOverlay(new StaticInnerOverlay(Palette.UNCOMMON[0]));
                RARE.innerOverlay(new StaticInnerOverlay(Palette.RARE[0]));
                EPIC.innerOverlay(new StaticInnerOverlay(Palette.EPIC[0]));
                LEGENDARY.innerOverlay(new StaticInnerOverlay(Palette.LEGENDARY[0]));
                CHAOS.innerOverlay(new StaticInnerOverlay(Palette.CHAOS[0]));
                break;
            }
            case "gradient": {
                COMMON.innerOverlay(new GradientInnerOverlay(Palette.COMMON[0], Palette.COMMON[1], Palette.COMMON[2]));
                UNCOMMON.innerOverlay(new GradientInnerOverlay(Palette.UNCOMMON[0], Palette.UNCOMMON[1], Palette.UNCOMMON[2]));
                RARE.innerOverlay(new GradientInnerOverlay(Palette.RARE[0], Palette.RARE[1], Palette.RARE[2]));
                EPIC.innerOverlay(new GradientInnerOverlay(Palette.EPIC[0], Palette.EPIC[1], Palette.EPIC[2]));
                LEGENDARY.innerOverlay(new GradientInnerOverlay(Palette.LEGENDARY[0], Palette.LEGENDARY[1], Palette.LEGENDARY[2]));
                CHAOS.innerOverlay(new GradientInnerOverlay(Palette.CHAOS[0], Palette.CHAOS[1], Palette.CHAOS[2]));
                break;
            }
            default: {
                COMMON.innerOverlay(new GlintInnerOverlay(Palette.COMMON[0], Palette.COMMON[1], 0, 5, 3));
                UNCOMMON.innerOverlay(new GlintInnerOverlay(Palette.UNCOMMON[0], Palette.UNCOMMON[1], 0, 5, 3));
                RARE.innerOverlay(new GlintInnerOverlay(Palette.RARE[0], Palette.RARE[1], 0, 4, 2));
                EPIC.innerOverlay(new GlintInnerOverlay(Palette.EPIC[0], Palette.EPIC[1], 0, 4, 2));
                LEGENDARY.innerOverlay(new GlintInnerOverlay(Palette.LEGENDARY[0], Palette.LEGENDARY[1], 0, 4, 2));
                CHAOS.innerOverlay(new GlintInnerOverlay(Palette.CHAOS[0], Palette.CHAOS[1], 0, 4, 2));
            }
        }
    }

    public static Optional<TooltipStyle> of(ItemStack stack, CustomFrameData data) {
        if (data == null) {
            return Optional.of(switch (stack.getRarity()) {
                case Rarity.COMMON -> COMMON.build();
                case Rarity.UNCOMMON -> UNCOMMON.build();
                case Rarity.RARE -> RARE.build();
                case Rarity.EPIC -> EPIC.build();
                default -> LEGENDARY.build();
            });
        }
        TooltipStyleBuilder builder = new TooltipStyleBuilder();
        ArrayList<Integer> grads = new ArrayList<Integer>();
        switch (data.getGradientType()) {
            case COMMON: 
            case UNCOMMON: 
            case RARE: 
            case EPIC: 
            case LEGENDARY: 
            case CHAOS: {
                Object p = Palette.of(data.getGradientType());
                grads.add((int)p[0]);
                grads.add((int)p[1]);
                grads.add((int)p[2]);
                break;
            }
            default: {
                Object p = data.getGradientColors().iterator();
                while (p.hasNext()) {
                    String hex = (String)p.next();
                    grads.add(Styles.color(hex));
                }
                while (grads.size() < 3) {
                    grads.add(0);
                }
                break block6;
            }
        }
        switch (data.getBorderType()) {
            case GLINT: {
                builder.innerOverlay(new GlintInnerOverlay((Integer)grads.get(0), (Integer)grads.get(1), 0, 4, 2));
                break;
            }
            case GRADIENT: {
                builder.innerOverlay(new GradientInnerOverlay((Integer)grads.get(0), (Integer)grads.get(1), (Integer)grads.get(2)));
                break;
            }
            case STATIC: {
                builder.innerOverlay(new StaticInnerOverlay((Integer)grads.get(0)));
                break;
            }
            case AUTO_GRADIENT: {
                int[] auto;
                if (data.hasCustomTexture()) {
                    auto = CustomFrameManager.getPalette(data);
                    if (auto != null && auto.length >= 3) {
                        builder.innerOverlay(new GradientInnerOverlay(auto[0], auto[1], auto[2]));
                        break;
                    }
                    builder.innerOverlay(new GradientInnerOverlay((Integer)grads.get(0), (Integer)grads.get(1), (Integer)grads.get(2)));
                    break;
                }
                builder.innerOverlay(new GradientInnerOverlay((Integer)grads.get(0), (Integer)grads.get(1), (Integer)grads.get(2)));
                break;
            }
            case AUTO_GLINT: {
                int[] auto;
                if (data.hasCustomTexture()) {
                    auto = CustomFrameManager.getPalette(data);
                    if (auto != null && auto.length >= 3) {
                        builder.innerOverlay(new GlintInnerOverlay(auto[0], auto[1], 0, 4, 2));
                        break;
                    }
                    builder.innerOverlay(new GlintInnerOverlay((Integer)grads.get(0), (Integer)grads.get(1), 0, 4, 2));
                    break;
                }
                builder.innerOverlay(new GlintInnerOverlay((Integer)grads.get(0), (Integer)grads.get(1), 0, 4, 2));
                break;
            }
            case AUTO_STATIC: {
                int[] auto;
                if (data.hasCustomTexture()) {
                    auto = CustomFrameManager.getPalette(data);
                    if (auto != null && auto.length >= 3) {
                        builder.innerOverlay(new StaticInnerOverlay(auto[0]));
                        break;
                    }
                    builder.innerOverlay(new StaticInnerOverlay((Integer)grads.get(0)));
                    break;
                }
                builder.innerOverlay(new StaticInnerOverlay((Integer)grads.get(0)));
            }
        }
        switch (data.getEffect()) {
            case "metal_shining": {
                builder.addEffect(new MetalShiningEffect());
                break;
            }
            case "ripples": {
                builder.addEffect(new RipplesEffect());
                break;
            }
            case "stars": {
                builder.addEffect(new StarsEffect());
                break;
            }
            case "sonar": {
                builder.addEffect(new SonarEffect());
                break;
            }
            case "cinder": {
                builder.addEffect(new CinderEffect());
                break;
            }
            case "rim_light": {
                builder.addEffect(new RimLightEffect(-2011870087, 0));
            }
        }
        return Optional.of(builder.build());
    }

    private static int color(String hex) {
        String s = hex.startsWith("#") ? hex.substring(1) : hex;
        long value = Long.parseLong(s, 16);
        if (s.length() == 6) {
            value |= 0xFF000000L;
        }
        return (int)value;
    }

    static {
        Styles.populateStyles();
    }
}

