/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.inner;

import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipFrame;
import java.awt.Point;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;

public class GlintInnerOverlay
implements ITooltipFrame {
    private final int color1;
    private final int color2;
    private final int color3;
    private final int timesSegmentedColor1;
    private final int timesSegmentedColor2;

    public GlintInnerOverlay(int color1, int color2, int color3, int timesSegmentedColor1, int timesSegmentedColor2) {
        this.color1 = color1;
        this.color2 = color2;
        this.color3 = color3;
        this.timesSegmentedColor1 = timesSegmentedColor1;
        this.timesSegmentedColor2 = timesSegmentedColor2;
    }

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.glint(ctx.graphics(), (int)pos.x - 3, (int)pos.y - 3, size.x + 6, size.y + 6, depth.getZ());
    }

    private void glint(GuiGraphics graphics, int x, int y, int width, int height, int z) {
        int per = 2 * (width + height) - 4;
        int center = width / 4;
        int LIGHT = this.color1;
        int MEDIUM = this.color2;
        int DARK = this.color3;
        int LIGHT_RANGE = Math.max(1, width / this.timesSegmentedColor1);
        int MEDIUM_RANGE = Math.max(1, width / this.timesSegmentedColor2);
        for (int i = 0; i < per; ++i) {
            int py;
            int px;
            if (i < width) {
                px = x + i;
                py = y;
            } else if (i < width + height - 1) {
                px = x + width - 1;
                py = y + (i - width + 1);
            } else if (i < 2 * width + height - 2) {
                j = i - (width + height - 1);
                px = x + (width - 1) - j;
                py = y + height - 1;
            } else {
                j = i - (2 * width + height - 2);
                px = x;
                py = y + (height - 2) - j;
            }
            int cw = (i - center + per) % per;
            int ccw = (center - i + per) % per;
            int color = cw <= LIGHT_RANGE ? GlintInnerOverlay.blend(LIGHT, MEDIUM, (float)cw / (float)LIGHT_RANGE) : (cw <= LIGHT_RANGE + MEDIUM_RANGE ? GlintInnerOverlay.blend(MEDIUM, DARK, (float)(cw - LIGHT_RANGE) / (float)MEDIUM_RANGE) : (ccw <= LIGHT_RANGE ? GlintInnerOverlay.blend(LIGHT, MEDIUM, (float)ccw / (float)LIGHT_RANGE) : (ccw <= LIGHT_RANGE + MEDIUM_RANGE ? GlintInnerOverlay.blend(MEDIUM, DARK, (float)(ccw - LIGHT_RANGE) / (float)MEDIUM_RANGE) : DARK)));
            graphics.fill(px, py, px + 1, py + 1, z, color);
        }
    }

    private static int blend(int c1, int c2, float t) {
        int a1 = c1 >>> 24;
        int r1 = c1 >>> 16 & 0xFF;
        int g1 = c1 >>> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int a2 = c2 >>> 24;
        int r2 = c2 >>> 16 & 0xFF;
        int g2 = c2 >>> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

