/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipIcon;
import dev.xylonity.tooltipoverhaul.compat.modernfix.ModernFixCompat;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec2;

public class DefaultIcon
implements ITooltipIcon {
    private static final float ANIMATION_DURATION = 0.6f;

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        if (ModernFixCompat.STATIC_RENDERING_ENABLED) {
            this.renderStatic(depth, ctx, pos, size);
        } else {
            this.renderDefault(depth, ctx, pos, size);
        }
    }

    private void renderDefault(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        ctx.push(() -> {
            ctx.translate(0.0f, 0.0f, depth.getZ());
            ctx.translate(pos.x + 6.0f + 4.0f + 8.0f, pos.y + 4.0f + 4.0f + 8.0f, 0.0f);
            ctx.translate(0.0f, 0.0f, 150.0f);
            float progress = Math.min(TooltipRenderer.ELAPSED / 0.6f, 1.0f);
            if (TooltipRenderer.ELAPSED < 0.6f) {
                float scale = DefaultIcon.easeOutQuint(progress);
                ctx.scale(scale * 1.5f, scale * 1.5f, scale * 1.5f);
                ctx.multiply(Axis.YP, (float)((double)(TooltipRenderer.ELAPSED * 5.0f * 360.0f) / 6.0 % 360.0));
            } else {
                ctx.scale(1.5f, 1.5f, 1.5f);
                float elapsed = TooltipRenderer.ELAPSED - 0.6f;
                float finalRot = 180.0f;
                ctx.multiply(Axis.YP, (float)((double)finalRot + (double)(elapsed * 360.0f) / 6.0 % 360.0));
            }
            ctx.translate(-8.0f, -8.0f, -150.0f);
            ctx.graphics().renderItem(ctx.stack(), 0, 0);
        });
    }

    private void renderStatic(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        ctx.push(() -> {
            float angle;
            float scale;
            ctx.translate(0.0f, 0.0f, depth.getZ());
            ctx.translate(pos.x + 6.0f + 12.0f, pos.y + 4.0f + 12.0f, 0.0f);
            float time = Math.min(TooltipRenderer.ELAPSED / 0.6f, 1.0f);
            float f = scale = TooltipRenderer.ELAPSED < 0.6f ? DefaultIcon.easeOutQuint(time) * 1.5f : 1.5f;
            if (TooltipRenderer.ELAPSED < 0.6f) {
                angle = (float)((double)TooltipRenderer.ELAPSED * 5.0 * 360.0 / 6.0 % 360.0);
            } else {
                float normal = TooltipRenderer.ELAPSED - 0.6f;
                float rot = 180.0f;
                angle = (float)(((double)rot + (double)normal * 360.0 / 6.0) % 360.0);
            }
            ctx.multiply(Axis.YP, angle);
            ctx.scale(1.0f, -1.0f, 1.0f);
            ctx.scale(20.0f * scale, 20.0f * scale, 20.0f * scale);
            Minecraft minecraft = Minecraft.getInstance();
            BakedModel model = minecraft.getItemRenderer().getModel(ctx.stack(), null, null, 0);
            if (ctx.stack().getItem() instanceof BlockItem && model.isGui3d()) {
                ctx.multiply(Axis.XP, 30.0f);
                ctx.multiply(Axis.YP, -45.0f);
            }
            Lighting.setupForFlatItems();
            Minecraft.getInstance().getItemRenderer().renderStatic(ctx.stack(), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, ctx.graphics().pose(), (MultiBufferSource)ctx.graphics().bufferSource(), null, 0);
        });
    }

    private static float easeOutQuint(float t) {
        float cubicPart = 1.0f - (float)Math.pow(1.0f - t, 3.0);
        return cubicPart * t + t * (1.0f - t);
    }
}

