/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.text;

import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.TooltipScrollState;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipText;
import java.awt.Point;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;

public class DefaultText
implements ITooltipText {
    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size, Component rarity, Font font) {
        ctx.push(() -> {
            int h;
            int x;
            ClientTooltipComponent component;
            int i;
            int firstLineOffset;
            ctx.translate(0.0f, 0.0f, depth.getZ());
            boolean hasIcon = !ctx.stack().isEmpty();
            int n = firstLineOffset = hasIcon ? 32 : 6;
            if (hasIcon && rarity != null && !rarity.getString().isEmpty()) {
                int px = Math.min(ctx.mouseX() + 12, ctx.width() - size.x - 4);
                int py = Math.min(ctx.mouseY() - 12, ctx.height() - size.y - 4);
                ctx.graphics().drawString(font, rarity, px + 26 + 6, py + 13 + 4, 15588982, false);
            }
            if (!TooltipScrollState.isIsActive()) {
                int x2;
                ClientTooltipComponent component2;
                int i2;
                int y = (int)pos.y + 4 + 3;
                for (i2 = 0; i2 < ctx.getComponents().size(); ++i2) {
                    component2 = (ClientTooltipComponent)ctx.getComponents().get(i2);
                    if (i2 == 1) {
                        y += 3;
                    }
                    if (hasIcon && i2 == 1) {
                        y += 12;
                    }
                    x2 = (int)pos.x + (i2 == 0 ? firstLineOffset : 6);
                    component2.renderText(font, x2, y, ctx.pose().last().pose(), ctx.graphics().bufferSource());
                    y += component2.getHeight();
                    if (!hasIcon || i2 != 0 || ctx.getComponents().size() <= 1) continue;
                    y += 6;
                }
                y = (int)pos.y + 4 + 6;
                for (i2 = 0; i2 < ctx.getComponents().size(); ++i2) {
                    component2 = (ClientTooltipComponent)ctx.getComponents().get(i2);
                    if (hasIcon && i2 == 1) {
                        y += 12;
                    }
                    x2 = (int)pos.x + (i2 == 0 ? firstLineOffset : 6);
                    component2.renderImage(font, x2, y, ctx.graphics());
                    y += component2.getHeight();
                    if (!hasIcon || i2 != 0 || ctx.getComponents().size() <= 1) continue;
                    y += 6;
                }
                return;
            }
            int yTitle = (int)pos.y + 4 + 3;
            if (!ctx.getComponents().isEmpty()) {
                ClientTooltipComponent title = (ClientTooltipComponent)ctx.getComponents().get(0);
                int xTitle = (int)pos.x + firstLineOffset;
                title.renderText(font, xTitle, yTitle, ctx.pose().last().pose(), ctx.graphics().bufferSource());
                ctx.flush();
            }
            int toLeft = (int)pos.x + 6;
            int toTop = TooltipRenderer.LAST_POS_YI + TooltipRenderer.LAST_HEADER_ABS + 7;
            int toRight = (int)pos.x + size.x - 6;
            int toBottom = Math.min(TooltipRenderer.LAST_POS_YI + size.y - 4 - 1, ctx.height() - 4);
            ctx.graphics().enableScissor(toLeft, toTop, toRight, toBottom);
            int scroll = TooltipScrollState.getScroll();
            int y = TooltipRenderer.LAST_POS_YI + TooltipRenderer.LAST_HEADER_ABS - scroll;
            for (i = 1; i < ctx.getComponents().size(); ++i) {
                component = (ClientTooltipComponent)ctx.getComponents().get(i);
                x = (int)pos.x + 6;
                h = component.getHeight();
                if (y + h >= toTop && y <= toBottom) {
                    component.renderText(font, x, y, ctx.pose().last().pose(), ctx.graphics().bufferSource());
                }
                y += h;
            }
            y = TooltipRenderer.LAST_POS_YI + TooltipRenderer.LAST_HEADER_ABS - scroll;
            for (i = 1; i < ctx.getComponents().size(); ++i) {
                component = (ClientTooltipComponent)ctx.getComponents().get(i);
                x = (int)pos.x + 6;
                h = component.getHeight();
                if (y + h >= toTop && y <= toBottom) {
                    component.renderImage(font, x, y, ctx.graphics());
                }
                y += h;
            }
            ctx.graphics().disableScissor();
        });
    }
}

