/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.compat.modernfix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class ModernFixCompat {
    public static final boolean STATIC_RENDERING_ENABLED = ModernFixCompat.isModernFixEntryEnabled();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isModernFixEntryEnabled() {
        try {
            Path path;
            if (TooltipOverhaul.PLATFORM.isModLoaded("flerovium") && Files.exists(path = TooltipOverhaul.PLATFORM.resolveConfigFile("flerovium.json"), new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    JsonElement value;
                    JsonObject item;
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    if (element != null && element.isJsonObject() && (item = element.getAsJsonObject()).has("itemBackFaceCulling") && (value = item.get("itemBackFaceCulling")).isJsonPrimitive()) {
                        JsonPrimitive bool = value.getAsJsonPrimitive();
                        if (bool.isBoolean() && bool.getAsBoolean()) {
                            boolean bl = true;
                            return bl;
                        }
                        if (bool.isString() && Boolean.parseBoolean(bool.getAsString())) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            if (!TooltipOverhaul.PLATFORM.isModLoaded("modernfix")) {
                return false;
            }
            path = TooltipOverhaul.PLATFORM.resolveConfigFile("modernfix-mixins.properties");
            if (!Files.exists(path, new LinkOption[0])) {
                return false;
            }
            Properties properties = new Properties();
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(in);
                return "true".equalsIgnoreCase(properties.getProperty("mixin.perf.faster_item_rendering"));
            }
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

