/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.mixin;

import dev.xylonity.tooltipoverhaul.compat.proxy.EmiProxy;
import dev.xylonity.tooltipoverhaul.compat.proxy.JeiProxy;
import dev.xylonity.tooltipoverhaul.mixin.AbstractContainerScreenMixin;
import dev.xylonity.tooltipoverhaul.util.ITooltipOverhaulItemAware;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1)
public class GuiGraphicsItemMixin
implements ITooltipOverhaulItemAware {
    @Final
    @Shadow
    private Minecraft minecraft;
    @Unique
    private ItemStack tooltipsOverhaul$currentItemStack = ItemStack.EMPTY;

    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")})
    private void tooltipsOverhaul$captureHovered(Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner positioner, CallbackInfo ci) {
        this.tooltipsOverhaul$currentItemStack = ItemStack.EMPTY;
        ItemStack jeiStack = JeiProxy.getItemStack();
        if (!jeiStack.isEmpty()) {
            this.tooltipsOverhaul$currentItemStack = jeiStack;
            return;
        }
        ItemStack emiStack = EmiProxy.getItemStack();
        if (!emiStack.isEmpty()) {
            this.tooltipsOverhaul$currentItemStack = emiStack;
            return;
        }
        Screen screen = this.minecraft.screen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen container = (AbstractContainerScreen)screen;
            try {
                ItemStack stack;
                Slot slot = ((AbstractContainerScreenMixin)container).getHoveredSlot();
                if (slot != null && !(stack = slot.getItem()).isEmpty()) {
                    this.tooltipsOverhaul$currentItemStack = stack;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public ItemStack tooltipsOverhaul$hoveredItem() {
        return this.tooltipsOverhaul$currentItemStack;
    }
}

