/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.compat.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.xylonity.tooltipoverhaul.compat.emi.EmiDeferredHover;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

public final class EmiHoverHolder {
    private static final String RECIPESCREEN_CLASS_LOCATION = "dev.emi.emi.screen.RecipeScreen";

    private static boolean isTagCategory() {
        try {
            String id;
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.screen == null) {
                return false;
            }
            Class<?> recipeScreen = Class.forName(RECIPESCREEN_CLASS_LOCATION, false, EmiHoverHolder.class.getClassLoader());
            if (!recipeScreen.isInstance(minecraft.screen)) {
                return false;
            }
            Method method = recipeScreen.getMethod("getFocusedCategory", new Class[0]);
            Object category = method.invoke((Object)minecraft.screen, new Object[0]);
            if (category == null) {
                return false;
            }
            Method getId = category.getClass().getMethod("getId", new Class[0]);
            Object idValue = getId.invoke(category, new Object[0]);
            String string = id = idValue == null ? null : idValue.toString();
            if (id == null) {
                return false;
            }
            String ss = id.toLowerCase(Locale.ROOT);
            return ss.contains("tag");
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean isTagIngredient(EmiIngredient ei) {
        try {
            String isIng = ei.getClass().getName().toLowerCase(Locale.ROOT);
            return isIng.contains("tag");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static ItemStack getItemStack() {
        if (EmiHoverHolder.isTagCategory()) {
            return ItemStack.EMPTY;
        }
        ItemStack fromCache = EmiDeferredHover.pop();
        if (!fromCache.isEmpty()) {
            return fromCache;
        }
        ItemStack itemStack = EmiHoverHolder.fromRecipeScreen();
        if (!itemStack.isEmpty()) {
            return itemStack;
        }
        EmiStackInteraction internal = EmiApi.getHoveredStack((boolean)true);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.isEmpty()) {
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getItemStack(int mouseX, int mouseY) {
        if (EmiHoverHolder.isTagCategory()) {
            return ItemStack.EMPTY;
        }
        ItemStack fromCache = EmiDeferredHover.pop();
        if (!fromCache.isEmpty()) {
            return fromCache;
        }
        ItemStack itemStack = EmiHoverHolder.fromRecipeScreen();
        if (!itemStack.isEmpty()) {
            return itemStack;
        }
        EmiStackInteraction internal = EmiApi.getHoveredStack((int)mouseX, (int)mouseY, (boolean)true);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.isEmpty()) {
            return itemStack;
        }
        internal = EmiApi.getHoveredStack((int)mouseX, (int)mouseY, (boolean)false);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.isEmpty()) {
            return itemStack;
        }
        internal = EmiApi.getHoveredStack((boolean)true);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.isEmpty()) {
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack fromRecipeScreen() {
        try {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.screen == null) {
                return ItemStack.EMPTY;
            }
            Class<?> resource = Class.forName(RECIPESCREEN_CLASS_LOCATION, false, EmiHoverHolder.class.getClassLoader());
            if (!resource.isInstance(minecraft.screen)) {
                return ItemStack.EMPTY;
            }
            Method method = resource.getMethod("getHoveredStack", new Class[0]);
            Object ingred = method.invoke((Object)minecraft.screen, new Object[0]);
            if (!(ingred instanceof EmiIngredient)) {
                return ItemStack.EMPTY;
            }
            EmiIngredient s = (EmiIngredient)ingred;
            if (EmiHoverHolder.isTagIngredient(s)) {
                return ItemStack.EMPTY;
            }
            return EmiHoverHolder.getStack(s);
        }
        catch (Exception exception) {
            return ItemStack.EMPTY;
        }
    }

    private static ItemStack getStack(EmiStackInteraction hovered) {
        if (hovered == null || hovered.isEmpty()) {
            return ItemStack.EMPTY;
        }
        EmiIngredient ingred = hovered.getStack();
        if (ingred == null) {
            return ItemStack.EMPTY;
        }
        if (EmiHoverHolder.isTagIngredient(ingred)) {
            return ItemStack.EMPTY;
        }
        return EmiHoverHolder.getStack(ingred);
    }

    private static ItemStack getStack(EmiIngredient ingred) {
        if (ingred == null) {
            return ItemStack.EMPTY;
        }
        List list = ingred.getEmiStacks();
        if (list == null || list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (EmiStack es : list) {
            ItemStack st;
            if (es == null || (st = es.getItemStack()) == null || st.isEmpty()) continue;
            return st;
        }
        return ItemStack.EMPTY;
    }
}

