/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;

public class RipplesEffect
implements ITooltipEffect {
    private static final int RIPPLES = 6;
    private static final int RING_SEGMENTS = 48;
    private static final float THICKNESS = 8.0f;
    private static final float GLOW = 1.75f;
    private static final float TWEAKING = 1.2f;
    private static final float TWEAKING_MULTIPLIER = 10.0f;
    private static final long PER_RIPPLE = 220L;
    private static final int[] DEFAULT_COLORS = new int[]{0x66FFFFFF, -2002724609, 0x66FFD6FF};
    private final Deque<Ripple> ripples = new ArrayDeque<Ripple>();
    private final int[] colors;
    private long lastSpawn = 0L;

    public RipplesEffect() {
        this(DEFAULT_COLORS);
    }

    public RipplesEffect(int[] rippleColors) {
        this.colors = rippleColors == null || rippleColors.length == 0 ? DEFAULT_COLORS : (int[])rippleColors.clone();
    }

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, class_241 pos, Point size) {
        int guiX = (int)pos.field_1343;
        int guiY = (int)pos.field_1342;
        int guiW = size.x;
        int guiH = size.y;
        int x = (int)pos.field_1343;
        int y = (int)pos.field_1342;
        int w = size.x;
        int h = size.y;
        if (w <= 2 || h <= 2) {
            return;
        }
        ctx.push(() -> {
            ctx.graphics().method_44379(guiX - 3, guiY - 3, guiX + guiW + 3, guiY + guiH + 3);
            ctx.translate(0.0f, 0.0f, depth.getZ());
            long now = System.currentTimeMillis();
            if (now - this.lastSpawn >= 220L && this.ripples.size() < 6) {
                this.spawnRipple(x, y, w, h, now);
                this.lastSpawn = now;
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            this.ripples.removeIf(r -> !r.updateAndRender(ctx, now));
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            ctx.graphics().method_44380();
        });
    }

    private void spawnRipple(int x, int y, int w, int h, long now) {
        Random random = new Random();
        float margin = 10.0f;
        float cx = (float)x + margin + random.nextFloat() * ((float)w - 2.0f * margin);
        float cy = (float)y + margin + random.nextFloat() * ((float)h - 2.0f * margin);
        float speed = RipplesEffect.lerp(0.75f, 1.35f, random.nextFloat());
        float thickness = 8.0f * RipplesEffect.lerp(0.85f, 1.35f, random.nextFloat());
        float tweakingAmount = random.nextFloat() * ((float)Math.PI * 2);
        if (this.ripples.size() >= 6) {
            this.ripples.pollFirst();
        }
        this.ripples.addLast(new Ripple(cx, cy, 0.5f * (float)Math.hypot(w, h), this.colors[random.nextInt(this.colors.length)], now, speed, thickness, tweakingAmount));
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float easeOutCubic(float t) {
        float u = 1.0f - t;
        return 1.0f - u * u * u;
    }

    private static final class Ripple {
        private final float cx;
        private final float cy;
        private final float maxRadius;
        private final int baseColor;
        private final long birth;
        private final float speed;
        private final float thickness;
        private final float tweaking;

        public Ripple(float cx, float cy, float maxRadius, int baseColor, long birth, float speed, float thickness, float tweaking) {
            this.cx = cx;
            this.cy = cy;
            this.maxRadius = maxRadius;
            this.baseColor = baseColor;
            this.birth = birth;
            this.speed = speed;
            this.thickness = thickness;
            this.tweaking = tweaking;
        }

        boolean updateAndRender(TooltipContext ctx, long nowMs) {
            float lifetime = Math.max(0.0f, (float)(nowMs - this.birth));
            float duration = Math.max(800.0f, 1200.0f * (this.maxRadius / 120.0f));
            float time = Math.min(1.0f, lifetime / duration);
            float eased = RipplesEffect.easeOutCubic(time);
            float rad = eased * this.maxRadius * this.speed;
            float alpha = Ripple.clamp01(1.2f - time * 1.2f) * 0.85f;
            this.draw(ctx, this.cx, this.cy, rad - this.thickness * 0.5f, rad + this.thickness * 0.5f, this.baseColor, alpha, this.tweaking, nowMs);
            this.draw(ctx, this.cx, this.cy, rad + this.thickness * 0.4f, rad + this.thickness * 2.15f, this.baseColor, alpha * 0.55f, this.tweaking + 1.3f, nowMs);
            return rad < this.maxRadius + this.thickness * 2.35f;
        }

        private void draw(TooltipContext ctx, float cx, float cy, float innerR, float outerR, int color, float alphaPeak, float wobblePhase, long now) {
            float func2;
            float func1;
            float w;
            float theta;
            int i;
            if (outerR <= 1.0f) {
                return;
            }
            if (innerR < 0.0f) {
                innerR = 0.0f;
            }
            if (outerR - innerR <= 0.5f) {
                outerR = innerR + 0.5f;
            }
            int a = color >>> 24 & 0xFF;
            int r = color >>> 16 & 0xFF;
            int g = color >>> 8 & 0xFF;
            int b = color & 0xFF;
            float alphaNorm = Ripple.clamp01(alphaPeak) * ((float)a / 255.0f);
            float time = (float)now / 1000.0f;
            float tweaking = (float)Math.toRadians(10.0) * (float)Math.sin(7.5398226682211265 * (double)time + (double)wobblePhase);
            class_287 buf = class_289.method_1348().method_1349();
            RenderSystem.setShader(class_757::method_34540);
            int segments = Math.max(16, 48);
            float midR = innerR + (outerR - innerR) * 0.5f;
            buf.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            for (i = 0; i <= segments; ++i) {
                theta = (float)(Math.PI * 2 * (double)((float)i / (float)segments));
                w = theta + tweaking * (float)Math.sin(theta * 3.0f);
                func1 = (float)Math.sin(w);
                func2 = (float)Math.cos(w);
                buf.method_22918(ctx.pose().method_23760().method_23761(), cx + func2 * midR, cy + func1 * midR, 0.0f).method_1336(r, g, b, (int)(alphaNorm * 255.0f)).method_1344();
                buf.method_22918(ctx.pose().method_23760().method_23761(), cx + func2 * innerR, cy + func1 * innerR, 0.0f).method_1336(r, g, b, 0).method_1344();
            }
            class_286.method_43433((class_287.class_7433)buf.method_1326());
            buf.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            for (i = 0; i <= segments; ++i) {
                theta = (float)(Math.PI * 2 * (double)((float)i / (float)segments));
                w = theta + tweaking * (float)Math.sin(theta * 3.0f);
                func1 = (float)Math.sin(w);
                func2 = (float)Math.cos(w);
                buf.method_22918(ctx.pose().method_23760().method_23761(), cx + func2 * outerR, cy + func1 * outerR, 0.0f).method_1336(r, g, b, 0).method_1344();
                buf.method_22918(ctx.pose().method_23760().method_23761(), cx + func2 * midR, cy + func1 * midR, 0.0f).method_1336(r, g, b, (int)(alphaNorm * 255.0f)).method_1344();
            }
            class_286.method_43433((class_287.class_7433)buf.method_1326());
        }

        private static float clamp01(float v) {
            return v < 0.0f ? 0.0f : Math.min(v, 1.0f);
        }
    }
}

