/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.util;

import dev.xylonity.tooltipoverhaul.client.Palette;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.config.parser.ConfigColorParser;
import dev.xylonity.tooltipoverhaul.util.TextAxis;
import dev.xylonity.tooltipoverhaul.util.TextType;
import java.awt.Point;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class Util {
    public static float calcRotY(double time) {
        return (float)((double)System.currentTimeMillis() / time * 360.0 % 360.0);
    }

    public static boolean shouldDisableIcon(class_1799 stack) {
        return !stack.method_7960() && CustomFrameManager.of(stack).map(CustomFrameData::shouldDisableIcon).orElse(TooltipsConfig.DISABLE_ICON) != false;
    }

    public static int getSecondPanelOffset(TooltipContext ctx, TextAxis axis) {
        if (axis == TextAxis.X) {
            return ctx.data().map(CustomFrameData::getSecondPanelX).orElse(TooltipsConfig.SECOND_PANEL_X);
        }
        return ctx.data().map(CustomFrameData::getSecondPanelY).orElse(TooltipsConfig.SECOND_PANEL_Y);
    }

    public static int getMainPanelPadding(TooltipContext ctx, TextAxis axis) {
        if (axis == TextAxis.X) {
            return ctx.data().map(CustomFrameData::getMainPanelPaddingX).orElse(TooltipsConfig.MAIN_PANEL_PADDING_X);
        }
        return ctx.data().map(CustomFrameData::getMainPanelPaddingY).orElse(TooltipsConfig.MAIN_PANEL_PADDING_Y);
    }

    public static boolean isScrollingDisabled(TooltipContext ctx) {
        return ctx.data().map(CustomFrameData::shouldDisableScrolling).orElse(TooltipsConfig.DISABLE_TOOLTIP_SCROLLING);
    }

    public static int getBackgroundColor(TooltipContext ctx) {
        return ctx.data().map(CustomFrameData::getBackgroundColor).orElse(Palette.PANEL_BG);
    }

    public static boolean shouldShowRating(class_1799 stack) {
        return !stack.method_7960() && CustomFrameManager.of(stack).map(CustomFrameData::shouldShowRating).orElse(TooltipsConfig.SHOW_RATING) != false;
    }

    public static boolean shouldDisableDividerLine(TooltipContext ctx) {
        return ctx.data().map(CustomFrameData::shouldDisableDividerLine).orElse(TooltipsConfig.DISABLE_DIVIDER_LINE);
    }

    public static String getIconAppearAnimation(TooltipContext context) {
        return context.data().map(CustomFrameData::getIconAppearAnimation).orElse(TooltipsConfig.ICON_APPEAR_ANIMATION);
    }

    public static float getIconRotatingSpeed(TooltipContext context) {
        return context.data().isPresent() ? context.data().get().getIconRotatingSpeed() : TooltipsConfig.ICON_ROTATING_SPEED;
    }

    public static int getDividerLineColor(TooltipContext ctx) {
        return Util.parseDividerLineColor(ctx.data().map(CustomFrameData::getDividerLineColor).orElse(TooltipsConfig.DIVIDER_LINE_COLOR), ctx);
    }

    private static int parseDividerLineColor(String matcher, TooltipContext ctx) {
        class_1799 stack = ctx.stack();
        switch (matcher) {
            case "match_inner_frame_color": {
                if (ctx.data().isPresent()) {
                    return ConfigColorParser.parseColor(ctx.data().get().getGradientColors().get(0));
                }
                return Util.getColorPerRarity(stack);
            }
            case "match_item_name_color": {
                class_5251 color = stack.method_7964().method_10866().method_10973();
                class_5251 rarityColor = class_5251.method_27718((class_124)stack.method_7932().field_8908);
                if (color != null) {
                    return color.method_27716();
                }
                if (rarityColor == null) break;
                return rarityColor.method_27716();
            }
            default: {
                if (!matcher.startsWith("0x") && !matcher.startsWith("0X") && !matcher.startsWith("#")) break;
                return ConfigColorParser.parseColor(matcher);
            }
        }
        return -1;
    }

    private static int getColorPerRarity(class_1799 stack) {
        class_1814 r = stack.method_7932();
        int palette = Palette.LEGENDARY[0];
        if (r == class_1814.field_8906) {
            palette = Palette.COMMON[0];
        }
        if (r == class_1814.field_8907) {
            palette = Palette.UNCOMMON[0];
        }
        if (r == class_1814.field_8903) {
            palette = Palette.RARE[0];
        }
        if (r == class_1814.field_8904) {
            palette = Palette.EPIC[0];
        }
        return palette;
    }

    public static int getExtraTextPosition(TooltipContext ctx, TextType type, TextAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case TextAxis.X -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TITLE: {
                        yield ctx.data().map(CustomFrameData::getTitlePositionX).orElse(TooltipsConfig.TITLE_POSITION_X);
                    }
                    case RATING: {
                        yield ctx.data().map(CustomFrameData::getRatingPositionX).orElse(TooltipsConfig.RATING_POSITION_X);
                    }
                    case DESCRIPTION: 
                }
                yield ctx.data().map(CustomFrameData::getTooltipDescriptionPositionX).orElse(TooltipsConfig.TOOLTIP_DESCRIPTION_POSITION_X);
            }
            case TextAxis.Y -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TITLE: {
                        yield ctx.data().map(CustomFrameData::getTitlePositionY).orElse(TooltipsConfig.TITLE_POSITION_Y);
                    }
                    case RATING: {
                        yield ctx.data().map(CustomFrameData::getRatingPositionY).orElse(TooltipsConfig.RATING_POSITION_Y);
                    }
                    case DESCRIPTION: 
                }
                yield ctx.data().map(CustomFrameData::getTooltipDescriptionPositionY).orElse(TooltipsConfig.TOOLTIP_DESCRIPTION_POSITION_Y);
            }
        };
    }

    public static int getTitleAlignmentX(int posx, int offset, Point size, class_5684 component, class_327 font, TooltipContext ctx) {
        int startX = posx + offset;
        int rightX = posx + size.x - TooltipRenderer.PADDING_X;
        int textWidth = component.method_32664(font);
        int available = rightX - startX;
        int result = switch (ctx.data().map(CustomFrameData::getTitleAlignment).orElse(TooltipsConfig.TITLE_X_ALIGNMENT)) {
            case "middle" -> startX + (available - textWidth) / 2;
            case "right" -> rightX - textWidth;
            default -> startX;
        };
        if (available <= 0) {
            return startX;
        }
        result = Math.max(startX, Math.min(result, rightX - Math.min(textWidth, available)));
        return result;
    }

    public static int getRatingAlignmentX(int posx, int offset, Point size, class_2561 rarity, class_327 font, TooltipContext ctx) {
        int startX = posx + offset;
        int rightX = posx + size.x - TooltipRenderer.PADDING_X;
        int available = Math.max(0, rightX - startX);
        int compWidth = font.method_27525((class_5348)rarity);
        if (available > 0 && compWidth > available) {
            int maxLine = 0;
            for (class_5481 line : font.method_1728((class_5348)rarity, available)) {
                maxLine = Math.max(maxLine, font.method_30880(line));
            }
            compWidth = Math.min(maxLine, available);
        }
        int result = switch (ctx.data().map(CustomFrameData::getRatingAlignment).orElse(TooltipsConfig.RATING_X_ALIGNMENT)) {
            case "middle" -> startX + (available - compWidth) / 2;
            case "right" -> rightX - compWidth;
            default -> startX;
        };
        if (available <= 0) {
            return startX;
        }
        return Math.max(startX, Math.min(result, rightX - compWidth));
    }

    public static class_2561 getDefaultRarity(class_1799 stack) {
        class_1814 r = stack.method_7932();
        String string = r.toString();
        if (r == class_1814.field_8906 || r == class_1814.field_8907 || r == class_1814.field_8903 || r == class_1814.field_8904) {
            return class_2561.method_43471((String)("tooltipoverhaul." + string.trim().toLowerCase() + "_rarity"));
        }
        if (string.contains("alexscaves")) {
            return class_2561.method_43471((String)("rarity.alexscaves." + string.split(":")[1] + ".name"));
        }
        return class_2561.method_43471((String)r.name().trim().toLowerCase());
    }
}

