/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client;

import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipScrollState;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import dev.xylonity.tooltipoverhaul.client.layer.ITooltipLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.ArmorStandLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.BackgroundLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.DividerLineLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.IconBackgroundLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.IconLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.InnerFrameLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.OverlayLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.RotatingItemLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.SecondBackgroundLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.SecondInnerFrameLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.TextLayer;
import dev.xylonity.tooltipoverhaul.client.style.Styles;
import dev.xylonity.tooltipoverhaul.client.style.TooltipStyle;
import dev.xylonity.tooltipoverhaul.compat.apotheosis.ApotheosisHook;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public final class TooltipRenderer {
    public static final int PADDING_X = TooltipsConfig.MAIN_PANEL_PADDING_X;
    public static final int PADDING_Y = TooltipsConfig.MAIN_PANEL_PADDING_Y;
    public static float ELAPSED;
    @Nullable
    private static TooltipStyle style;
    private static ItemStack lastStack;
    private static long startMs;
    private static final List<ITooltipLayer> LAYERS_MAIN;
    private static final List<ITooltipLayer> LAYERS_EMPTY;
    private static final List<ITooltipLayer> LAYERS_SECOND;
    public static int LAST_HEADER_ABS;
    public static int LAST_POS_YI;

    public static boolean render(TooltipContext ctx) {
        Optional<CustomFrameData> customFrame;
        boolean hasIcon;
        if (ApotheosisHook.isActive()) {
            return false;
        }
        List<ClientTooltipComponent> raw = ctx.getComponents();
        if (raw.isEmpty()) {
            return false;
        }
        List<ClientTooltipComponent> components = raw;
        boolean bl = hasIcon = !ctx.stack().isEmpty();
        if (!hasIcon && !TooltipsConfig.SHOW_TOOLTIP_WITHOUT_STACK) {
            return false;
        }
        Optional<CustomFrameData> optional = customFrame = hasIcon ? CustomFrameManager.of(ctx.stack()) : Optional.empty();
        if (customFrame.isPresent() && ((CustomFrameData)customFrame.get()).shouldDisableTooltip()) {
            return false;
        }
        TooltipRenderer.updateStyle(hasIcon ? ctx.stack() : ItemStack.EMPTY, customFrame.orElse(null));
        if (hasIcon && style == null) {
            return false;
        }
        Font font = Minecraft.getInstance().font;
        MutableComponent rating = hasIcon ? TooltipRenderer.computeRating(customFrame, ctx) : Component.empty();
        Point size = TooltipRenderer.calculateSize(font, components, (Component)rating, hasIcon, ctx);
        int margin = 4;
        int xRight = ctx.mouseX() + 12;
        int xLeft = ctx.mouseX() - 16 - size.x;
        int x = xRight + size.x <= ctx.width() - margin ? xRight : (xLeft >= margin ? xLeft : Math.max(margin, ctx.width() - size.x - margin));
        int height = Math.min(size.y, ctx.height() - 8);
        Vec2 pos = new Vec2((float)x, (float)Math.max(margin, Math.min(ctx.mouseY() - 12, ctx.height() - height - margin)));
        LAST_POS_YI = Math.round(pos.y);
        if (size.y > height) {
            int content = 0;
            for (int i = 1; i < components.size(); ++i) {
                content += components.get(i).getHeight();
            }
            if (Util.isScrollingDisabled(ctx)) {
                TooltipScrollState.reset();
            } else {
                TooltipScrollState.begin(content, Math.max(0, height - LAST_HEADER_ABS - (PADDING_Y + 3) - 7));
                TooltipScrollState.tick();
            }
        } else {
            TooltipScrollState.reset();
        }
        Point ttSize = new Point(size.x, height);
        if (!hasIcon) {
            for (ITooltipLayer layer : LAYERS_EMPTY) {
                layer.render(ctx, pos, ttSize, Styles.COMMON.build(), (Component)rating, font, null);
            }
            ctx.flush();
            TooltipScrollState.resetIfInactive();
            return true;
        }
        for (ITooltipLayer layer : LAYERS_MAIN) {
            layer.render(ctx, pos, ttSize, style, (Component)rating, font, customFrame.orElse(null));
        }
        if (ctx.data().isPresent() && ctx.data().get().shouldShowSecondPanel() || ctx.stack().getItem() instanceof TieredItem && TooltipsConfig.TIERED_ITEMS_RENDERER || ctx.stack().getItem() instanceof ArmorItem && TooltipsConfig.ARMOR_ITEMS_RENDERER) {
            for (ITooltipLayer layer : LAYERS_SECOND) {
                layer.render(ctx, pos, ttSize, style, (Component)rating, font, customFrame.orElse(null));
            }
        }
        ctx.flush();
        TooltipScrollState.resetIfInactive();
        return true;
    }

    private static Component computeRating(Optional<CustomFrameData> customFrame, TooltipContext ctx) {
        CustomFrameData data;
        Rarity r = ctx.stack().getRarity();
        ChatFormatting color = ChatFormatting.GOLD;
        if (r == Rarity.COMMON) {
            color = ChatFormatting.GRAY;
        }
        if (r == Rarity.UNCOMMON) {
            color = ChatFormatting.YELLOW;
        }
        if (r == Rarity.RARE) {
            color = ChatFormatting.BLUE;
        }
        if (r == Rarity.EPIC) {
            color = ChatFormatting.DARK_PURPLE;
        }
        if (customFrame.isPresent() && (data = customFrame.get()).hasCustomItemRating()) {
            MutableComponent base;
            String raw = String.valueOf(data.getItemRating(ctx.stack()));
            MutableComponent mutableComponent = base = raw.startsWith("key.tooltipoverhaul") ? Component.translatable((String)raw) : Component.literal((String)raw);
            if (data.hasCustomColorItemRating()) {
                return base.withStyle(Style.EMPTY.withColor(data.getItemRatingColor(ctx.stack())));
            }
            return base.withStyle(color);
        }
        return Util.getDefaultRarity(ctx.stack()).copy().withStyle(color);
    }

    private static Point calculateSize(Font font, List<ClientTooltipComponent> components, Component rarity, boolean hasIcon, TooltipContext ctx) {
        int headBlock;
        int headAbs;
        int y0;
        int iconOffset = hasIcon ? 26 : 0;
        int width = PADDING_X * 2 + iconOffset + components.get(0).getWidth(font);
        for (ClientTooltipComponent c : components) {
            width = Math.max(width, PADDING_X * 2 + c.getWidth(font));
        }
        if (hasIcon) {
            width = Math.max(width, PADDING_X * 2 + iconOffset + (Util.shouldShowRating(ctx.stack()) ? font.width((FormattedText)rarity) : 0));
        }
        int y = y0 = PADDING_Y + 3;
        for (int i = 0; i < components.size(); ++i) {
            if (hasIcon && i == 1) {
                y += 12;
            }
            y += components.get(i).getHeight();
            if (!hasIcon || i != 0 || components.size() <= 1) continue;
            y += 6;
        }
        int topPadding = PADDING_Y + 3;
        int yAfterTitle = topPadding + components.get(0).getHeight();
        if (hasIcon && components.size() > 1) {
            yAfterTitle += 6;
        }
        int n = components.size() > 1 ? yAfterTitle + 3 + (hasIcon ? 12 : 0) : (headAbs = yAfterTitle);
        if (hasIcon && (headBlock = headAbs - topPadding) < 26) {
            headAbs = topPadding + 26;
        }
        LAST_HEADER_ABS = headAbs;
        int height = PADDING_Y + (y - y0) + PADDING_Y + 3;
        int minHeight = topPadding + 18 + (PADDING_Y + 3);
        if (hasIcon && height < minHeight) {
            height = minHeight;
        }
        return new Point(width, height);
    }

    private static void updateStyle(ItemStack stack, @Nullable CustomFrameData data) {
        if (!(stack.isEmpty() && lastStack.isEmpty() || !stack.isEmpty() && !lastStack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)lastStack))) {
            style = Styles.of(stack, data).orElse(null);
            lastStack = stack.copy();
            startMs = System.currentTimeMillis();
            TooltipScrollState.reset();
        }
        ELAPSED = (float)(System.currentTimeMillis() - startMs) / 1000.0f;
    }

    static {
        lastStack = ItemStack.EMPTY;
        LAYERS_MAIN = new ArrayList<ITooltipLayer>();
        LAYERS_EMPTY = new ArrayList<ITooltipLayer>();
        LAYERS_SECOND = new ArrayList<ITooltipLayer>();
        LAYERS_MAIN.add(new BackgroundLayer());
        LAYERS_MAIN.add(new IconBackgroundLayer());
        LAYERS_MAIN.add(new IconLayer());
        LAYERS_MAIN.add(new TextLayer());
        LAYERS_MAIN.add(new DividerLineLayer());
        LAYERS_MAIN.add(new InnerFrameLayer());
        LAYERS_MAIN.add(new EffectLayer());
        LAYERS_MAIN.add(new OverlayLayer());
        LAYERS_SECOND.add(new SecondBackgroundLayer());
        LAYERS_SECOND.add(new SecondInnerFrameLayer());
        LAYERS_SECOND.add(new ArmorStandLayer());
        LAYERS_SECOND.add(new RotatingItemLayer());
        LAYERS_EMPTY.add(new BackgroundLayer());
        LAYERS_EMPTY.add(new TextLayer());
        LAYERS_EMPTY.add(new InnerFrameLayer());
    }
}

