/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client;

public final class TooltipScrollState {
    private static final float SPEED_CAP = 800.0f;
    private static int maxScroll;
    private static int scroll;
    private static boolean isActive;
    private static float accumulated;
    private static float velocity;
    private static long lastNs;

    public static void begin(int contentHeight, int viewportHeight) {
        int overflow = Math.max(0, contentHeight - Math.max(0, viewportHeight));
        if (overflow > 0) {
            overflow = Math.max(0, overflow - 1);
        }
        if (scroll > (maxScroll = overflow)) {
            scroll = maxScroll;
        }
        boolean bl = isActive = overflow > 0;
        if (!isActive) {
            accumulated = 0.0f;
            velocity = 0.0f;
            lastNs = 0L;
        }
    }

    public static void reset() {
        maxScroll = 0;
        scroll = 0;
        isActive = false;
        accumulated = 0.0f;
        velocity = 0.0f;
        lastNs = 0L;
    }

    public static void resetIfInactive() {
        if (!isActive) {
            maxScroll = 0;
            scroll = 0;
            accumulated = 0.0f;
            velocity = 0.0f;
            lastNs = 0L;
        }
    }

    public static boolean shouldCaptureScroll() {
        if (!isActive) {
            return false;
        }
        return lastNs != 0L && System.nanoTime() - lastNs <= 150000000L;
    }

    public static boolean isIsActive() {
        return isActive;
    }

    public static int getScroll() {
        return scroll;
    }

    public static void addScroll(int delta) {
        if (!isActive) {
            return;
        }
        int scrolls = scroll + delta;
        if (scrolls < 0) {
            scrolls = 0;
        }
        if (scrolls > maxScroll) {
            scrolls = maxScroll;
        }
        scroll = scrolls;
    }

    public static void onRawScroll(double dy) {
        if (!isActive) {
            return;
        }
        float delta = (float)(-dy) * 2.0f;
        int step = (int)(accumulated += delta);
        if (step != 0) {
            TooltipScrollState.addScroll(step);
            accumulated -= (float)step;
        }
        if ((velocity += (float)(-dy) * 220.0f) > 800.0f) {
            velocity = 800.0f;
        }
        if (velocity < -800.0f) {
            velocity = -800.0f;
        }
        if (scroll == 0 && velocity < 0.0f) {
            velocity = 0.0f;
        }
        if (scroll == maxScroll && velocity > 0.0f) {
            velocity = 0.0f;
        }
    }

    public static void tick() {
        long now = System.nanoTime();
        if (lastNs == 0L) {
            lastNs = now;
            return;
        }
        float dt = (float)(now - lastNs) / 1.0E9f;
        lastNs = now;
        if (!isActive) {
            velocity = 0.0f;
            return;
        }
        if (Math.abs(velocity) > 1.0f) {
            int delta = Math.round(velocity * dt);
            if (delta != 0) {
                TooltipScrollState.addScroll(delta);
            }
            float dec = 9.0f * dt;
            velocity -= velocity * dec;
            if (scroll == 0 && velocity < 0.0f) {
                velocity = 0.0f;
            }
            if (scroll == maxScroll && velocity > 0.0f) {
                velocity = 0.0f;
            }
        } else {
            velocity = 0.0f;
        }
    }
}

