/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.divider;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipDividerLine;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class DefaultDividerLine
implements ITooltipDividerLine {
    private static final int MIN_SEGMENTS = 2;
    private static final int MAX_SEGMENTS = 24;

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        if (ctx.getComponents().size() <= 1 || size.x <= 4) {
            return;
        }
        int y = (int)pos.y + 4 + TooltipRenderer.PADDING_Y + ((ClientTooltipComponent)ctx.getComponents().get(0)).getHeight() + 4 + 10;
        int x = (int)((float)((int)pos.x) + (float)size.x * 0.1f);
        int width = (int)((float)size.x - (float)size.x * 0.2f);
        if (width <= 1) {
            return;
        }
        int segments = DefaultDividerLine.clamp(width / 12);
        ctx.push(() -> {
            int run;
            ctx.translate(0.0f, 0.0f, depth.getZ());
            PoseStack pose = ctx.graphics().pose();
            Matrix4f matrix = pose.last().pose();
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buf = tesselator.getBuilder();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            buf.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            int segmentLength = Math.max(1, width / segments);
            int px = x;
            float center = (float)width / 2.0f;
            for (int drawn = 0; drawn < width; drawn += run) {
                run = Math.min(segmentLength, width - drawn);
                int leftAlpha = DefaultDividerLine.alphaFromDistance(Math.abs((float)drawn - center) / center, 0.025f);
                int rightAlpha = DefaultDividerLine.alphaFromDistance(Math.abs((float)(drawn + run - 1) - center) / center, 0.025f);
                int lineColor = Util.getDividerLineColor(ctx);
                int leftColor = leftAlpha << 24 | lineColor & 0xFFFFFF;
                int rightColor = rightAlpha << 24 | lineColor & 0xFFFFFF;
                int alphaLeft = leftColor >>> 24 & 0xFF;
                int redLeft = leftColor >>> 16 & 0xFF;
                int greenLeft = leftColor >>> 8 & 0xFF;
                int blueLeft = leftColor & 0xFF;
                int alphaRight = rightColor >>> 24 & 0xFF;
                int redRight = rightColor >>> 16 & 0xFF;
                int greenRight = rightColor >>> 8 & 0xFF;
                int blueRight = rightColor & 0xFF;
                buf.vertex(matrix, (float)px, (float)(y + 1), 0.0f).color(redLeft, greenLeft, blueLeft, alphaLeft).endVertex();
                buf.vertex(matrix, (float)(px + run), (float)(y + 1), 0.0f).color(redRight, greenRight, blueRight, alphaRight).endVertex();
                buf.vertex(matrix, (float)(px + run), (float)y, 0.0f).color(redRight, greenRight, blueRight, alphaRight).endVertex();
                buf.vertex(matrix, (float)px, (float)y, 0.0f).color(redLeft, greenLeft, blueLeft, alphaLeft).endVertex();
                px += run;
            }
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)buf.end());
        });
    }

    private static int alphaFromDistance(float distanceNorm, float fade) {
        if (distanceNorm <= fade) {
            return 255;
        }
        float z = (distanceNorm - fade) / (1.0f - fade);
        return Math.max(0, Math.min(255, (int)(255.0f * (1.0f - z * z))));
    }

    private static int clamp(int value) {
        return Math.max(2, Math.min(24, value));
    }
}

