/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class RimLightEffect
implements ITooltipEffect {
    private final int color1;
    private final int color2;

    public RimLightEffect(int color1, int color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    @Override
    public void render(LayerDepth depth, TooltipContext context, Vec2 pos, Point size) {
        Point size2 = new Point(size.x + 8, size.y + 8);
        Vec2 start = pos.add(-4.0f);
        float time = context.time();
        float width = 8.0f + 3.0f * (float)Math.cos(time * 1.1f);
        Matrix4f matrix = context.pose().last().pose();
        VertexConsumer buf = context.buffer().getBuffer(RenderType.guiOverlay());
        RimLightEffect.draw(matrix, buf, start, size2, width, this.color1, this.color2);
        RimLightEffect.draw(matrix, buf, start.add(-1.0f), new Point(size2.x + 2, size2.y + 2), width * 1.6f, RimLightEffect.mulAlpha(this.color1, 0.35f), this.color2);
        for (int edge = 0; edge < 4; ++edge) {
            float k = (float)Math.max(0.0, Math.sin((double)(time * 3.2f) + (double)edge * 1.57));
            if (k < 0.05f) continue;
            RimLightEffect.drawEdge(matrix, buf, start, size2, width * 0.6f, RimLightEffect.mulAlpha(this.color1, 0.5f + 0.35f * k), this.color2, edge);
        }
    }

    private static int mulAlpha(int color, float scale) {
        int alpha = color >>> 24 & 0xFF;
        return color & 0xFFFFFF | Math.max(0, Math.min(255, Math.round((float)alpha * scale))) << 24;
    }

    private static void draw(Matrix4f m, VertexConsumer buf, Vec2 start, Point size, float w, int color1, int color2) {
        buf.vertex(m, start.x, start.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x + w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
        buf.vertex(m, start.x + w, start.y + w, 0.0f).color(color2).endVertex();
        buf.vertex(m, start.x, start.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x + w, start.y + w, 0.0f).color(color2).endVertex();
        buf.vertex(m, start.x + (float)size.x - w, start.y + w, 0.0f).color(color2).endVertex();
        buf.vertex(m, start.x + (float)size.x, start.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x + (float)size.x - w, start.y + w, 0.0f).color(color2).endVertex();
        buf.vertex(m, start.x + (float)size.x - w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
        buf.vertex(m, start.x + (float)size.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x + (float)size.x, start.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x + w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
        buf.vertex(m, start.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x + (float)size.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
        buf.vertex(m, start.x + (float)size.x - w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
    }

    private static void drawEdge(Matrix4f m, VertexConsumer buf, Vec2 start, Point size, float w, int color1, int color2, int edge) {
        switch (edge) {
            case 0: {
                buf.vertex(m, start.x, start.y, 0.0f).color(color1).endVertex();
                buf.vertex(m, start.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
                buf.vertex(m, start.x + w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
                buf.vertex(m, start.x + w, start.y + w, 0.0f).color(color2).endVertex();
                break;
            }
            case 1: {
                buf.vertex(m, start.x, start.y, 0.0f).color(color1).endVertex();
                buf.vertex(m, start.x + w, start.y + w, 0.0f).color(color2).endVertex();
                buf.vertex(m, start.x + (float)size.x - w, start.y + w, 0.0f).color(color2).endVertex();
                buf.vertex(m, start.x + (float)size.x, start.y, 0.0f).color(color1).endVertex();
                break;
            }
            case 2: {
                buf.vertex(m, start.x + (float)size.x - w, start.y + w, 0.0f).color(color2).endVertex();
                buf.vertex(m, start.x + (float)size.x - w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
                buf.vertex(m, start.x + (float)size.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
                buf.vertex(m, start.x + (float)size.x, start.y, 0.0f).color(color1).endVertex();
                break;
            }
            case 3: {
                buf.vertex(m, start.x + w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
                buf.vertex(m, start.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
                buf.vertex(m, start.x + (float)size.x, start.y + (float)size.y, 0.0f).color(color1).endVertex();
                buf.vertex(m, start.x + (float)size.x - w, start.y + (float)size.y - w, 0.0f).color(color2).endVertex();
            }
        }
    }
}

