/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipArmorStand;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class DefaultArmorStand
implements ITooltipArmorStand {
    @Nullable
    public static ArmorStand stand;
    private static float SCALE;

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        DefaultArmorStand.equipArmor(ctx.stack());
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (stand == null) {
            stand = new ArmorStand(EntityType.ARMOR_STAND, (Level)Minecraft.getInstance().level);
            stand.setInvisible(false);
            stand.setNoBasePlate(true);
            stand.setShowArms(true);
            stand.setNoBasePlate(false);
        }
        if (ctx.data().isPresent()) {
            SCALE = ctx.data().get().getSecondPanelRendererSize();
        }
        float speed = 8000.0f / TooltipsConfig.SECOND_PANEL_RENDERER_SPEED;
        if (ctx.data().isPresent()) {
            speed = 8000.0f / ctx.data().get().getSecondPanelRendererSpeed();
        }
        float finalSpeed = speed;
        float scale = (float)(30.0 * ((double)SCALE / 2.75));
        ctx.push(() -> {
            ctx.translate(pos.x, pos.y, depth.getZ());
            ctx.scale(-scale, -scale, scale);
            ctx.multiply(Axis.XP, 30.0f);
            ctx.multiply(Axis.YP, -45.0f);
            ctx.multiply(Axis.YP, Util.calcRotY(finalSpeed));
            Lighting.setupForEntityInInventory();
            EntityRenderDispatcher renderer = Minecraft.getInstance().getEntityRenderDispatcher();
            renderer.setRenderShadow(false);
            renderer.render((Entity)stand, 0.0, 0.0, 0.0, 0.0f, 1.0f, ctx.pose(), ctx.buffer(), 0xF000F0);
            renderer.setRenderShadow(true);
        });
    }

    private static void equipArmor(ItemStack stack) {
        EquipmentSlot[] equipmentSlotArray = stack.getItem();
        if (!(equipmentSlotArray instanceof ArmorItem)) {
            return;
        }
        ArmorItem ar = (ArmorItem)equipmentSlotArray;
        if (stand == null) {
            return;
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            stand.setItemSlot(s, ItemStack.EMPTY);
        }
        stand.setItemSlot(ar.getEquipmentSlot(), stack.copy());
    }

    static {
        SCALE = TooltipsConfig.SECOND_PANEL_RENDERER_SIZE;
    }
}

