/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.renderer;

import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipIcon;
import dev.xylonity.tooltipoverhaul.compat.modernfix.ModernFixCompat;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import net.minecraft.world.phys.Vec2;

public class DefaultIcon
implements ITooltipIcon {
    private static final float ANIMATION_DURATION = 0.6f;
    private static float SCALE = TooltipsConfig.ICON_SIZE;

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.renderDefault(depth, ctx, pos, size);
    }

    private void renderDefault(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        if (ctx.data().isPresent()) {
            SCALE = ctx.data().get().getIconSize();
        }
        ctx.push(() -> {
            ctx.translate(0.0f, 0.0f, depth.getZ());
            ctx.translate(pos.x + (float)TooltipRenderer.PADDING_X + 4.0f + 8.0f, pos.y + (float)TooltipRenderer.PADDING_Y + 4.0f + 8.0f, 0.0f);
            ctx.translate(0.0f, 0.0f, 150.0f);
            float progress = Math.min(TooltipRenderer.ELAPSED / 0.6f, 1.0f);
            String animationName = Util.getIconAppearAnimation(ctx);
            if (animationName.equals("rotate") || animationName.equals("rotate_zoom")) {
                ctx.multiply(Axis.YP, 180.0f);
            }
            if (TooltipRenderer.ELAPSED < 0.6f) {
                switch (animationName) {
                    case "zoom": {
                        DefaultIcon.scale(ctx, progress);
                        break;
                    }
                    case "rotate": {
                        ctx.scale(SCALE, SCALE, SCALE);
                        DefaultIcon.rotate(ctx, 1);
                        break;
                    }
                    case "rotate_fast": {
                        ctx.scale(SCALE, SCALE, SCALE);
                        DefaultIcon.rotate(ctx, 2);
                        break;
                    }
                    case "rotate_zoom": {
                        DefaultIcon.scale(ctx, progress);
                        DefaultIcon.rotate(ctx, 1);
                        break;
                    }
                    case "zoom_snap": {
                        float abs = progress < 0.72f ? 1.1f + 0.7f * DefaultIcon.easeOutCubic(progress / 0.72f) : 1.8f - 0.3f * DefaultIcon.smoothstep(0.0f, 1.0f, (progress - 0.72f) / 0.28f);
                        float scale = DefaultIcon.scaled(abs);
                        ctx.multiply(Axis.YP, 4.0f * (1.0f - progress));
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "skew": {
                        float tilt = 18.0f * (1.0f - progress);
                        ctx.multiply(Axis.XP, tilt);
                        ctx.multiply(Axis.YP, -tilt * 0.6f);
                        float undershoot = 0.12f * (1.0f - progress);
                        float overshoot = 0.2f * (float)Math.sin(Math.PI * (double)progress);
                        float scale = SCALE * (1.0f - undershoot + overshoot);
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "vibration": {
                        float decay = 1.0f - progress;
                        ctx.translate(1.2f * decay * (float)Math.sin(progress * 30.0f), 1.0f * decay * (float)Math.cos(progress * 27.0f), 0.0f);
                        float abs = 1.4f + 0.1f * (1.0f - progress);
                        float scale = DefaultIcon.scaled(abs);
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "tilt_wave": {
                        float amp = 16.0f * (1.0f - progress);
                        float waves = (float)Math.sin((double)progress * Math.PI * 6.0);
                        ctx.multiply(Axis.ZP, amp * waves);
                        ctx.multiply(Axis.XP, 0.6f * amp * waves);
                        ctx.scale(SCALE, SCALE, SCALE);
                        break;
                    }
                    case "flip": {
                        ctx.multiply(Axis.XP, (1.0f - (float)(1.0 - Math.pow(1.0 - (double)progress, 2.2))) * 90.0f);
                        float undershoot = 0.12f * (1.0f - progress);
                        float overshoot = 0.22f * (float)Math.sin(Math.PI * (double)progress);
                        float scale = SCALE * (1.0f - undershoot + overshoot);
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "pendulum": {
                        ctx.translate(0.0f, -8.0f, 0.0f);
                        ctx.multiply(Axis.ZP, 28.0f * (float)Math.cos((double)progress * Math.PI * 3.0) * (1.0f - progress));
                        ctx.translate(0.0f, 8.0f, 0.0f);
                        ctx.scale(SCALE, SCALE, SCALE);
                        break;
                    }
                    case "bounce": {
                        ctx.translate(0.0f, DefaultIcon.dampBounce(progress, 3.0f, 8.0f), 0.0f);
                        float abs = 1.45f + 0.05f * (float)Math.sin((double)progress * Math.PI);
                        float scale = DefaultIcon.scaled(abs);
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "go_down": {
                        ctx.translate(0.0f, -20.0f * (1.0f - DefaultIcon.easeOutCubic(progress)), 0.0f);
                        ctx.multiply(Axis.ZP, (1.0f - progress) * -12.0f);
                        float scale = SCALE - 0.08f * (1.0f - progress);
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "pulse": {
                        float pulses = (float)Math.sin((double)progress * Math.PI * 4.0);
                        float abs = 1.5f + 0.25f * (1.0f - progress) * pulses;
                        float scale = DefaultIcon.scaled(abs);
                        ctx.multiply(Axis.XP, 5.0f * pulses * (1.0f - progress));
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "fan_in": {
                        ctx.multiply(Axis.YP, 32.0f * (float)Math.sin((double)progress * Math.PI * 5.0) * (1.0f - progress));
                        float undershoot = 0.12f * (1.0f - progress);
                        float overshoot = 0.18f * (float)Math.sin(Math.PI * (double)progress);
                        float scale = SCALE * (1.0f - undershoot + overshoot);
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "hover_pop": {
                        ctx.translate(0.0f, -(6.0f * (1.0f - DefaultIcon.easeOutCubic(progress))), 0.0f);
                        float scale = 1.35f + 0.2f * DefaultIcon.smoothstep(0.6f, 1.0f, progress);
                        ctx.multiply(Axis.XP, 6.0f * (1.0f - progress));
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    case "barrel_roll": {
                        ctx.multiply(Axis.ZP, 360.0f * DefaultIcon.easeOutCubic(progress));
                        float abs = 0.9f + 0.6f * DefaultIcon.easeOutCubic(progress);
                        float scale = DefaultIcon.scaled(abs);
                        ctx.scale(scale, scale, scale);
                        break;
                    }
                    default: {
                        ctx.scale(SCALE, SCALE, SCALE);
                        break;
                    }
                }
            } else {
                ctx.scale(SCALE, SCALE, SCALE);
                float elapsed = TooltipRenderer.ELAPSED - 0.6f;
                ctx.multiply(Axis.YP, (float)((double)DefaultIcon.computeFinalDegrees(animationName, 0.6f) + (double)elapsed * (360.0 / (6.0 / (double)Util.getIconRotatingSpeed(ctx))) % 360.0));
            }
            ctx.translate(-8.0f, -8.0f, -150.0f);
            if (ModernFixCompat.SHOULD_RETURN_ORIGINAL_RENDER) {
                ModernFixCompat.push();
                try {
                    ctx.graphics().renderItem(ctx.stack(), 0, 0);
                }
                finally {
                    ModernFixCompat.pop();
                }
            } else {
                ctx.graphics().renderItem(ctx.stack(), 0, 0);
            }
        });
    }

    private static float computeFinalDegrees(String anim, float duration) {
        int factor = switch (anim) {
            case "rotate_fast" -> 10;
            case "rotate", "rotate_zoom" -> 5;
            default -> 0;
        };
        return duration * (float)factor * 60.0f % 360.0f;
    }

    private static float smoothstep(float a, float b, float x) {
        float step = DefaultIcon.clamp((x - a) / (b - a), 0.0f, 1.0f);
        return step * step * (3.0f - 2.0f * step);
    }

    private static float clamp(float v, float lo, float hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static float easeOutCubic(float time) {
        float ease = 1.0f - time;
        return 1.0f - ease * ease * ease;
    }

    private static float dampBounce(float time, float decay, float height) {
        return (float)(Math.exp(-decay * time) * Math.sin((float)Math.PI * 3 * time)) * height;
    }

    private static void scale(TooltipContext ctx, float progress) {
        float scale = DefaultIcon.easeOutQuint(progress);
        ctx.scale(scale * SCALE, scale * SCALE, scale * SCALE);
    }

    private static void rotate(TooltipContext ctx, int times) {
        ctx.multiply(Axis.YP, (float)((double)(TooltipRenderer.ELAPSED * (float)(5 * times) * 360.0f) / 6.0 % 360.0));
    }

    private static float easeOutQuint(float t) {
        float cubicPart = 1.0f - (float)Math.pow(1.0f - t, 3.0);
        return cubicPart * t + t * (1.0f - t);
    }

    private static float scaled(float value) {
        return SCALE * (value / 1.5f);
    }
}

