/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.wrap;

import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.mixin.ClientTextTooltipAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public final class TooltipWrapper {
    public static List<ClientTooltipComponent> wrap(Font font, List<ClientTooltipComponent> orig, int screenWidth, ItemStack stack) {
        if (orig == null || orig.isEmpty()) {
            return orig;
        }
        boolean hasIcon = !stack.isEmpty();
        int basePadding = TooltipRenderer.PADDING_X * 2 + 4;
        int iconPadding = hasIcon ? 26 : 0;
        int maxAllowed = Math.max(60, (int)((float)screenWidth * 0.75f) - basePadding - iconPadding);
        boolean shouldWrap = false;
        for (ClientTooltipComponent c : orig) {
            if (!(c instanceof ClientTextTooltip) || c.getWidth(font) <= maxAllowed) continue;
            shouldWrap = true;
            break;
        }
        if (!shouldWrap) {
            return orig;
        }
        ArrayList<ClientTooltipComponent> text = new ArrayList<ClientTooltipComponent>(orig.size() + 8);
        for (ClientTooltipComponent component : orig) {
            if (!(component instanceof ClientTextTooltip)) {
                text.add(component);
                continue;
            }
            if (component.getWidth(font) <= maxAllowed) {
                text.add(component);
                continue;
            }
            FormattedCharSequence sequence = TooltipWrapper.getSequence(component);
            if (sequence == null) {
                text.add(component);
                continue;
            }
            for (FormattedText part : font.getSplitter().splitLines(TooltipWrapper.toFormattedText(sequence), maxAllowed, Style.EMPTY)) {
                text.add((ClientTooltipComponent)new ClientTextTooltip(Language.getInstance().getVisualOrder(part)));
            }
        }
        return text;
    }

    private static FormattedCharSequence getSequence(ClientTooltipComponent c) {
        if (c instanceof ClientTextTooltip) {
            ClientTextTooltip t = (ClientTextTooltip)c;
            return ((ClientTextTooltipAccessor)t).getText();
        }
        return null;
    }

    private static FormattedText toFormattedText(FormattedCharSequence sequence) {
        final ArrayList<String> chunks = new ArrayList<String>();
        final ArrayList<Style> styles = new ArrayList<Style>();
        StringBuilder string = new StringBuilder();
        Style[] current = new Style[]{Style.EMPTY};
        sequence.accept((pos, style, cp) -> {
            if (!style.equals((Object)current[0])) {
                if (!string.isEmpty()) {
                    chunks.add(string.toString());
                    styles.add(current[0]);
                    string.setLength(0);
                }
                current[0] = style;
            }
            string.appendCodePoint(cp);
            return true;
        });
        if (!string.isEmpty()) {
            chunks.add(string.toString());
            styles.add(current[0]);
        }
        return new FormattedText(){

            public <T> Optional<T> visit(FormattedText.ContentConsumer<T> consumer) {
                for (String part : chunks) {
                    consumer.accept(part);
                }
                return Optional.empty();
            }

            public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> consumer, Style base) {
                for (int i = 0; i < chunks.size(); ++i) {
                    consumer.accept(((Style)styles.get(i)).applyTo(base), (String)chunks.get(i));
                }
                return Optional.empty();
            }
        };
    }
}

