/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client;

import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipScrollState;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import dev.xylonity.tooltipoverhaul.client.layer.ITooltipLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.ArmorStandLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.BackgroundLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.DividerLineLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.IconBackgroundLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.IconLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.InnerFrameLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.OverlayLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.RotatingItemLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.SecondBackgroundLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.SecondInnerFrameLayer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.TextLayer;
import dev.xylonity.tooltipoverhaul.client.style.Styles;
import dev.xylonity.tooltipoverhaul.client.style.TooltipStyle;
import dev.xylonity.tooltipoverhaul.compat.apotheosis.ApotheosisHook;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1831;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public final class TooltipRenderer {
    public static final int PADDING_X = TooltipsConfig.MAIN_PANEL_PADDING_X;
    public static final int PADDING_Y = TooltipsConfig.MAIN_PANEL_PADDING_Y;
    public static float ELAPSED;
    @Nullable
    private static TooltipStyle style;
    private static class_1799 lastStack;
    private static long startMs;
    private static final List<ITooltipLayer> LAYERS_MAIN;
    private static final List<ITooltipLayer> LAYERS_EMPTY;
    private static final List<ITooltipLayer> LAYERS_SECOND;
    public static int LAST_HEADER_ABS;
    public static int LAST_POS_YI;

    public static boolean render(TooltipContext ctx) {
        Optional<CustomFrameData> customFrame;
        boolean hasIcon;
        if (ApotheosisHook.isActive()) {
            return false;
        }
        List<class_5684> raw = ctx.getComponents();
        if (raw.isEmpty()) {
            return false;
        }
        List<class_5684> components = raw;
        boolean bl = hasIcon = !ctx.stack().method_7960();
        if (!hasIcon && !TooltipsConfig.SHOW_TOOLTIP_WITHOUT_STACK) {
            return false;
        }
        Optional<CustomFrameData> optional = customFrame = hasIcon ? CustomFrameManager.of(ctx.stack()) : Optional.empty();
        if (customFrame.isPresent() && ((CustomFrameData)customFrame.get()).shouldDisableTooltip()) {
            return false;
        }
        TooltipRenderer.updateStyle(hasIcon ? ctx.stack() : class_1799.field_8037, customFrame.orElse(null));
        if (hasIcon && style == null) {
            return false;
        }
        class_327 font = class_310.method_1551().field_1772;
        class_5250 rating = hasIcon ? TooltipRenderer.computeRating(customFrame, ctx) : class_2561.method_43473();
        Point size = TooltipRenderer.calculateSize(font, components, (class_2561)rating, hasIcon, ctx);
        int margin = 4;
        int xRight = ctx.mouseX() + 12;
        int xLeft = ctx.mouseX() - 16 - size.x;
        int x = xRight + size.x <= ctx.width() - margin ? xRight : (xLeft >= margin ? xLeft : Math.max(margin, ctx.width() - size.x - margin));
        int height = Math.min(size.y, ctx.height() - 8);
        class_241 pos = new class_241((float)x, (float)Math.max(margin, Math.min(ctx.mouseY() - 12, ctx.height() - height - margin)));
        LAST_POS_YI = Math.round(pos.field_1342);
        if (size.y > height) {
            int content = 0;
            for (int i = 1; i < components.size(); ++i) {
                content += components.get(i).method_32661();
            }
            if (Util.isScrollingDisabled(ctx)) {
                TooltipScrollState.reset();
            } else {
                TooltipScrollState.begin(content, Math.max(0, height - LAST_HEADER_ABS - (PADDING_Y + 3) - 7));
                TooltipScrollState.tick();
            }
        } else {
            TooltipScrollState.reset();
        }
        Point ttSize = new Point(size.x, height);
        if (!hasIcon) {
            for (ITooltipLayer layer : LAYERS_EMPTY) {
                layer.render(ctx, pos, ttSize, Styles.COMMON.build(), (class_2561)rating, font, null);
            }
            ctx.flush();
            TooltipScrollState.resetIfInactive();
            return true;
        }
        for (ITooltipLayer layer : LAYERS_MAIN) {
            layer.render(ctx, pos, ttSize, style, (class_2561)rating, font, customFrame.orElse(null));
        }
        if (ctx.data().isPresent() && ctx.data().get().shouldShowSecondPanel() || ctx.stack().method_7909() instanceof class_1831 && TooltipsConfig.TIERED_ITEMS_RENDERER || ctx.stack().method_7909() instanceof class_1738 && TooltipsConfig.ARMOR_ITEMS_RENDERER) {
            for (ITooltipLayer layer : LAYERS_SECOND) {
                layer.render(ctx, pos, ttSize, style, (class_2561)rating, font, customFrame.orElse(null));
            }
        }
        ctx.flush();
        TooltipScrollState.resetIfInactive();
        return true;
    }

    private static class_2561 computeRating(Optional<CustomFrameData> customFrame, TooltipContext ctx) {
        CustomFrameData data;
        class_1814 r = ctx.stack().method_7932();
        class_124 color = class_124.field_1065;
        if (r == class_1814.field_8906) {
            color = class_124.field_1080;
        }
        if (r == class_1814.field_8907) {
            color = class_124.field_1054;
        }
        if (r == class_1814.field_8903) {
            color = class_124.field_1078;
        }
        if (r == class_1814.field_8904) {
            color = class_124.field_1064;
        }
        if (customFrame.isPresent() && (data = customFrame.get()).hasCustomItemRating()) {
            class_5250 base;
            String raw = String.valueOf(data.getItemRating(ctx.stack()));
            class_5250 class_52502 = base = raw.startsWith("key.tooltipoverhaul") ? class_2561.method_43471((String)raw) : class_2561.method_43470((String)raw);
            if (data.hasCustomColorItemRating()) {
                return base.method_27696(class_2583.field_24360.method_36139(data.getItemRatingColor(ctx.stack())));
            }
            return base.method_27692(color);
        }
        String s = Util.getDefaultRarity(ctx.stack());
        return class_2561.method_43470((String)(s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase())).method_27692(color);
    }

    private static Point calculateSize(class_327 font, List<class_5684> components, class_2561 rarity, boolean hasIcon, TooltipContext ctx) {
        int headBlock;
        int headAbs;
        int y0;
        int iconOffset = hasIcon ? 26 : 0;
        int width = PADDING_X * 2 + iconOffset + components.get(0).method_32664(font);
        for (class_5684 c : components) {
            width = Math.max(width, PADDING_X * 2 + c.method_32664(font));
        }
        if (hasIcon) {
            width = Math.max(width, PADDING_X * 2 + iconOffset + (Util.shouldShowRating(ctx.stack()) ? font.method_27525((class_5348)rarity) : 0));
        }
        int y = y0 = PADDING_Y + 3;
        for (int i = 0; i < components.size(); ++i) {
            if (hasIcon && i == 1) {
                y += 12;
            }
            y += components.get(i).method_32661();
            if (!hasIcon || i != 0 || components.size() <= 1) continue;
            y += 6;
        }
        int topPadding = PADDING_Y + 3;
        int yAfterTitle = topPadding + components.get(0).method_32661();
        if (hasIcon && components.size() > 1) {
            yAfterTitle += 6;
        }
        int n = components.size() > 1 ? yAfterTitle + 3 + (hasIcon ? 12 : 0) : (headAbs = yAfterTitle);
        if (hasIcon && (headBlock = headAbs - topPadding) < 26) {
            headAbs = topPadding + 26;
        }
        LAST_HEADER_ABS = headAbs;
        int height = PADDING_Y + (y - y0) + PADDING_Y + 3;
        int minHeight = topPadding + 18 + (PADDING_Y + 3);
        if (hasIcon && height < minHeight) {
            height = minHeight;
        }
        return new Point(width, height);
    }

    private static void updateStyle(class_1799 stack, @Nullable CustomFrameData data) {
        if (!(stack.method_7960() && lastStack.method_7960() || !stack.method_7960() && !lastStack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)lastStack))) {
            style = Styles.of(stack, data).orElse(null);
            lastStack = stack.method_7972();
            startMs = System.currentTimeMillis();
            TooltipScrollState.reset();
        }
        ELAPSED = (float)(System.currentTimeMillis() - startMs) / 1000.0f;
    }

    static {
        lastStack = class_1799.field_8037;
        LAYERS_MAIN = new ArrayList<ITooltipLayer>();
        LAYERS_EMPTY = new ArrayList<ITooltipLayer>();
        LAYERS_SECOND = new ArrayList<ITooltipLayer>();
        LAYERS_MAIN.add(new BackgroundLayer());
        LAYERS_MAIN.add(new IconBackgroundLayer());
        LAYERS_MAIN.add(new IconLayer());
        LAYERS_MAIN.add(new TextLayer());
        LAYERS_MAIN.add(new DividerLineLayer());
        LAYERS_MAIN.add(new InnerFrameLayer());
        LAYERS_MAIN.add(new EffectLayer());
        LAYERS_MAIN.add(new OverlayLayer());
        LAYERS_SECOND.add(new SecondBackgroundLayer());
        LAYERS_SECOND.add(new SecondInnerFrameLayer());
        LAYERS_SECOND.add(new ArmorStandLayer());
        LAYERS_SECOND.add(new RotatingItemLayer());
        LAYERS_EMPTY.add(new BackgroundLayer());
        LAYERS_EMPTY.add(new TextLayer());
        LAYERS_EMPTY.add(new InnerFrameLayer());
    }
}

