/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameConfig;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameConfigDeserializer;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameDataDeserializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class CustomFrameLoader {
    private static final String CONFIG_PATH = "custom_frames.json";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomFrameData.class, (Object)new CustomFrameDataDeserializer()).registerTypeAdapter(CustomFrameConfig.class, (Object)new CustomFrameConfigDeserializer()).setPrettyPrinting().create();

    public static Map<class_2960, CustomFrameData> loadCustomFrames(class_3300 resourceManager) {
        ConcurrentHashMap<class_2960, CustomFrameData> frames = new ConcurrentHashMap<class_2960, CustomFrameData>();
        Map resources = resourceManager.method_14488("tooltipoverhaul", path -> path.method_12832().endsWith(CONFIG_PATH));
        TooltipOverhaul.LOGGER.info("Found {} custom frame config files", (Object)resources.size());
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            try {
                CustomFrameLoader.loadFramesFromResource((class_3298)entry.getValue(), frames, location);
            }
            catch (Exception e) {
                TooltipOverhaul.LOGGER.error("Error loading custom frames from {}: {}", (Object)location, (Object)e.getMessage());
            }
        }
        TooltipOverhaul.LOGGER.info("Loaded {} custom frame entries total", (Object)frames.size());
        return frames;
    }

    private static void loadFramesFromResource(class_3298 resource, Map<class_2960, CustomFrameData> frames, class_2960 configLocation) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));){
            TooltipOverhaul.LOGGER.info("Loading custom frames from: {}", (Object)configLocation);
            CustomFrameConfig config = (CustomFrameConfig)GSON.fromJson((Reader)reader, CustomFrameConfig.class);
            if (config == null || config.getCustomFrames() == null) {
                TooltipOverhaul.LOGGER.warn("Empty or invalid custom frames config at {}", (Object)configLocation);
                return;
            }
            List<CustomFrameData> customFrames = config.getCustomFrames();
            String namespace = configLocation.method_12836();
            TooltipOverhaul.LOGGER.debug("Found {} frame configs in {}", (Object)customFrames.size(), (Object)namespace);
            for (CustomFrameData frameData : customFrames) {
                List<class_2960> itemLocations = frameData.getItemLocations();
                for (class_2960 item : itemLocations) {
                    if (frames.containsKey(item)) {
                        TooltipOverhaul.LOGGER.debug("Duplicate frame for item {} in {}, overwriting previous", (Object)item, (Object)configLocation);
                    }
                    frames.put(item, frameData);
                }
                if (itemLocations.isEmpty() && !frameData.tags().isEmpty()) {
                    class_2960 key = new class_2960(namespace, "tag_only/" + Integer.toUnsignedString(System.identityHashCode(frameData), 36));
                    frames.put(key, frameData);
                    TooltipOverhaul.LOGGER.debug("Registered tag-only entry {} with tags {}", (Object)key, frameData.tags());
                    continue;
                }
                if (frameData.tags().isEmpty()) continue;
                TooltipOverhaul.LOGGER.debug("Entry will also match tags (mixed): {}", frameData.tags());
            }
        }
        catch (IOException e) {
            TooltipOverhaul.LOGGER.error("Failed to read custom frames file {}: {}", (Object)configLocation, (Object)e.getMessage());
        }
        catch (JsonSyntaxException e) {
            TooltipOverhaul.LOGGER.error("Invalid JSON syntax in {}: {}", (Object)configLocation, (Object)e.getMessage());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Unexpected error loading custom frames from {}: {}", new Object[]{configLocation, e.getMessage(), e});
        }
    }
}

