/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.divider;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipDividerLine;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class DefaultDividerLine
implements ITooltipDividerLine {
    private static final int MIN_SEGMENTS = 2;
    private static final int MAX_SEGMENTS = 24;

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, class_241 pos, Point size) {
        if (ctx.getComponents().size() <= 1 || size.x <= 4) {
            return;
        }
        int y = (int)pos.field_1342 + 4 + TooltipRenderer.PADDING_Y + ((class_5684)ctx.getComponents().get(0)).method_32661() + 4 + 10;
        int x = (int)((float)((int)pos.field_1343) + (float)size.x * 0.1f);
        int width = (int)((float)size.x - (float)size.x * 0.2f);
        if (width <= 1) {
            return;
        }
        int segments = DefaultDividerLine.clamp(width / 12);
        ctx.push(() -> {
            int run;
            ctx.translate(0.0f, 0.0f, depth.getZ());
            class_4587 pose = ctx.graphics().method_51448();
            Matrix4f matrix = pose.method_23760().method_23761();
            class_289 tesselator = class_289.method_1348();
            class_287 buf = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(class_757::method_34540);
            int segmentLength = Math.max(1, width / segments);
            int px = x;
            float center = (float)width / 2.0f;
            for (int drawn = 0; drawn < width; drawn += run) {
                run = Math.min(segmentLength, width - drawn);
                int leftAlpha = DefaultDividerLine.alphaFromDistance(Math.abs((float)drawn - center) / center, 0.025f);
                int rightAlpha = DefaultDividerLine.alphaFromDistance(Math.abs((float)(drawn + run - 1) - center) / center, 0.025f);
                int lineColor = Util.getDividerLineColor(ctx);
                int leftColor = leftAlpha << 24 | lineColor & 0xFFFFFF;
                int rightColor = rightAlpha << 24 | lineColor & 0xFFFFFF;
                int alphaLeft = leftColor >>> 24 & 0xFF;
                int redLeft = leftColor >>> 16 & 0xFF;
                int greenLeft = leftColor >>> 8 & 0xFF;
                int blueLeft = leftColor & 0xFF;
                int alphaRight = rightColor >>> 24 & 0xFF;
                int redRight = rightColor >>> 16 & 0xFF;
                int greenRight = rightColor >>> 8 & 0xFF;
                int blueRight = rightColor & 0xFF;
                buf.method_22918(matrix, (float)px, (float)(y + 1), 0.0f).method_1336(redLeft, greenLeft, blueLeft, alphaLeft);
                buf.method_22918(matrix, (float)(px + run), (float)(y + 1), 0.0f).method_1336(redRight, greenRight, blueRight, alphaRight);
                buf.method_22918(matrix, (float)(px + run), (float)y, 0.0f).method_1336(redRight, greenRight, blueRight, alphaRight);
                buf.method_22918(matrix, (float)px, (float)y, 0.0f).method_1336(redLeft, greenLeft, blueLeft, alphaLeft);
                px += run;
            }
            try (class_9801 data = buf.method_60800();){
                class_286.method_43433((class_9801)data);
            }
        });
    }

    private static int alphaFromDistance(float distanceNorm, float fade) {
        if (distanceNorm <= fade) {
            return 255;
        }
        float z = (distanceNorm - fade) / (1.0f - fade);
        return Math.max(0, Math.min(255, (int)(255.0f * (1.0f - z * z))));
    }

    private static int clamp(int value) {
        return Math.max(2, Math.min(24, value));
    }
}

