/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import com.mojang.blaze3d.platform.NativeImage;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameLoader;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import java.awt.Color;
import java.awt.Point;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class CustomFrameManager {
    private static final Map<ResourceLocation, CustomFrameData> customFrames = new ConcurrentHashMap<ResourceLocation, CustomFrameData>();
    private static boolean INIT = false;
    private static final int FRAME_DIM = 132;
    private static final int FRAME_TIME = 120;
    private static final Map<ResourceLocation, TextureInfo> TEXTURE_CACHE = new ConcurrentHashMap<ResourceLocation, TextureInfo>();
    private static final Map<ResourceLocation, int[][]> ACCENT_CACHE = new ConcurrentHashMap<ResourceLocation, int[][]>();
    private static final float MIN_DARK_RATIO = 0.3f;
    private static final double LUMINISCE = 0.075;
    private static final int SAMPLEX = 2;
    private static final int ALPHA_RATIO = 48;

    public static void initialize() {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(Minecraft.m_91087_().m_91098_()));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void initialize(ResourceManager resourceManager) {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(resourceManager));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void reset() {
        customFrames.clear();
        TEXTURE_CACHE.clear();
        ACCENT_CACHE.clear();
        INIT = false;
    }

    public static Optional<CustomFrameData> of(ItemStack stack) {
        if (!INIT) {
            CustomFrameManager.initialize();
        }
        return customFrames.values().stream().filter(cfg -> cfg.matches(stack)).findFirst();
    }

    public static void renderCustomFrame(TooltipContext ctx, CustomFrameData frameData, Vec2 pos, Point size) {
        if (frameData.getTexture() == null) {
            return;
        }
        ResourceLocation texture = new ResourceLocation(frameData.getTexture());
        TextureInfo meta = CustomFrameManager.getTexMeta(texture);
        int texW = meta.width;
        int texH = meta.height;
        int frames = meta.frames;
        int idx = frames > 1 ? (int)(System.currentTimeMillis() / 120L % (long)frames) : 0;
        int vFrameOffset = idx * 132;
        int x = (int)pos.f_82470_;
        int y = (int)pos.f_82471_;
        int width = size.x;
        int height = size.y;
        ctx.push(() -> {
            ctx.translate(0.0f, 0.0f, LayerDepth.BACKGROUND_OVERLAY.getZ());
            ctx.graphics().m_280163_(texture, x - 22 - 4 + 1, y - 22 - 4 + 1, 0.0f, (float)vFrameOffset, 44, 44, texW, texH);
            ctx.graphics().m_280163_(texture, x + width - 20 + 1, y - 22 - 4 + 1, 88.0f, (float)vFrameOffset, 44, 44, texW, texH);
            ctx.graphics().m_280163_(texture, x - 22 - 4 + 1, y + height - 20 + 1, 0.0f, (float)(88 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().m_280163_(texture, x + width - 20 + 1, y + height - 20 + 1, 88.0f, (float)(88 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().m_280163_(texture, x - 22 - 4 + 1, y - 22 - 4 + 1 + 3 + height / 2, 0.0f, (float)(44 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().m_280163_(texture, x + width - 20 + 1, y - 22 - 4 + 1 + 3 + height / 2, 88.0f, (float)(44 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().m_280163_(texture, x - 22 - 4 + 1 + 4 + width / 2, y - 22 - 4 + 1, 44.0f, (float)vFrameOffset, 44, 44, texW, texH);
            ctx.graphics().m_280163_(texture, x - 22 - 4 + 1 + 4 + width / 2, y + height - 20 + 1, 44.0f, (float)(88 + vFrameOffset), 44, 44, texW, texH);
        });
    }

    private static TextureInfo getTexMeta(ResourceLocation texture) {
        return TEXTURE_CACHE.computeIfAbsent(texture, tex -> {
            try {
                Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(tex);
                if (resource.isEmpty()) {
                    return new TextureInfo(132, 132, 1);
                }
                try (InputStream is = ((Resource)resource.get()).m_215507_();){
                    TextureInfo textureInfo;
                    block17: {
                        NativeImage img = NativeImage.m_85058_((InputStream)is);
                        try {
                            int width = img.m_84982_();
                            int heigth = img.m_85084_();
                            if (width < 132) {
                                TooltipOverhaul.LOGGER.warn("Texture width {} is smaller than expected {} for {}", new Object[]{width, 132, tex});
                            }
                            if (heigth % 132 != 0) {
                                TooltipOverhaul.LOGGER.warn("Texture height {} is not a multiple of {} for {} (anim may look off)", new Object[]{heigth, 132, tex});
                            }
                            textureInfo = new TextureInfo(width, heigth, Math.max(1, heigth / 132));
                            if (img == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return textureInfo;
                }
            }
            catch (Exception e) {
                TooltipOverhaul.LOGGER.error("Failed to read texture {}: {}", tex, (Object)e.toString());
                return new TextureInfo(132, 132, 1);
            }
        });
    }

    private static int getMainColor(NativeImage img, int frameIdx) {
        int frameNum = frameIdx * 132;
        int marginX = 8;
        int marginY = 8;
        Accumulator acc = new Accumulator();
        CustomFrameManager.linearRGB(img, 44, frameNum, marginX, marginY, acc);
        CustomFrameManager.linearRGB(img, 0, frameNum + 44, marginX, marginY, acc);
        CustomFrameManager.linearRGB(img, 88, frameNum + 44, marginX, marginY, acc);
        CustomFrameManager.linearRGB(img, 44, frameNum + 88, marginX, marginY, acc);
        if (acc.alphaTotal < 1.0E-5) {
            return CustomFrameManager.colorFallback(img, frameIdx);
        }
        float[] hsl = CustomFrameManager.accumulateRGB2HSL(acc);
        hsl[2] = CustomFrameManager.clamp(hsl[2], 0.22f, 0.9f);
        return 0xFF000000 | CustomFrameManager.hslToRgb(hsl[0], hsl[1], hsl[2]) & 0xFFFFFF;
    }

    private static void linearRGB(NativeImage img, int x0, int y0, int mx, int my, Accumulator acc) {
        int x1 = 2 + x0 + 42;
        int y1 = 2 + y0 + 42;
        for (int y = y0 + my; y < y1 - my; y += 2) {
            for (int x = x0 + mx; x < x1 - mx; x += 2) {
                float v;
                int blue;
                int green;
                int red;
                float[] HSVParser;
                float s;
                int colorr = img.m_84985_(x, y);
                int a = colorr >>> 24 & 0xFF;
                if (a < 48 || (s = (HSVParser = Color.RGBtoHSB(red = colorr & 0xFF, green = colorr >>> 8 & 0xFF, blue = colorr >>> 16 & 0xFF, null))[1]) < 0.15f || (v = HSVParser[2]) < 0.15f || v > 0.92f) continue;
                acc.redTotal += (double)a / 255.0 * (0.6 + 0.4 * (double)s) * CustomFrameManager.srgbToLinear((double)red / 255.0);
                acc.greenTotal += (double)a / 255.0 * (0.6 + 0.4 * (double)s) * CustomFrameManager.srgbToLinear((double)green / 255.0);
                acc.blueTotal += (double)a / 255.0 * (0.6 + 0.4 * (double)s) * CustomFrameManager.srgbToLinear((double)blue / 255.0);
                acc.alphaTotal += (double)a / 255.0 * (0.6 + 0.4 * (double)s);
            }
        }
    }

    private static int colorFallback(NativeImage img, int frameIdx) {
        int y0 = frameIdx * 132;
        Accumulator acc = new Accumulator();
        for (int y = 0; y < 132; y += 2) {
            for (int x = 0; x < 132; x += 2) {
                int abgr = img.m_84985_(x, y0 + y);
                int a = abgr >>> 24 & 0xFF;
                if (a < 48) continue;
                int red = abgr & 0xFF;
                int green = abgr >>> 8 & 0xFF;
                int blue = abgr >>> 16 & 0xFF;
                float[] hsv = Color.RGBtoHSB(red, green, blue, null);
                float s = hsv[1];
                float v = hsv[2];
                if (v < 0.12f || v > 0.96f) continue;
                acc.redTotal += (double)a / 255.0 * (0.5 + 0.5 * (double)s) * CustomFrameManager.srgbToLinear((double)red / 255.0);
                acc.greenTotal += (double)a / 255.0 * (0.5 + 0.5 * (double)s) * CustomFrameManager.srgbToLinear((double)green / 255.0);
                acc.blueTotal += (double)a / 255.0 * (0.5 + 0.5 * (double)s) * CustomFrameManager.srgbToLinear((double)blue / 255.0);
                acc.alphaTotal += (double)a / 255.0 * (0.5 + 0.5 * (double)s);
            }
        }
        if (acc.alphaTotal <= 1.0E-6) {
            return -1;
        }
        float[] hsl = CustomFrameManager.accumulateRGB2HSL(acc);
        hsl[2] = CustomFrameManager.clamp(hsl[2], 0.22f, 0.92f);
        int rgb = CustomFrameManager.hslToRgb(hsl[0], hsl[1], hsl[2]) & 0xFFFFFF;
        return 0xFF000000 | rgb;
    }

    private static float[] accumulateRGB2HSL(Accumulator acc) {
        double invAlpha = acc.alphaTotal > 0.0 ? 1.0 / acc.alphaTotal : 0.0;
        int r = (int)Math.round(CustomFrameManager.linearToSrgb(acc.redTotal * invAlpha) * 255.0);
        int g = (int)Math.round(CustomFrameManager.linearToSrgb(acc.greenTotal * invAlpha) * 255.0);
        int b = (int)Math.round(CustomFrameManager.linearToSrgb(acc.blueTotal * invAlpha) * 255.0);
        float[] hsl = CustomFrameManager.rgbToHsl(r, g, b);
        hsl[1] = Math.max(hsl[1], 0.3f);
        return hsl;
    }

    public static int[] getPalette(CustomFrameData frameData) {
        if (frameData == null || frameData.getTexture() == null) {
            return new int[]{-1, -1, -1};
        }
        ResourceLocation texture = new ResourceLocation(frameData.getTexture());
        TextureInfo meta = CustomFrameManager.getTexMeta(texture);
        int idx = meta.frames > 1 ? (int)(System.currentTimeMillis() / 120L % (long)meta.frames) : 0;
        return CustomFrameManager.getPalette(texture, idx);
    }

    public static int[] getPalette(ResourceLocation texture, int frameIndex) {
        int[][] palette = ACCENT_CACHE.computeIfAbsent(texture, t -> CustomFrameManager.accent(t, CustomFrameManager.getTexMeta(texture)));
        if (palette.length == 0) {
            return new int[]{-1, -1, -1};
        }
        return palette[Math.max(0, Math.min(frameIndex, palette.length - 1))];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int[][] accent(ResourceLocation tex, TextureInfo meta) {
        try {
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(tex);
            if (resource.isEmpty()) {
                return new int[0][];
            }
            try (InputStream input = ((Resource)resource.get()).m_215507_();){
                int[][] nArray;
                block16: {
                    NativeImage img = NativeImage.m_85058_((InputStream)input);
                    try {
                        int[][] ret = new int[meta.frames][3];
                        for (int f = 0; f < meta.frames; ++f) {
                            ret[f] = CustomFrameManager.getFrontColors(img, f);
                        }
                        nArray = ret;
                        if (img == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (img != null) {
                            try {
                                img.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    img.close();
                }
                return nArray;
            }
        }
        catch (Exception ignore) {
            return new int[0][];
        }
    }

    private static int[] getFrontColors(NativeImage img, int frameIdx) {
        int darkCol;
        int base = CustomFrameManager.getMainColor(img, frameIdx);
        int alpha = 255;
        int red = base >>> 16 & 0xFF;
        int green = base >>> 8 & 0xFF;
        int blue = base & 0xFF;
        float[] hsl = CustomFrameManager.rgbToHsl(red, green, blue);
        float hue = hsl[0];
        float saturn = hsl[1];
        float low = hsl[2];
        float lowMid = CustomFrameManager.clamp(low, 0.2f, 0.92f);
        float highMid = CustomFrameManager.clamp(saturn, 0.0f, 1.0f);
        int midColor = CustomFrameManager.hslToRgb(hue, highMid, lowMid) & 0xFFFFFF | alpha << 24;
        float lowDark = CustomFrameManager.clamp(lowMid - 0.12f, 0.3f, 0.88f);
        float highDark = CustomFrameManager.clamp(highMid * 1.06f, 0.0f, 1.0f);
        if (lowDark >= lowMid) {
            lowDark = Math.max(0.3f, lowMid - 0.06f);
        }
        if (CustomFrameManager.luminanceParser(darkCol = CustomFrameManager.hslToRgb(hue, highDark, lowDark) & 0xFFFFFF | alpha << 24) < 0.075) {
            int cap = 0;
            while (CustomFrameManager.luminanceParser(darkCol) < 0.075 && cap++ < 8) {
                lowDark = CustomFrameManager.clamp(lowDark + 0.02f, 0.3f, Math.min(0.88f, lowMid - 0.02f));
                darkCol = CustomFrameManager.hslToRgb(hue, highDark, lowDark) & 0xFFFFFF | alpha << 24;
            }
        }
        return new int[]{CustomFrameManager.hslToRgb(hue, CustomFrameManager.clamp(highMid * 0.92f, 0.0f, 1.0f), CustomFrameManager.clamp(lowMid + 0.12f, 0.2f, 0.95f)) & 0xFFFFFF | alpha << 24, midColor, darkCol};
    }

    private static float[] rgbToHsl(int r, int g, int b) {
        float sat;
        float hue;
        float red = (float)r / 255.0f;
        float green = (float)g / 255.0f;
        float blue = (float)b / 255.0f;
        float max = Math.max(red, Math.max(green, blue));
        float min = Math.min(red, Math.min(green, blue));
        float l = (max + min) / 2.0f;
        if (max == min) {
            hue = 0.0f;
            sat = 0.0f;
        } else {
            float dist = max - min;
            float f = sat = l > 0.5f ? dist / (2.0f - max - min) : dist / (max + min);
            hue = max == red ? (green - blue) / dist + (green < blue ? 6.0f : 0.0f) : (max == green ? (blue - red) / dist + 2.0f : (red - green) / dist + 4.0f);
            hue /= 6.0f;
        }
        return new float[]{hue, sat, l};
    }

    private static int hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = CustomFrameManager.hue2rgb(p, q, h + 0.33333334f);
            g = CustomFrameManager.hue2rgb(p, q, h);
            b = CustomFrameManager.hue2rgb(p, q, h - 0.33333334f);
        }
        return (int)(r * 255.0f + 0.5f) << 16 | (int)(g * 255.0f + 0.5f) << 8 | (int)(b * 255.0f + 0.5f);
    }

    private static float hue2rgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    private static double luminanceParser(int argb) {
        double rl = CustomFrameManager.srgbToLinear((double)(argb >>> 16 & 0xFF) / 255.0);
        double gl = CustomFrameManager.srgbToLinear((double)(argb >>> 8 & 0xFF) / 255.0);
        double bl = CustomFrameManager.srgbToLinear((double)(argb & 0xFF) / 255.0);
        return 0.2126 * rl + 0.7152 * gl + 0.0722 * bl;
    }

    private static double srgbToLinear(double x) {
        return x <= 0.04045 ? x / 12.92 : Math.pow((x + 0.055) / 1.055, 2.4);
    }

    private static double linearToSrgb(double x) {
        return x <= 0.0031308 ? x * 12.92 : 1.055 * Math.pow(x, 0.4166666666666667) - 0.055;
    }

    private static float clamp(float c1, float c2, float hu) {
        return c1 < c2 ? c2 : Math.min(c1, hu);
    }

    private record TextureInfo(int width, int height, int frames) {
    }

    private static class Accumulator {
        double redTotal;
        double greenTotal;
        double blueTotal;
        double alphaTotal;

        private Accumulator() {
        }
    }
}

