/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.util;

import dev.xylonity.tooltipoverhaul.client.Palette;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.config.parser.ConfigColorParser;
import dev.xylonity.tooltipoverhaul.util.TextAxis;
import dev.xylonity.tooltipoverhaul.util.TextType;
import java.awt.Point;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class Util {
    public static float calcRotY(double time) {
        return (float)((double)System.currentTimeMillis() / time * 360.0 % 360.0);
    }

    public static boolean shouldDisableIcon(ItemStack stack) {
        return !stack.m_41619_() && CustomFrameManager.of(stack).map(CustomFrameData::shouldDisableIcon).orElse(TooltipsConfig.DISABLE_ICON) != false;
    }

    public static int getSecondPanelOffset(TooltipContext ctx, TextAxis axis) {
        if (axis == TextAxis.X) {
            return ctx.data().map(CustomFrameData::getSecondPanelX).orElse(TooltipsConfig.SECOND_PANEL_X);
        }
        return ctx.data().map(CustomFrameData::getSecondPanelY).orElse(TooltipsConfig.SECOND_PANEL_Y);
    }

    public static boolean isScrollingDisabled(TooltipContext ctx) {
        return ctx.data().map(CustomFrameData::shouldDisableScrolling).orElse(TooltipsConfig.DISABLE_TOOLTIP_SCROLLING);
    }

    public static int getBackgroundColor(TooltipContext ctx) {
        return ctx.data().map(CustomFrameData::getBackgroundColor).orElse(Palette.PANEL_BG);
    }

    public static boolean shouldShowRating(ItemStack stack) {
        return !stack.m_41619_() && CustomFrameManager.of(stack).map(CustomFrameData::shouldShowRating).orElse(TooltipsConfig.SHOW_RATING) != false;
    }

    public static String getIconAppearAnimation(TooltipContext context) {
        return context.data().isPresent() ? context.data().get().getIconAppearAnimation() : TooltipsConfig.ICON_APPEAR_ANIMATION;
    }

    public static float getIconRotatingSpeed(TooltipContext context) {
        return context.data().isPresent() ? context.data().get().getIconRotatingSpeed() : TooltipsConfig.ICON_ROTATING_SPEED;
    }

    public static int getDividerLineColor(TooltipContext ctx) {
        if (ctx.data().isPresent()) {
            return Util.parseDividerLineColor(ctx.data().get().getDividerLineColor(), ctx.stack());
        }
        return Util.parseDividerLineColor(TooltipsConfig.DIVIDER_LINE_COLOR, ctx.stack());
    }

    private static int parseDividerLineColor(String matcher, ItemStack stack) {
        switch (matcher) {
            case "match_inner_frame_color": {
                Rarity r = stack.m_41791_();
                int palette = Palette.LEGENDARY[0];
                if (r == Rarity.COMMON) {
                    palette = Palette.COMMON[0];
                }
                if (r == Rarity.UNCOMMON) {
                    palette = Palette.UNCOMMON[0];
                }
                if (r == Rarity.RARE) {
                    palette = Palette.RARE[0];
                }
                if (r == Rarity.EPIC) {
                    palette = Palette.EPIC[0];
                }
                return palette;
            }
            case "match_item_name_color": {
                TextColor color = stack.m_41786_().m_7383_().m_131135_();
                TextColor rarityColor = TextColor.m_131270_((ChatFormatting)stack.m_41791_().f_43022_);
                if (color != null) {
                    return color.m_131265_();
                }
                if (rarityColor == null) break;
                return rarityColor.m_131265_();
            }
            default: {
                if (!matcher.startsWith("0x") && !matcher.startsWith("0X") && !matcher.startsWith("#")) break;
                return ConfigColorParser.parseColor(matcher);
            }
        }
        return -1;
    }

    public static int getExtraTextPosition(TooltipContext ctx, TextType type, TextAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case TextAxis.X -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TITLE: {
                        yield ctx.data().map(CustomFrameData::getTitlePositionX).orElse(TooltipsConfig.TITLE_POSITION_X);
                    }
                    case RATING: {
                        yield ctx.data().map(CustomFrameData::getRatingPositionX).orElse(TooltipsConfig.RATING_POSITION_X);
                    }
                    case DESCRIPTION: 
                }
                yield ctx.data().map(CustomFrameData::getTooltipDescriptionPositionX).orElse(TooltipsConfig.TOOLTIP_DESCRIPTION_POSITION_X);
            }
            case TextAxis.Y -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TITLE: {
                        yield ctx.data().map(CustomFrameData::getTitlePositionY).orElse(TooltipsConfig.TITLE_POSITION_Y);
                    }
                    case RATING: {
                        yield ctx.data().map(CustomFrameData::getRatingPositionY).orElse(TooltipsConfig.RATING_POSITION_Y);
                    }
                    case DESCRIPTION: 
                }
                yield ctx.data().map(CustomFrameData::getTooltipDescriptionPositionY).orElse(TooltipsConfig.TOOLTIP_DESCRIPTION_POSITION_Y);
            }
        };
    }

    public static int getTitleAlignmentX(int posx, int offset, Point size, ClientTooltipComponent component, Font font, TooltipContext ctx) {
        int startX = posx + offset;
        int rightX = posx + size.x - TooltipRenderer.PADDING_X;
        int textWidth = component.m_142069_(font);
        int available = rightX - startX;
        int result = switch (ctx.data().map(CustomFrameData::getTitleAlignment).orElse(TooltipsConfig.TITLE_X_ALIGNMENT)) {
            case "middle" -> startX + (available - textWidth) / 2;
            case "right" -> rightX - textWidth;
            default -> startX;
        };
        if (available <= 0) {
            return startX;
        }
        result = Math.max(startX, Math.min(result, rightX - Math.min(textWidth, available)));
        return result;
    }

    public static int getRatingAlignmentX(int posx, int offset, Point size, Component rarity, Font font, TooltipContext ctx) {
        int startX = posx + offset;
        int rightX = posx + size.x - TooltipRenderer.PADDING_X;
        int available = Math.max(0, rightX - startX);
        int compWidth = font.m_92852_((FormattedText)rarity);
        if (available > 0 && compWidth > available) {
            int maxLine = 0;
            for (FormattedCharSequence line : font.m_92923_((FormattedText)rarity, available)) {
                maxLine = Math.max(maxLine, font.m_92724_(line));
            }
            compWidth = Math.min(maxLine, available);
        }
        int result = switch (ctx.data().map(CustomFrameData::getRatingAlignment).orElse(TooltipsConfig.RATING_X_ALIGNMENT)) {
            case "middle" -> startX + (available - compWidth) / 2;
            case "right" -> rightX - compWidth;
            default -> startX;
        };
        if (available <= 0) {
            return startX;
        }
        return Math.max(startX, Math.min(result, rightX - compWidth));
    }

    public static String getDefaultRarity(ItemStack stack) {
        return Component.m_237115_((String)("tooltipoverhaul." + stack.m_41791_().toString().toLowerCase() + "_rarity")).getString();
    }
}

