/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import com.mojang.blaze3d.platform.NativeImage;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameLoader;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import java.awt.Color;
import java.awt.Point;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class CustomFrameManager {
    private static final Map<ResourceLocation, CustomFrameData> customFrames = new ConcurrentHashMap<ResourceLocation, CustomFrameData>();
    private static boolean INIT = false;
    private static final int FRAME_DIM = 132;
    private static final int FRAME_TIME = 120;
    private static final Map<ResourceLocation, TextureInfo> TEXTURE_CACHE = new ConcurrentHashMap<ResourceLocation, TextureInfo>();
    private static final Map<ResourceLocation, int[][]> ACCENT_CACHE = new ConcurrentHashMap<ResourceLocation, int[][]>();
    private static final int SAMPLEX = 2;

    public static void initialize() {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(Minecraft.getInstance().getResourceManager(), TooltipOverhaul.PLATFORM.getConfigPath()));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void initialize(ResourceManager resourceManager) {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(resourceManager, TooltipOverhaul.PLATFORM.getConfigPath()));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void reset() {
        customFrames.clear();
        TEXTURE_CACHE.clear();
        ACCENT_CACHE.clear();
        INIT = false;
    }

    public static Optional<CustomFrameData> of(ItemStack stack) {
        if (!INIT) {
            CustomFrameManager.initialize();
        }
        return customFrames.values().stream().filter(cfg -> cfg.matches(stack)).findFirst();
    }

    public static void renderCustomFrame(TooltipContext ctx, Vec2 pos, Point size) {
        String textureLocation = ctx.data().map(CustomFrameData::getTexture).orElse(TooltipsConfig.GLOBAL_FRAME_OVERLAY_LOCATION);
        if (textureLocation == null || textureLocation.isEmpty() || textureLocation.isBlank()) {
            return;
        }
        ResourceLocation texture = ResourceLocation.tryParse((String)textureLocation);
        TextureInfo meta = CustomFrameManager.getTexMeta(texture);
        int texW = meta.width;
        int texH = meta.height;
        int frames = meta.frames;
        int idx = frames > 1 ? (int)(System.currentTimeMillis() / 120L % (long)frames) : 0;
        int vFrameOffset = idx * 132;
        int x = (int)pos.x;
        int y = (int)pos.y;
        int width = size.x;
        int height = size.y;
        ctx.push(() -> {
            ctx.translate(0.0f, 0.0f, LayerDepth.BACKGROUND_OVERLAY.getZ());
            ctx.graphics().blit(texture, x - 22 - 4 + 1, y - 22 - 4 + 1, 0.0f, (float)vFrameOffset, 44, 44, texW, texH);
            ctx.graphics().blit(texture, x + width - 20 + 1, y - 22 - 4 + 1, 88.0f, (float)vFrameOffset, 44, 44, texW, texH);
            ctx.graphics().blit(texture, x - 22 - 4 + 1, y + height - 20 + 1, 0.0f, (float)(88 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().blit(texture, x + width - 20 + 1, y + height - 20 + 1, 88.0f, (float)(88 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().blit(texture, x - 22 - 4 + 1, y - 22 - 4 + 1 + 3 + height / 2, 0.0f, (float)(44 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().blit(texture, x + width - 20 + 1, y - 22 - 4 + 1 + 3 + height / 2, 88.0f, (float)(44 + vFrameOffset), 44, 44, texW, texH);
            ctx.graphics().blit(texture, x - 22 - 4 + 1 + 4 + width / 2, y - 22 - 4 + 1, 44.0f, (float)vFrameOffset, 44, 44, texW, texH);
            ctx.graphics().blit(texture, x - 22 - 4 + 1 + 4 + width / 2, y + height - 20 + 1, 44.0f, (float)(88 + vFrameOffset), 44, 44, texW, texH);
        });
    }

    private static TextureInfo getTexMeta(ResourceLocation texture) {
        return TEXTURE_CACHE.computeIfAbsent(texture, tex -> {
            try {
                Optional resource = Minecraft.getInstance().getResourceManager().getResource(tex);
                if (resource.isEmpty()) {
                    return new TextureInfo(132, 132, 1);
                }
                try (InputStream is = ((Resource)resource.get()).open();){
                    TextureInfo textureInfo;
                    block17: {
                        NativeImage img = NativeImage.read((InputStream)is);
                        try {
                            int width = img.getWidth();
                            int heigth = img.getHeight();
                            if (width < 132) {
                                TooltipOverhaul.LOGGER.warn("Texture width {} is smaller than expected {} for {}", new Object[]{width, 132, tex});
                            }
                            if (heigth % 132 != 0) {
                                TooltipOverhaul.LOGGER.warn("Texture height {} is not a multiple of {} for {} (anim may look off)", new Object[]{heigth, 132, tex});
                            }
                            textureInfo = new TextureInfo(width, heigth, Math.max(1, heigth / 132));
                            if (img == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return textureInfo;
                }
            }
            catch (Exception e) {
                TooltipOverhaul.LOGGER.error("Failed to read texture {}: {}", tex, (Object)e.toString());
                return new TextureInfo(132, 132, 1);
            }
        });
    }

    private static Integer sampleRegionColor(NativeImage img, int x0, int y0, int width, int height) {
        int b;
        Accumulator acc = new Accumulator();
        int x1 = x0 + width;
        int y1 = y0 + height;
        int marginX = 8;
        int marginY = 8;
        for (int y = y0 + marginY; y < y1 - marginY; y += 2) {
            for (int x = x0 + marginX; x < x1 - marginX; x += 2) {
                int abgr = img.getPixelRGBA(x, y);
                int a = abgr >> 24 & 0xFF;
                b = abgr >> 16 & 0xFF;
                int g = abgr >> 8 & 0xFF;
                int r = abgr & 0xFF;
                if (a < 48) continue;
                float[] hsv = Color.RGBtoHSB(r, g, b, null);
                float s = hsv[1];
                float v = hsv[2];
                if ((double)s < 0.05 || (double)v < 0.1 || v > 0.98f) continue;
                float weight = (float)a / 255.0f * (0.2f + 0.8f * s);
                acc.redTotal += (double)weight * CustomFrameManager.srgbToLinear((double)r / 255.0);
                acc.greenTotal += (double)weight * CustomFrameManager.srgbToLinear((double)g / 255.0);
                acc.blueTotal += (double)weight * CustomFrameManager.srgbToLinear((double)b / 255.0);
                acc.alphaTotal += (double)weight;
            }
        }
        if (acc.alphaTotal < 1.0E-5) {
            return null;
        }
        double invAlpha = 1.0 / acc.alphaTotal;
        int r = (int)Math.round(CustomFrameManager.linearToSrgb(acc.redTotal * invAlpha) * 255.0);
        int g = (int)Math.round(CustomFrameManager.linearToSrgb(acc.greenTotal * invAlpha) * 255.0);
        b = (int)Math.round(CustomFrameManager.linearToSrgb(acc.blueTotal * invAlpha) * 255.0);
        r = CustomFrameManager.clamp(r);
        g = CustomFrameManager.clamp(g);
        b = CustomFrameManager.clamp(b);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int[] getPalette(CustomFrameData frameData) {
        if (frameData == null || frameData.getTexture() == null) {
            return new int[]{-1, -1, -1};
        }
        ResourceLocation texture = ResourceLocation.tryParse((String)frameData.getTexture());
        TextureInfo meta = CustomFrameManager.getTexMeta(texture);
        int idx = meta.frames > 1 ? (int)(System.currentTimeMillis() / 120L % (long)meta.frames) : 0;
        return CustomFrameManager.getPalette(texture, idx);
    }

    public static int[] getPalette(ResourceLocation texture, int frameIndex) {
        int[][] palette = ACCENT_CACHE.computeIfAbsent(texture, t -> CustomFrameManager.accent(t, CustomFrameManager.getTexMeta(texture)));
        if (palette.length == 0) {
            return new int[]{-1, -1, -1};
        }
        return palette[Math.max(0, Math.min(frameIndex, palette.length - 1))];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int[][] accent(ResourceLocation tex, TextureInfo meta) {
        try {
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(tex);
            if (resource.isEmpty()) {
                return new int[0][];
            }
            try (InputStream input = ((Resource)resource.get()).open();){
                int[][] nArray;
                block16: {
                    NativeImage img = NativeImage.read((InputStream)input);
                    try {
                        int[][] ret = new int[meta.frames][3];
                        for (int f = 0; f < meta.frames; ++f) {
                            ret[f] = CustomFrameManager.getFrontColors(img, f);
                        }
                        nArray = ret;
                        if (img == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (img != null) {
                            try {
                                img.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    img.close();
                }
                return nArray;
            }
        }
        catch (Exception ignore) {
            return new int[0][];
        }
    }

    private static int[] getFrontColors(NativeImage img, int frameIdx) {
        int frameOffset = frameIdx * 132;
        Integer topColor = CustomFrameManager.sampleRegionColor(img, 44, frameOffset, 44, 44);
        Integer leftColor = CustomFrameManager.sampleRegionColor(img, 0, frameOffset + 44, 44, 44);
        Integer rightColor = CustomFrameManager.sampleRegionColor(img, 88, frameOffset + 44, 44, 44);
        Integer midColor = null;
        if (leftColor != null && rightColor != null) {
            midColor = CustomFrameManager.blendColors(leftColor, rightColor);
        } else if (leftColor != null) {
            midColor = leftColor;
        } else if (rightColor != null) {
            midColor = rightColor;
        }
        Integer bottomColor = CustomFrameManager.sampleRegionColor(img, 44, frameOffset + 88, 44, 44);
        int validColors = 0;
        if (topColor != null) {
            ++validColors;
        }
        if (midColor != null) {
            ++validColors;
        }
        if (bottomColor != null) {
            ++validColors;
        }
        if (validColors == 0) {
            int neutral = -4144960;
            return new int[]{neutral, neutral, neutral};
        }
        if (topColor == null) {
            Integer n = topColor = midColor != null ? midColor : bottomColor;
        }
        if (midColor == null) {
            midColor = topColor;
        }
        if (bottomColor == null) {
            bottomColor = midColor;
        }
        return new int[]{topColor, midColor, bottomColor};
    }

    private static int blendColors(int color1, int color2) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)Math.round(CustomFrameManager.linearToSrgb((CustomFrameManager.srgbToLinear((double)r1 / 255.0) + CustomFrameManager.srgbToLinear((double)r2 / 255.0)) * 0.5) * 255.0);
        int g = (int)Math.round(CustomFrameManager.linearToSrgb((CustomFrameManager.srgbToLinear((double)g1 / 255.0) + CustomFrameManager.srgbToLinear((double)g2 / 255.0)) * 0.5) * 255.0);
        int b = (int)Math.round(CustomFrameManager.linearToSrgb((CustomFrameManager.srgbToLinear((double)b1 / 255.0) + CustomFrameManager.srgbToLinear((double)b2 / 255.0)) * 0.5) * 255.0);
        return 0xFF000000 | CustomFrameManager.clamp(r) << 16 | CustomFrameManager.clamp(g) << 8 | CustomFrameManager.clamp(b);
    }

    private static double srgbToLinear(double x) {
        return x <= 0.04045 ? x / 12.92 : Math.pow((x + 0.055) / 1.055, 2.4);
    }

    private static double linearToSrgb(double x) {
        return x <= 0.0031308 ? x * 12.92 : 1.055 * Math.pow(x, 0.4166666666666667) - 0.055;
    }

    private static int clamp(int value) {
        return Math.max(0, Math.min(255, value));
    }

    private record TextureInfo(int width, int height, int frames) {
    }

    private static class Accumulator {
        double redTotal;
        double greenTotal;
        double blueTotal;
        double alphaTotal;

        private Accumulator() {
        }
    }
}

