/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.text;

import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.TooltipScrollState;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipText;
import dev.xylonity.tooltipoverhaul.util.TextAxis;
import dev.xylonity.tooltipoverhaul.util.TextType;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;

public class DefaultText
implements ITooltipText {
    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size, Component rarity, Font font) {
        ctx.push(() -> {
            int h;
            int x;
            ClientTooltipComponent component;
            int i;
            ctx.translate(0.0f, 0.0f, depth.getZ());
            boolean hasStack = !ctx.stack().isEmpty();
            boolean shouldShowRating = Util.shouldShowRating(ctx.stack());
            int firstLineOffset = TooltipRenderer.PADDING_X + (hasStack ? 26 : 0) - (Util.shouldDisableIcon(ctx.stack()) ? 26 : 0);
            if (hasStack && rarity != null && !rarity.getString().isEmpty() && shouldShowRating) {
                int py = Math.min(ctx.mouseY() - 12, ctx.height() - size.y - 4) + Util.getExtraTextPosition(ctx, TextType.RATING, TextAxis.Y);
                ctx.graphics().drawString(font, rarity, Util.getRatingAlignmentX((int)pos.x + Util.getExtraTextPosition(ctx, TextType.RATING, TextAxis.X), firstLineOffset, size, rarity, font, ctx), py + 13 + TooltipRenderer.PADDING_Y, 15588982, false);
            }
            if (!TooltipScrollState.isIsActive()) {
                int x2;
                ClientTooltipComponent component2;
                int i2;
                int y = (int)pos.y + TooltipRenderer.PADDING_Y + 3 + (shouldShowRating || !hasStack ? 0 : 6) + Util.getExtraTextPosition(ctx, TextType.TITLE, TextAxis.Y);
                for (i2 = 0; i2 < ctx.getComponents().size(); ++i2) {
                    component2 = (ClientTooltipComponent)ctx.getComponents().get(i2);
                    if (i2 == 1) {
                        y += (hasStack ? 3 : 0) - (shouldShowRating || !hasStack ? 0 : 6) - Util.getExtraTextPosition(ctx, TextType.TITLE, TextAxis.Y) + Util.getExtraTextPosition(ctx, TextType.DESCRIPTION, TextAxis.Y);
                    }
                    if (i2 == 1) {
                        if (hasStack || Util.shouldDisableIcon(ctx.stack())) {
                            y += 12;
                        }
                        if (Util.shouldDisableDividerLine(ctx)) {
                            y -= 6;
                        }
                    }
                    x2 = (int)pos.x;
                    x2 = i2 == 0 ? Util.getTitleAlignmentX(x2 + Util.getExtraTextPosition(ctx, TextType.TITLE, TextAxis.X) - (!hasStack ? 1 : 0), firstLineOffset, size, component2, font, ctx) : (x2 += TooltipRenderer.PADDING_X + Util.getExtraTextPosition(ctx, TextType.DESCRIPTION, TextAxis.X));
                    component2.renderText(font, x2, y, ctx.pose().last().pose(), ctx.graphics().bufferSource());
                    y += component2.getHeight();
                    if (!hasStack || i2 != 0 || ctx.getComponents().size() <= 1) continue;
                    y += 6;
                }
                y = (int)pos.y + TooltipRenderer.PADDING_Y + 6;
                for (i2 = 0; i2 < ctx.getComponents().size(); ++i2) {
                    component2 = (ClientTooltipComponent)ctx.getComponents().get(i2);
                    if (hasStack && i2 == 1) {
                        y += 12;
                    }
                    x2 = (int)pos.x + (i2 == 0 ? firstLineOffset : TooltipRenderer.PADDING_X);
                    component2.renderImage(font, x2, y, ctx.graphics());
                    y += component2.getHeight();
                    if (!hasStack || i2 != 0 || ctx.getComponents().size() <= 1) continue;
                    y += 6;
                }
                return;
            }
            int yTitle = (int)pos.y + TooltipRenderer.PADDING_Y + 3;
            if (!ctx.getComponents().isEmpty()) {
                ClientTooltipComponent title = (ClientTooltipComponent)ctx.getComponents().get(0);
                int xTitle = (int)pos.x + firstLineOffset;
                title.renderText(font, xTitle, yTitle, ctx.pose().last().pose(), ctx.graphics().bufferSource());
                ctx.flush();
            }
            int toLeft = (int)pos.x + TooltipRenderer.PADDING_X;
            int toTop = TooltipRenderer.LAST_POS_YI + TooltipRenderer.LAST_HEADER_ABS + 7;
            int toRight = (int)pos.x + size.x - TooltipRenderer.PADDING_X;
            int toBottom = Math.min(TooltipRenderer.LAST_POS_YI + size.y - TooltipRenderer.PADDING_Y - 1, ctx.height() - 4);
            ctx.graphics().enableScissor(toLeft, toTop, toRight, toBottom);
            int scroll = TooltipScrollState.getScroll();
            int y = TooltipRenderer.LAST_POS_YI + TooltipRenderer.LAST_HEADER_ABS - scroll;
            for (i = 1; i < ctx.getComponents().size(); ++i) {
                component = (ClientTooltipComponent)ctx.getComponents().get(i);
                x = (int)pos.x + TooltipRenderer.PADDING_X;
                h = component.getHeight();
                if (y + h >= toTop && y <= toBottom) {
                    component.renderText(font, x, y, ctx.pose().last().pose(), ctx.graphics().bufferSource());
                }
                y += h;
            }
            y = TooltipRenderer.LAST_POS_YI + TooltipRenderer.LAST_HEADER_ABS - scroll;
            for (i = 1; i < ctx.getComponents().size(); ++i) {
                component = (ClientTooltipComponent)ctx.getComponents().get(i);
                x = (int)pos.x + TooltipRenderer.PADDING_X;
                h = component.getHeight();
                if (y + h >= toTop && y <= toBottom) {
                    component.renderImage(font, x, y, ctx.graphics());
                }
                y += h;
            }
            ctx.graphics().disableScissor();
        });
    }
}

