/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.network;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.api.ItemTrashedEvent;
import net.blay09.mods.trashslot.api.ItemUntrashedEvent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record MessageTrashSlotClick(ItemStack itemStack, boolean isRightClick) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageTrashSlotClick> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"trashslot", (String)"trash_slot_click"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageTrashSlotClick> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MessageTrashSlotClick::itemStack, (StreamCodec)ByteBufCodecs.BOOL, MessageTrashSlotClick::isRightClick, MessageTrashSlotClick::new);

    public static void handle(ServerPlayer player, MessageTrashSlotClick message) {
        if (player.isSpectator()) {
            return;
        }
        ItemStack actualMouseItem = player.containerMenu.getCarried().copy();
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)actualMouseItem.getItem());
        if (registryName != null && TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
            return;
        }
        if (ItemStack.matches((ItemStack)actualMouseItem, (ItemStack)message.itemStack)) {
            if (actualMouseItem.isEmpty()) {
                ItemStack trashStack = TrashHelper.getTrashItem((Player)player);
                ItemStack mouseStack = message.isRightClick ? trashStack.split(1) : trashStack;
                player.containerMenu.setCarried(mouseStack);
                TrashHelper.setTrashItem((Player)player, message.isRightClick ? trashStack : ItemStack.EMPTY);
                Balm.getEvents().fireEvent((Object)new ItemUntrashedEvent((Player)player, mouseStack));
            } else {
                ItemStack trashStack = message.isRightClick ? actualMouseItem.split(1) : actualMouseItem;
                ItemTrashedEvent.Pre preEvent = new ItemTrashedEvent.Pre((Player)player, trashStack);
                Balm.getEvents().fireEvent((Object)preEvent);
                if (preEvent.isCanceled()) {
                    return;
                }
                TrashHelper.setTrashItem((Player)player, trashStack);
                player.containerMenu.setCarried(message.isRightClick ? actualMouseItem : ItemStack.EMPTY);
                Balm.getEvents().fireEvent((Object)new ItemTrashedEvent.Post((Player)player, trashStack));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

