/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.event;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import de.sarocesch.sarosmoneymod.init.ModItems;
import de.sarocesch.sarosmoneymod.init.ModVillagers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class ModEvents {
    @SubscribeEvent
    public static void onVillagerInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            Player player = event.getEntity();
            SarosMoneyMod.LOGGER.debug("Player interacted with villager: " + String.valueOf(villager));
            SarosMoneyMod.LOGGER.debug("Villager profession ID: " + String.valueOf(((ResourceKey)villager.getVillagerData().profession().unwrapKey().orElseThrow()).location()));
            SarosMoneyMod.LOGGER.debug("Our banker profession ID: " + String.valueOf(ModVillagers.BANKER.getId()));
            if (villager.getVillagerData().profession().unwrapKey().isPresent() && ((ResourceKey)villager.getVillagerData().profession().unwrapKey().get()).location().toString().equals(ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)((VillagerProfession)ModVillagers.BANKER.get())).toString())) {
                SarosMoneyMod.LOGGER.info("Player interacted with banker villager");
                if (!((Boolean)Config.VILLAGER_TRADES_ENABLED.get()).booleanValue()) {
                    SarosMoneyMod.LOGGER.debug("Villager trades disabled in config");
                    return;
                }
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    SarosMoneyMod.LOGGER.info("Player right-clicked on banker villager - trading should open");
                }
            }
        }
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        SarosMoneyMod.LOGGER.debug("VillagerTradesEvent fired for profession: " + String.valueOf(event.getType()));
        SarosMoneyMod.LOGGER.debug("Our banker profession: " + String.valueOf(ModVillagers.BANKER.get()));
        SarosMoneyMod.LOGGER.debug("Profession comparison: " + event.getType().equals(ModVillagers.BANKER.get()));
        SarosMoneyMod.LOGGER.debug("villagerTradesEnabled: " + String.valueOf(Config.VILLAGER_TRADES_ENABLED.get()));
        if (!((Boolean)Config.VILLAGER_TRADES_ENABLED.get()).booleanValue()) {
            SarosMoneyMod.LOGGER.debug("Villager trades disabled in config");
            return;
        }
        if (event.getType().location().toString().equals(ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)((VillagerProfession)ModVillagers.BANKER.get())).toString())) {
            SarosMoneyMod.LOGGER.info("Adding trades for banker profession");
            Int2ObjectMap trades = event.getTrades();
            ItemStack stack1 = new ItemStack((ItemLike)ModItems.EURO_1.get(), 1);
            int villagerLevel1 = 1;
            ((List)trades.get(villagerLevel1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RAW_IRON, ((Integer)Config.TRADE_L1_RAW_IRON_AMOUNT.get()).intValue()), stack1, 10, 8, 0.02f));
            ItemStack stack2 = new ItemStack((ItemLike)ModItems.EURO_5.get(), 1);
            int villagerLevel2 = 2;
            ((List)trades.get(villagerLevel2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DIAMOND, ((Integer)Config.TRADE_L2_DIAMOND_AMOUNT.get()).intValue()), stack2, 10, 8, 0.02f));
            ItemStack stack3 = new ItemStack((ItemLike)ModItems.EURO_1.get(), 1);
            int villagerLevel3 = 3;
            ((List)trades.get(villagerLevel3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RAW_COPPER, ((Integer)Config.TRADE_L3_RAW_COPPER_AMOUNT.get()).intValue()), stack3, 10, 8, 0.02f));
            ItemStack stack4a = new ItemStack((ItemLike)ModItems.EURO_1.get(), 1);
            ItemStack stack4b = new ItemStack((ItemLike)ModItems.EURO_5.get(), 1);
            int villagerLevel4 = 4;
            ((List)trades.get(villagerLevel4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.RAW_IRON, ((Integer)Config.TRADE_L4_RAW_IRON_AMOUNT.get()).intValue()), stack4a, 10, 8, 0.02f));
            ((List)trades.get(villagerLevel4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.DIAMOND, ((Integer)Config.TRADE_L4_DIAMOND_AMOUNT.get()).intValue()), stack4b, 10, 8, 0.02f));
            ItemStack stack5a = new ItemStack((ItemLike)ModItems.EURO_500.get(), 1);
            ItemStack stack5b = new ItemStack((ItemLike)ModItems.EURO_200.get(), 1);
            int villagerLevel5 = 5;
            ((List)trades.get(villagerLevel5)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, ((Integer)Config.TRADE_L5_GOLDEN_APPLE_AMOUNT.get()).intValue()), stack5a, 10, 8, 0.02f));
            ((List)trades.get(villagerLevel5)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.NETHER_STAR, ((Integer)Config.TRADE_L5_NETHER_STAR_AMOUNT.get()).intValue()), stack5b, 10, 8, 0.02f));
            SarosMoneyMod.LOGGER.info("Successfully added all trades for banker profession");
        }
    }
}

