/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static BlockPos getAttachedContainerPos(Level level, BlockPos signPos, BlockState signState) {
        Direction facing = Direction.NORTH;
        if (signState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            facing = (Direction)signState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        } else if (signState.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            int rotation = (Integer)signState.getValue((Property)BlockStateProperties.ROTATION_16);
            facing = Direction.from2DDataValue((int)(rotation / 2));
        }
        BlockPos containerPos = signPos.relative(facing.getOpposite());
        BlockEntity be = level.getBlockEntity(containerPos);
        if (!(be instanceof Container)) {
            for (Direction dir : Direction.values()) {
                BlockPos altPos;
                BlockEntity altBe;
                if (dir == facing || !((altBe = level.getBlockEntity(altPos = signPos.relative(dir))) instanceof Container)) continue;
                return altPos;
            }
        }
        return containerPos;
    }

    public static MutableComponent getFirstItemName(Level level, BlockPos containerPos) {
        BlockEntity be = level.getBlockEntity(containerPos);
        MutableComponent line = Component.literal((String)"Air").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty()) continue;
                return stack.getHoverName().copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
            }
        } else {
            LOGGER.warn("Kein Container an {}", (Object)containerPos);
        }
        return line;
    }
}

