/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import ipsis.woot.commands.CommandConfiguration;
import ipsis.woot.modules.factory.blocks.ControllerBlockEntity;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class GiveCommand {
    static final SuggestionProvider<CommandSourceStack> ENTITY_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet().stream(), (SuggestionsBuilder)builder);

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"give").requires(cs -> cs.hasPermission(((Integer)CommandConfiguration.COMMAND_LEVEL_GIVE.get()).intValue()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> GiveCommand.giveItem(((CommandSourceStack)ctx.getSource()).source, EntityArgument.getPlayer((CommandContext)ctx, (String)"target"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), ""))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> GiveCommand.giveItem(((CommandSourceStack)ctx.getSource()).source, EntityArgument.getPlayer((CommandContext)ctx, (String)"target"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag"))))));
    }

    private static int giveItem(CommandSource source, ServerPlayer target, ResourceLocation resourceLocation, String tag) {
        FakeMob fakeMob = new FakeMob();
        fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, target.level())) {
            ItemStack itemStack = ControllerBlockEntity.getItemStack(fakeMob);
            boolean added = target.getInventory().add(itemStack);
            if (added && itemStack.isEmpty()) {
                itemStack.setCount(1);
                ItemEntity itemEntity = target.drop(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.makeFakeItem();
                }
                target.level().playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((target.getRandom().nextFloat() - target.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                target.containerMenu.broadcastChanges();
            } else {
                ItemEntity itemEntity = target.drop(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.setNoPickUpDelay();
                }
            }
            source.sendSystemMessage((Component)Component.translatable((String)"commands.woot.give.ok", (Object[])new Object[]{target.getDisplayName(), resourceLocation.toString()}));
        } else {
            source.sendSystemMessage((Component)Component.translatable((String)"commands.woot.give.fail", (Object[])new Object[]{resourceLocation.toString()}));
        }
        return 1;
    }
}

