/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import ipsis.woot.config.Config;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class MobCommand {
    private static final String TAG = "commands.woot.mob.";
    static final SuggestionProvider<CommandSourceStack> ENTITY_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet().stream(), (SuggestionsBuilder)builder);

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"mob").then(InfoCommand.register());
    }

    private static int mobInfo(CommandContext<CommandSourceStack> source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel())) {
            int health = SpawnController.get().getMobHealth(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel());
            int xp = SpawnController.get().getMobExperience(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel());
            Tier mobTier = Config.OVERRIDE.getMobTier(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel());
            ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.mob.info.summary", (Object[])new Object[]{fakeMob, health, xp, mobTier}));
        }
        return 0;
    }

    private static class InfoCommand {
        private InfoCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"info").requires(cs -> cs.hasPermission(0))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> MobCommand.mobInfo((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), ""))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> MobCommand.mobInfo((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }
}

