/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import ipsis.woot.commands.CommandConfiguration;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SimulationCommand {
    private static final String TAG = "commands.woot.simulation.";
    static final SuggestionProvider<CommandSourceStack> ENTITY_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet().stream(), (SuggestionsBuilder)builder);

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"simulation").then(LearnCommand.register())).then(DumpCommand.register())).then(FlushCommand.register())).then(StatusCommand.register())).then(RollDropsCommand.register());
    }

    private static int rollDrops(CommandContext<CommandSourceStack> source, ResourceLocation resourceLocation, String tag, int looting) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel())) {
            List<ItemStack> drops = MobSimulator.getInstance().getRolledDrops(new FakeMobKey(fakeMob, looting));
            ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.simulation.roll", (Object[])new Object[]{fakeMob, looting, drops.stream().map(ItemStack::toString).collect(Collectors.joining(","))}));
        }
        return 0;
    }

    private static int learnEntity(CommandContext<CommandSourceStack> source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        String s = resourceLocation.toString();
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel())) {
            boolean result = MobSimulator.getInstance().learn(fakeMob);
            if (result) {
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.simulation.learn.ok", (Object[])new Object[]{resourceLocation.toString()}));
            } else {
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.simulation.learn.fail", (Object[])new Object[]{resourceLocation.toString()}));
            }
        } else {
            ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.simulation.learn.fail", (Object[])new Object[]{resourceLocation.toString()}));
        }
        return 0;
    }

    private static int dumpEntity(CommandContext<CommandSourceStack> source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel())) {
            for (SimulatedMobDropSummary summary : MobSimulator.getInstance().getDropSummary(fakeMob)) {
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.simulation.dump.drop", (Object[])new Object[]{summary}));
            }
        }
        return 0;
    }

    private static int status(CommandContext<CommandSourceStack> source) throws CommandSyntaxException {
        ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.simulation.status.simulating", (Object[])new Object[]{MobSimulator.getInstance().getSimulations().stream().map(FakeMobKey::toString).collect(Collectors.joining(","))}));
        ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.woot.simulation.status.waiting", (Object[])new Object[]{MobSimulator.getInstance().getWaiting().stream().map(FakeMobKey::toString).collect(Collectors.joining(","))}));
        return 0;
    }

    private static int flushEntity(CommandContext<CommandSourceStack> source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (Level)((CommandSourceStack)source.getSource()).getLevel())) {
            MobSimulator.getInstance().flush(fakeMob);
            MobSimulator.getInstance().learn(fakeMob);
        }
        return 0;
    }

    private static class LearnCommand {
        private LearnCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"learn").requires(cs -> cs.hasPermission(((Integer)CommandConfiguration.COMMAND_LEVEL_SIM_LEARN.get()).intValue()))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> SimulationCommand.learnEntity((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), ""))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> SimulationCommand.learnEntity((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }

    private static class DumpCommand {
        private DumpCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"dump").requires(cs -> cs.hasPermission(((Integer)CommandConfiguration.COMMAND_LEVEL_SIM_DUMP.get()).intValue()))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> SimulationCommand.dumpEntity((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), ""))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> SimulationCommand.dumpEntity((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }

    private static class FlushCommand {
        private FlushCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"flush").requires(cs -> cs.hasPermission(((Integer)CommandConfiguration.COMMAND_LEVEL_SIM_FLUSH.get()).intValue()))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> SimulationCommand.flushEntity((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), ""))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> SimulationCommand.flushEntity((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }

    private static class StatusCommand {
        private StatusCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"status").requires(cs -> cs.hasPermission(((Integer)CommandConfiguration.COMMAND_LEVEL_SIM_STATUS.get()).intValue()))).executes(ctx -> SimulationCommand.status((CommandContext<CommandSourceStack>)ctx));
        }
    }

    private static class RollDropsCommand {
        private RollDropsCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"roll").requires(cs -> cs.hasPermission(((Integer)CommandConfiguration.COMMAND_LEVEL_SIM_ROLL_DROPS.get()).intValue()))).then(Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).then(Commands.argument((String)"looting", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(ctx -> SimulationCommand.rollDrops((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), "", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"looting")))))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"looting", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(ctx -> SimulationCommand.rollDrops((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"entity"), "", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"looting")))));
        }
    }
}

