/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.anvil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.anvil.AnvilRecipeInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record AnvilRecipe(Ingredient baseItem, List<Ingredient> ingredients, ItemStack output) implements Recipe<AnvilRecipeInput>
{
    private static List<ItemStack> validInputs = new ArrayList<ItemStack>();

    public boolean matches(AnvilRecipeInput anvilRecipeInput, Level level) {
        if (!this.baseItem.test(anvilRecipeInput.getBase())) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (anvilRecipeInput.getItem(i).isEmpty()) continue;
            ++count;
        }
        if (this.ingredients.size() != count) {
            return false;
        }
        ArrayList<Integer> matchedSlots = new ArrayList<Integer>();
        block1: for (Ingredient ingredient : this.ingredients) {
            for (int i = 0; i < 4; ++i) {
                if (matchedSlots.contains(i) || !ingredient.test(anvilRecipeInput.getItem(i))) continue;
                matchedSlots.add(i);
                continue block1;
            }
        }
        return matchedSlots.size() == this.ingredients.size();
    }

    public ItemStack assemble(AnvilRecipeInput anvilRecipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WootRecipes.ANVIL_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)WootRecipes.ANVIL_RECIPE_TYPE.get();
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(ItemStack itemStack) {
        validInputs.add(itemStack);
    }

    public static boolean isValidInput(ItemStack itemStack) {
        for (ItemStack i : validInputs) {
            if (!i.is(itemStack.getItem())) continue;
            return true;
        }
        return false;
    }

    public static class AnvilRecipeType
    implements RecipeType<AnvilRecipe>,
    RecipeSerializer<AnvilRecipe> {
        public static final MapCodec<AnvilRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("baseItem").forGetter(AnvilRecipe::baseItem), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").forGetter(AnvilRecipe::ingredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(AnvilRecipe::output)).apply((Applicative)inst, AnvilRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AnvilRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AnvilRecipe::baseItem, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), AnvilRecipe::ingredients, (StreamCodec)ItemStack.STREAM_CODEC, AnvilRecipe::output, AnvilRecipe::new);

        public MapCodec<AnvilRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AnvilRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

