/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.anvil;

import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.anvil.AnvilRecipe;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeBuilder
implements RecipeBuilder {
    private final Ingredient baseIngredient;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;

    public AnvilRecipeBuilder(ItemStack result, Ingredient baseIngredient) {
        this.baseIngredient = baseIngredient;
        this.result = result;
        this.ingredients = NonNullList.create();
    }

    public static AnvilRecipeBuilder anvilRecipe(ItemStack result, Ingredient baseIngredient) {
        return new AnvilRecipeBuilder(result, baseIngredient);
    }

    public AnvilRecipeBuilder addIngredient(Ingredient ingredient) {
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public RecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return null;
    }

    public RecipeBuilder group(@Nullable String s) {
        return null;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        recipeOutput.accept(resourceLocation, (Recipe)new AnvilRecipe(this.baseIngredient, (List<Ingredient>)this.ingredients, this.result), null);
    }

    public static class Result
    implements CraftingRecipe {
        private final NonNullList<Ingredient> ingredients;
        private final Ingredient baseIngredient;
        private final ItemStack result;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Ingredient baseIngredient, ItemStack result, NonNullList<Ingredient> ingredients) {
            this.id = id;
            this.baseIngredient = baseIngredient;
            this.result = result;
            this.ingredients = ingredients;
        }

        public CraftingBookCategory category() {
            return null;
        }

        public boolean matches(CraftingInput craftingInput, Level level) {
            return false;
        }

        public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
            return null;
        }

        public boolean canCraftInDimensions(int i, int i1) {
            return false;
        }

        public ItemStack getResultItem(HolderLookup.Provider provider) {
            return this.result;
        }

        public RecipeSerializer<?> getSerializer() {
            return (RecipeSerializer)WootRecipes.ANVIL_RECIPE_SERIALIZER.get();
        }
    }
}

