/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.dyesqueezer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.fluilds.FluidSetup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public record DyeSqueezerRecipe(Ingredient input, int[] dyes, int energy) implements Recipe<RecipeInput>
{
    private static List<ItemStack> validInputs = new ArrayList<ItemStack>();

    public FluidStack getOutput() {
        return new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 72);
    }

    public int getRed() {
        return this.dyes[0];
    }

    public int getBlue() {
        return this.dyes[1];
    }

    public int getYellow() {
        return this.dyes[2];
    }

    public int getWhite() {
        return this.dyes[3];
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(ItemStack itemStack) {
        validInputs.add(itemStack);
    }

    public static boolean isValidInput(ItemStack itemStack) {
        for (ItemStack i : validInputs) {
            if (!i.is(itemStack.getItem())) continue;
            return true;
        }
        return false;
    }

    public List<List<ItemStack>> getInputs() {
        List<ItemStack> list = Arrays.asList(this.input.getItems());
        ArrayList<List<ItemStack>> arr = new ArrayList<List<ItemStack>>();
        arr.add(list);
        return arr;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return this.input.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WootRecipes.DYE_SQUEEZER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)WootRecipes.DYE_SQUEEZER_TYPE.get();
    }

    public static class DyeSqueezerRecipeType
    implements RecipeType<DyeSqueezerRecipe>,
    RecipeSerializer<DyeSqueezerRecipe> {
        public static final MapCodec<DyeSqueezerRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(DyeSqueezerRecipe::input), (App)Codec.INT.listOf().xmap(list -> list.stream().mapToInt(Integer::intValue).toArray(), array -> Arrays.stream(array).boxed().toList()).fieldOf("dyes").forGetter(DyeSqueezerRecipe::dyes), (App)Codec.INT.fieldOf("energy").forGetter(DyeSqueezerRecipe::energy)).apply((Applicative)inst, DyeSqueezerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DyeSqueezerRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DyeSqueezerRecipe::input, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeVarIntArray, FriendlyByteBuf::readVarIntArray), DyeSqueezerRecipe::dyes, (StreamCodec)ByteBufCodecs.VAR_INT, DyeSqueezerRecipe::energy, DyeSqueezerRecipe::new);

        public MapCodec<DyeSqueezerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DyeSqueezerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

