/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.dyesqueezer;

import ipsis.woot.crafting.dyesqueezer.DyeSqueezerRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class DyeSqueezerRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private final int energy;
    private final int[] dyes;

    public DyeSqueezerRecipeBuilder(Ingredient ingredient, int energy, int red, int yellow, int blue, int white) {
        this.ingredient = ingredient;
        this.energy = energy;
        this.dyes = new int[]{red, blue, yellow, white};
    }

    public static DyeSqueezerRecipeBuilder dyeSqueezerRecipe(Ingredient ingredient, int energy, int red, int yellow, int blue, int white) {
        return new DyeSqueezerRecipeBuilder(ingredient, energy, red, yellow, blue, white);
    }

    public RecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return null;
    }

    public RecipeBuilder group(@Nullable String s) {
        return null;
    }

    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        recipeOutput.accept(resourceLocation, (Recipe)new DyeSqueezerRecipe(this.ingredient, this.dyes, this.energy), null);
    }

    public void save(RecipeOutput recipeOutput, String id) {
        ResourceLocation res = ResourceLocation.parse((String)(this.dyes[0] + "_" + this.dyes[1] + "_" + this.dyes[2] + "_" + this.dyes[3] + "_" + id.toLowerCase()));
        this.save(recipeOutput, res);
    }

    public static class Result
    implements RecipeOutput {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final int energy;
        private final int red;
        private final int yellow;
        private final int blue;
        private final int white;

        private Result(ResourceLocation id, Ingredient ingredient, int energy, int[] dyes) {
            this.id = id;
            this.ingredient = ingredient;
            this.energy = energy;
            this.red = dyes[0];
            this.yellow = dyes[1];
            this.blue = dyes[2];
            this.white = dyes[3];
        }

        public Advancement.Builder advancement() {
            return null;
        }

        public void accept(ResourceLocation resourceLocation, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... iConditions) {
        }
    }
}

