/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.enchantsqueezer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.util.helper.EnchantmentHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public record EnchantSqueezerRecipe(Ingredient itemStack, FluidStack output, int energy) implements Recipe<SingleRecipeInput>
{
    public FluidStack getOutput() {
        return this.output;
    }

    public Ingredient getInput() {
        return this.itemStack;
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean matches(SingleRecipeInput singleRecipeInput, Level level) {
        ItemStack itemStack = singleRecipeInput.item();
        return !itemStack.isEmpty() && (EnchantmentHelper.isEnchanted(itemStack) || itemStack.is(Items.ENCHANTED_BOOK));
    }

    public ItemStack assemble(SingleRecipeInput singleRecipeInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return null;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WootRecipes.ENCHANT_SQUEEZER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)WootRecipes.ENCHANT_SQUEEZER_TYPE.get();
    }

    public static class EnchantSqueezerRecipeType
    implements RecipeSerializer<EnchantSqueezerRecipe>,
    RecipeType<EnchantSqueezerRecipe> {
        public static final MapCodec<EnchantSqueezerRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("item").forGetter(EnchantSqueezerRecipe::itemStack), (App)FluidStack.CODEC.fieldOf("outputFluid").forGetter(EnchantSqueezerRecipe::output), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("energy").forGetter(EnchantSqueezerRecipe::energy)).apply((Applicative)inst, EnchantSqueezerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EnchantSqueezerRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, EnchantSqueezerRecipe::itemStack, (StreamCodec)FluidStack.STREAM_CODEC, EnchantSqueezerRecipe::output, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantSqueezerRecipe::energy, EnchantSqueezerRecipe::new);

        public MapCodec<EnchantSqueezerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EnchantSqueezerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

