/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.factory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.util.FakeMob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public record FactoryRecipe(List<ItemStack> items, List<FluidStack> fluids, FakeMob fakeMob, List<Drop> drops) implements Recipe<RecipeInput>
{
    public FakeMob getFakeMob() {
        return this.fakeMob;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public List<Drop> getDrops() {
        return this.drops;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return true;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WootRecipes.FACTORY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)WootRecipes.FACTORY_RECIPE_TYPE.get();
    }

    public static class FactoryRecipeType
    implements RecipeType<FactoryRecipe>,
    RecipeSerializer<FactoryRecipe> {
        public static final MapCodec<FactoryRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.CODEC.listOf().fieldOf("ingredient").forGetter(FactoryRecipe::items), (App)FluidStack.CODEC.listOf().optionalFieldOf("fluids", Collections.emptyList()).forGetter(FactoryRecipe::fluids), (App)FakeMob.CODEC.fieldOf("fakeMob").forGetter(FactoryRecipe::fakeMob), (App)Drop.CODEC.listOf().fieldOf("drop").forGetter(FactoryRecipe::drops)).apply((Applicative)inst, FactoryRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FactoryRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ItemStack.STREAM_CODEC), FactoryRecipe::items, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)FluidStack.STREAM_CODEC), FactoryRecipe::fluids, FakeMob.STREAM_CODEC, FactoryRecipe::fakeMob, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, Drop.STREAM_CODEC), FactoryRecipe::drops, FactoryRecipe::new);

        public MapCodec<FactoryRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FactoryRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public record Drop(ItemStack itemStack, List<Integer> stackSizes, List<Float> dropChance) {
        public static final Codec<Drop> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.CODEC.fieldOf("itemstack").forGetter(Drop::itemStack), (App)ExtraCodecs.POSITIVE_INT.listOf().fieldOf("stacksizes").forGetter(Drop::stackSizes), (App)ExtraCodecs.POSITIVE_FLOAT.listOf().fieldOf("dropchance").forGetter(Drop::dropChance)).apply((Applicative)inst, Drop::new)));
        public static final StreamCodec<RegistryFriendlyByteBuf, Drop> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, Drop::itemStack, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.VAR_INT), Drop::stackSizes, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.FLOAT), Drop::dropChance, Drop::new);
    }
}

