/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.factory;

import ipsis.woot.crafting.factory.FactoryRecipe;
import ipsis.woot.util.FakeMob;
import java.util.ArrayList;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FactoryRecipeBuilder
implements RecipeBuilder {
    private final FakeMob result;
    private final ArrayList<ItemStack> items;
    private final ArrayList<FluidStack> fluids;
    private final ArrayList<FactoryRecipe.Drop> drops;

    public FactoryRecipeBuilder(FakeMob result) {
        this.result = result;
        this.items = new ArrayList();
        this.fluids = new ArrayList();
        this.drops = new ArrayList();
    }

    public static FactoryRecipeBuilder factoryRecipe(FakeMob result) {
        return new FactoryRecipeBuilder(result);
    }

    public FactoryRecipeBuilder addIngredient(ItemStack itemStack) {
        this.items.add(itemStack);
        return this;
    }

    public FactoryRecipeBuilder addIngredient(FluidStack fluidStack) {
        this.fluids.add(fluidStack);
        return this;
    }

    public FactoryRecipeBuilder addDrop(FactoryRecipe.Drop drop) {
        this.drops.add(drop);
        return this;
    }

    public RecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return null;
    }

    public RecipeBuilder group(@Nullable String s) {
        return null;
    }

    public Item getResult() {
        return this.drops.size() > 0 ? this.drops.getFirst().itemStack().getItem() : Items.AIR;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        recipeOutput.accept(resourceLocation, (Recipe)new FactoryRecipe(this.items, this.fluids, this.result, this.drops), null);
    }
}

