/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.fluidconvertor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.fluidconvertor.ConvertorRecipeInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public record FluidConvertorRecipe(Ingredient catalyst, int catalystCount, FluidStack inputFluid, FluidStack outputFluid, int energy) implements Recipe<ConvertorRecipeInput>
{
    private static List<ItemStack> validCatalysts = new ArrayList<ItemStack>();
    private static List<FluidStack> validInputs = new ArrayList<FluidStack>();
    private static List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public int getCatalystCount() {
        return this.catalystCount;
    }

    public FluidStack getOutput() {
        return this.outputFluid.copy();
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    @Override
    public String toString() {
        return "FluidConvertorRecipe{catalyst=" + String.valueOf(this.catalyst) + ", catalystCount=" + this.catalystCount + ", inputFluid=" + String.valueOf(this.inputFluid) + ", outputFluid=" + String.valueOf(this.outputFluid) + ", energy=" + this.energy + "}";
    }

    public static void clearValidCatalysts() {
        validCatalysts.clear();
    }

    public static void addValidCatalyst(ItemStack itemStack) {
        validCatalysts.add(itemStack);
    }

    public static boolean isValidCatalyst(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        for (ItemStack i : validCatalysts) {
            if (!i.is(itemStack.getItem())) continue;
            return true;
        }
        return false;
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(FluidStack fluidStack) {
        validInputs.add(fluidStack);
    }

    public static boolean isValidInput(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        for (FluidStack f : validInputs) {
            if (!f.is(fluidStack.getFluid())) continue;
            return true;
        }
        return false;
    }

    public List<List<ItemStack>> getInputs() {
        return inputs;
    }

    public boolean matches(ConvertorRecipeInput recipeInput, Level level) {
        return this.catalyst.test(recipeInput.getItem(0)) && recipeInput.getFluidStack().is(this.inputFluid.getFluidType());
    }

    public ItemStack assemble(ConvertorRecipeInput recipeInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WootRecipes.FLUID_CONVERTOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)WootRecipes.FLUID_CONVERTOR_TYPE.get();
    }

    public static class FluidConvertorRecipeType
    implements RecipeSerializer<FluidConvertorRecipe>,
    RecipeType<FluidConvertorRecipe> {
        public static final MapCodec<FluidConvertorRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("catalyst").forGetter(FluidConvertorRecipe::catalyst), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("catalystcount").forGetter(FluidConvertorRecipe::catalystCount), (App)FluidStack.CODEC.fieldOf("inputFluid").forGetter(FluidConvertorRecipe::inputFluid), (App)FluidStack.CODEC.fieldOf("outputFluid").forGetter(FluidConvertorRecipe::outputFluid), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("energy").forGetter(FluidConvertorRecipe::energy)).apply((Applicative)inst, FluidConvertorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidConvertorRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FluidConvertorRecipe::catalyst, (StreamCodec)ByteBufCodecs.VAR_INT, FluidConvertorRecipe::catalystCount, (StreamCodec)FluidStack.STREAM_CODEC, FluidConvertorRecipe::inputFluid, (StreamCodec)FluidStack.STREAM_CODEC, FluidConvertorRecipe::outputFluid, (StreamCodec)ByteBufCodecs.VAR_INT, FluidConvertorRecipe::energy, FluidConvertorRecipe::new);

        public MapCodec<FluidConvertorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidConvertorRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

