/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting.infuser;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ipsis.woot.crafting.WootRecipes;
import ipsis.woot.crafting.infuser.InfuserRecipeInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public record InfuserRecipe(Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluid, ItemStack result, int energy) implements Recipe<InfuserRecipeInput>
{
    private static List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private static List<ItemStack> validInputs = new ArrayList<ItemStack>();
    private static List<ItemStack> validAugments = new ArrayList<ItemStack>();
    private static List<FluidStack> validFluids = new ArrayList<FluidStack>();

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean hasAugment() {
        return this.augment != Ingredient.EMPTY;
    }

    public Ingredient getAugment() {
        return this.augment;
    }

    public int getAugmentCount() {
        return this.augmentCount;
    }

    public ItemStack getOutput() {
        return this.result;
    }

    public FluidStack getFluidInput() {
        return this.fluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public List<List<ItemStack>> getInputs() {
        return inputs;
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(ItemStack itemStack) {
        validInputs.add(itemStack);
    }

    public static boolean isValidInput(ItemStack itemStack) {
        for (ItemStack i : validInputs) {
            if (!i.is(itemStack.getItem())) continue;
            return true;
        }
        return false;
    }

    public static void clearValidAugments() {
        validAugments.clear();
    }

    public static void addValidAugment(ItemStack itemStack) {
        validAugments.add(itemStack);
    }

    public static boolean isValidAugment(ItemStack itemStack) {
        for (ItemStack i : validAugments) {
            if (!i.is(itemStack.getItem())) continue;
            return true;
        }
        return false;
    }

    public static void clearValidFluids() {
        validFluids.clear();
    }

    public static void addValidFluid(FluidStack fluidStack) {
        validFluids.add(fluidStack);
    }

    public static boolean isValidFluid(FluidStack fluidStack) {
        for (FluidStack f : validFluids) {
            if (!f.is(fluidStack.getFluid())) continue;
            return true;
        }
        return false;
    }

    public boolean matches(InfuserRecipeInput recipeInput, Level level) {
        if (!this.ingredient.test(recipeInput.getItem(0))) {
            return false;
        }
        if (!(this.augment == Ingredient.EMPTY || this.augment.test(recipeInput.getAugment()) && this.augmentCount <= recipeInput.getAugment().getCount())) {
            return false;
        }
        if (this.fluid != FluidStack.EMPTY) {
            return this.fluid.is(recipeInput.fluid().getFluidType());
        }
        return true;
    }

    public ItemStack assemble(InfuserRecipeInput recipeInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WootRecipes.INFUSER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)WootRecipes.INFUSER_TYPE.get();
    }

    public static class InfuserRecipeType
    implements RecipeType<InfuserRecipe>,
    RecipeSerializer<InfuserRecipe> {
        public static final MapCodec<InfuserRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(InfuserRecipe::ingredient), (App)Ingredient.CODEC.fieldOf("augment").forGetter(InfuserRecipe::augment), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("augmentcount").forGetter(InfuserRecipe::augmentCount), (App)FluidStack.CODEC.fieldOf("fluidstack").forGetter(InfuserRecipe::fluid), (App)ItemStack.CODEC.fieldOf("result").forGetter(InfuserRecipe::result), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("energy").forGetter(InfuserRecipe::energy)).apply((Applicative)inst, InfuserRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfuserRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, InfuserRecipe::ingredient, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, InfuserRecipe::augment, (StreamCodec)ByteBufCodecs.VAR_INT, InfuserRecipe::augmentCount, (StreamCodec)FluidStack.STREAM_CODEC, InfuserRecipe::fluid, (StreamCodec)ItemStack.STREAM_CODEC, InfuserRecipe::result, (StreamCodec)ByteBufCodecs.VAR_INT, InfuserRecipe::energy, InfuserRecipe::new);

        public MapCodec<InfuserRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfuserRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

