/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.datagen;

import ipsis.woot.modules.factory.FactorySetup;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagsGen
extends IntrinsicHolderTagsProvider<Item> {
    public static final TagKey<Item> FACTORY_BLOCK = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"woot:factory_blocks"));

    public ItemTagsGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, Registries.ITEM, lookupProvider, item -> item.builtInRegistryHolder().key(), "woot", existingFileHelper);
    }

    private void addColored(Consumer<TagKey<Item>> consumer, TagKey<Item> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor dyeColor : DyeColor.values()) {
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)"woot", (String)pattern.replace("{color}", dyeColor.getName()));
            TagKey<Item> tag = this.getForgeItemTag(prefix + dyeColor.getName());
            Item item = (Item)BuiltInRegistries.ITEM.get(key);
            this.tag(tag).add((Object)item);
            consumer.accept(tag);
        }
    }

    private TagKey<Item> getForgeItemTag(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name.toLowerCase()));
    }

    public String getName() {
        return "Woot Item Tags";
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_A_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_B_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_C_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_D_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_E_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_CONNECT_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_CTR_BASE_PRI_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_CTR_BASE_SEC_BLOCK_ITEM.get()));
        this.tag(FACTORY_BLOCK).add((Object)((Item)FactorySetup.FACTORY_UPGRADE_BLOCK_ITEM.get()));
        this.addColored(iTag -> this.tag(Tags.Items.DYES).addTag(iTag), (TagKey<Item>)Tags.Items.DYES, "{color}_dyeplate");
    }
}

